/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.dev.testing.ExceptionReporting;
import io.quarkus.dev.testing.TracingHandler;
import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.DurationConverter;
import io.quarkus.runtime.logging.JBossVersion;
import io.quarkus.runtime.test.TestHttpEndpointProvider;
import io.quarkus.test.TestMethodInvoker;
import io.quarkus.test.common.GroovyClassValue;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.RestorableSystemProperties;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestScopeManager;
import io.quarkus.test.common.http.TestHTTPEndpoint;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit.AbstractJvmQuarkusTestExtension;
import io.quarkus.test.junit.AbstractTestWithCallbacksExtension;
import io.quarkus.test.junit.AppMakerHelper;
import io.quarkus.test.junit.IntegrationTestUtil;
import io.quarkus.test.junit.MockSupport;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.QuarkusTestExtensionState;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestResourceUtil;
import io.quarkus.test.junit.callback.QuarkusTestContext;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.opentest4j.TestAbortedException;

public class QuarkusTestExtension
extends AbstractJvmQuarkusTestExtension
implements BeforeEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
AfterEachCallback,
BeforeAllCallback,
InvocationInterceptor,
AfterAllCallback,
ParameterResolver {
    private static final Logger log = Logger.getLogger(QuarkusTestExtension.class);
    public static final String QUARKUS_TEST_HANG_DETECTION_TIMEOUT = "quarkus.test.hang-detection-timeout";
    private static boolean failedBoot;
    private static Class<?> actualTestClass;
    private static Object actualTestInstance;
    private static final Deque<Object> outerInstances;
    private static Throwable firstException;
    private static Class<?> quarkusTestMethodContextClass;
    private static List<Function<Class<?>, String>> testHttpEndpointProviders;
    private static List<Object> testMethodInvokers;
    private static volatile ScheduledExecutorService hangDetectionExecutor;
    private static volatile Duration hangTimeout;
    private static volatile ScheduledFuture<?> hangTaskKey;
    private static final Runnable hangDetectionTask;

    private ExtensionState doJavaStart(ExtensionContext context, Class<? extends QuarkusTestProfile> profile) throws Throwable {
        JBossVersion.disableVersionLogging();
        TracingHandler.quarkusStarting();
        hangDetectionExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Quarkus hang detection timer thread");
            }
        });
        String time = "10m";
        String sysPropString = System.getProperty(QUARKUS_TEST_HANG_DETECTION_TIMEOUT);
        if (sysPropString != null) {
            time = sysPropString;
        }
        hangTimeout = new DurationConverter().convert(time);
        hangTaskKey = hangDetectionExecutor.schedule(hangDetectionTask, hangTimeout.toMillis(), TimeUnit.MILLISECONDS);
        quarkusTestProfile = profile;
        final Class requiredTestClass = context.getRequiredTestClass();
        Closeable testResourceManager = null;
        try {
            final LinkedBlockingDeque<Runnable> shutdownTasks = new LinkedBlockingDeque<Runnable>();
            testHttpEndpointProviders = TestHttpEndpointProvider.load();
            System.clearProperty("test.url");
            QuarkusTestProfile profileInstance = AppMakerHelper.getQuarkusTestProfile(profile);
            if (profileInstance != null) {
                Runnable configCleaner = AppMakerHelper.setExtraPropertiesRestorably(profile, profileInstance);
                shutdownTasks.add(configCleaner);
            }
            StartupAction startupAction = QuarkusTestExtension.getClassLoaderFromTestClass(requiredTestClass).getStartupAction();
            CuratedApplication curatedApplication = startupAction.getClassLoader().getCuratedApplication();
            Path testClassLocation = PathTestHelper.getTestClassesLocation((Class)requiredTestClass, (CuratedApplication)curatedApplication);
            Class testResourceManagerClass = startupAction.getClassLoader().loadClass(TestResourceManager.class.getName());
            testResourceManager = TestResourceUtil.TestResourceManagerReflections.createReflectively(testResourceManagerClass, requiredTestClass, profile, TestResourceUtil.TestResourceManagerReflections.copyEntriesFromProfile(profileInstance, (ClassLoader)startupAction.getClassLoader()), profileInstance != null && profileInstance.disableGlobalTestResources(), startupAction.getDevServicesProperties(), Optional.ofNullable(startupAction.getDevServicesNetworkId()), testClassLocation);
            TestResourceUtil.TestResourceManagerReflections.initReflectively(testResourceManager, profile);
            Map<String, String> properties = TestResourceUtil.TestResourceManagerReflections.startReflectively(testResourceManager);
            startupAction.overrideConfig(properties);
            startupAction.addRuntimeCloseTask(testResourceManager);
            quarkusTestMethodContextClass = null;
            this.populateCallbacks((ClassLoader)startupAction.getClassLoader());
            this.populateTestMethodInvokers((ClassLoader)startupAction.getClassLoader());
            if (profileInstance == null || !profileInstance.runMainMethod()) {
                runningQuarkusApplication = startupAction.run(profileInstance == null ? new String[]{} : profileInstance.commandLineParameters());
            } else {
                Class<?> lifecycleManager = Class.forName(ApplicationLifecycleManager.class.getName(), true, (ClassLoader)startupAction.getClassLoader());
                lifecycleManager.getDeclaredMethod("setDefaultExitCodeHandler", Consumer.class).invoke(null, integer -> {});
                runningQuarkusApplication = startupAction.runMainClass(profileInstance.commandLineParameters());
            }
            TracingHandler.quarkusStarted();
            if (hangTaskKey != null) {
                hangTaskKey.cancel(false);
                hangTimeout = runningQuarkusApplication.getConfigValue(QUARKUS_TEST_HANG_DETECTION_TIMEOUT, Duration.class).orElse(Duration.of(10L, ChronoUnit.MINUTES));
                hangTaskKey = hangDetectionExecutor.schedule(hangDetectionTask, hangTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            final RestorableSystemProperties restorableSystemProperties = RestorableSystemProperties.setProperties(Collections.singletonMap("test.url", TestHTTPResourceManager.getUri((RunningQuarkusApplication)runningQuarkusApplication)), (String[])new String[0]);
            Closeable shutdownTask = new Closeable(){

                @Override
                public void close() {
                    TracingHandler.quarkusStopping();
                    try {
                        if (AbstractJvmQuarkusTestExtension.runningQuarkusApplication != null) {
                            AbstractJvmQuarkusTestExtension.runningQuarkusApplication.close();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        TracingHandler.quarkusStopped();
                        try {
                            while (!shutdownTasks.isEmpty()) {
                                ((Runnable)shutdownTasks.pop()).run();
                            }
                        }
                        finally {
                            restorableSystemProperties.close();
                            QuarkusTestExtension.this.shutdownHangDetection();
                        }
                        try {
                            TestClassIndexer.removeIndex((Class)requiredTestClass);
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            return new ExtensionState(testResourceManager, shutdownTask, AbstractTestWithCallbacksExtension::clearCallbacks);
        }
        catch (Throwable e) {
            if (!InitialConfigurator.DELAYED_HANDLER.isActivated()) {
                IntegrationTestUtil.activateLogging();
            }
            Throwable effectiveException = this.determineEffectiveException(e);
            try {
                if (testResourceManager != null) {
                    testResourceManager.close();
                }
            }
            catch (Exception ex) {
                effectiveException.addSuppressed(this.determineEffectiveException(ex));
            }
            throw effectiveException;
        }
    }

    private static QuarkusClassLoader getClassLoaderFromTestClass(Class<?> requiredTestClass) {
        try {
            return (QuarkusClassLoader)requiredTestClass.getClassLoader();
        }
        catch (ClassCastException e) {
            boolean isSurefire3;
            boolean isSurefire;
            if (requiredTestClass.getClassLoader().getName().contains("QuarkusClassLoader")) {
                throw new RuntimeException("Internal error. The test class " + String.valueOf(requiredTestClass) + " was not loaded with the expected classloader. Expected a QuarkusClassLoader loaded with " + String.valueOf(QuarkusClassLoader.class.getClassLoader()) + " but was " + String.valueOf(requiredTestClass.getClassLoader()) + " This should not happen, but changing directory names or class layout may help work around the issue.");
            }
            boolean bl = isSurefire = System.getProperty("surefire.real.class.path") != null;
            if (isSurefire && !(isSurefire3 = System.getProperty("surefire.real.class.path").contains("_3.jar"))) {
                throw new RuntimeException("The test class " + String.valueOf(requiredTestClass) + " should have been loaded with a QuarkusClassLoader, but instead it was loaded with " + String.valueOf(requiredTestClass.getClassLoader()) + ". Is the version of the Surefire plugin at least 3.x?");
            }
            throw new RuntimeException("Internal error. The test class " + String.valueOf(requiredTestClass) + " should have been loaded with a QuarkusClassLoader, but instead it was loaded with " + String.valueOf(requiredTestClass.getClassLoader()) + ". This is caused by the FacadeClassLoader not correctly identifying this class as a QuarkusTest.");
        }
    }

    private Throwable determineEffectiveException(Throwable e) {
        Throwable effectiveException = e;
        if (e instanceof InvocationTargetException && e.getCause() != null && (effectiveException = e.getCause()) instanceof CompletionException && effectiveException.getCause() != null) {
            effectiveException = effectiveException.getCause();
        }
        return effectiveException;
    }

    private void shutdownHangDetection() {
        ScheduledExecutorService h;
        if (hangTaskKey != null) {
            hangTaskKey.cancel(true);
            hangTaskKey = null;
        }
        if ((h = hangDetectionExecutor) != null) {
            h.shutdownNow();
            hangDetectionExecutor = null;
        }
    }

    private void populateTestMethodInvokers(ClassLoader quarkusClassLoader) {
        testMethodInvokers = new ArrayList<Object>();
        try {
            ServiceLoader<?> loader = ServiceLoader.load(quarkusClassLoader.loadClass(TestMethodInvoker.class.getName()), quarkusClassLoader);
            for (Object testMethodInvoker : loader) {
                testMethodInvokers.add(testMethodInvoker);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        if (this.isNativeOrIntegrationTest(context.getRequiredTestClass()) || this.isBeforeTestCallbacksEmpty()) {
            return;
        }
        if (!failedBoot) {
            Map.Entry<Class<?>, ?> tuple = this.createQuarkusTestMethodContextTuple(context);
            this.invokeBeforeTestExecutionCallbacks(tuple.getKey(), tuple.getValue());
        } else {
            this.throwBootFailureException();
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.isNativeOrIntegrationTest(context.getRequiredTestClass())) {
            return;
        }
        QuarkusTestExtension.resetHangTimeout();
        if (!failedBoot) {
            this.pushMockContext();
            Map.Entry<Class<?>, ?> tuple = this.createQuarkusTestMethodContextTuple(context);
            this.invokeBeforeEachCallbacks(tuple.getKey(), tuple.getValue());
            String endpointPath = QuarkusTestExtension.getEndpointPath(context, testHttpEndpointProviders);
            if (runningQuarkusApplication != null) {
                boolean secure = false;
                Optional insecureAllowed = runningQuarkusApplication.getConfigValue("quarkus.http.insecure-requests", String.class);
                if (insecureAllowed.isPresent()) {
                    secure = !((String)insecureAllowed.get()).toLowerCase(Locale.ENGLISH).equals("enabled");
                }
                runningQuarkusApplication.getClassLoader().loadClass(RestAssuredURLManager.class.getName()).getDeclaredMethod("setURL", Boolean.TYPE, String.class).invoke(null, secure, endpointPath);
                runningQuarkusApplication.getClassLoader().loadClass(TestScopeManager.class.getName()).getDeclaredMethod("setup", Boolean.TYPE).invoke(null, false);
            }
        } else {
            this.throwBootFailureException();
        }
    }

    public static String getEndpointPath(ExtensionContext context, List<Function<Class<?>, String>> testHttpEndpointProviders) {
        String endpointPath = null;
        TestHTTPEndpoint testHTTPEndpoint = context.getRequiredTestMethod().getAnnotation(TestHTTPEndpoint.class);
        if (testHTTPEndpoint == null) {
            Class clazz = context.getRequiredTestClass();
            while ((testHTTPEndpoint = clazz.getAnnotation(TestHTTPEndpoint.class)) == null && (clazz = clazz.getSuperclass()) != Object.class) {
            }
        }
        if (testHTTPEndpoint != null) {
            Object value = "[no value]";
            for (Function<Class<?>, String> i : testHttpEndpointProviders) {
                try {
                    Method m = TestHTTPEndpoint.class.getMethod("value", new Class[0]);
                    value = m.invoke((Object)testHTTPEndpoint, new Object[0]);
                    endpointPath = i.apply((Class)value);
                    if (endpointPath == null) continue;
                    break;
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (endpointPath == null) {
                throw new RuntimeException("Cannot determine HTTP path for endpoint " + String.valueOf(value) + " for test method " + String.valueOf(context.getRequiredTestMethod()));
            }
        }
        if (endpointPath != null && endpointPath.indexOf(58) != -1) {
            return QuarkusTestExtension.sanitizeEndpointPath(endpointPath);
        }
        return endpointPath;
    }

    private static String sanitizeEndpointPath(String path) {
        int openBrackets = 0;
        boolean inRegex = false;
        StringBuilder replaced = new StringBuilder(path.length() - 1);
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '{') {
                ++openBrackets;
            } else if (c == '}') {
                if (--openBrackets == 0) {
                    inRegex = false;
                }
            } else if (c == ':' && openBrackets > 0) {
                inRegex = true;
            }
            if (inRegex) continue;
            replaced.append(c);
        }
        return replaced.toString();
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        if (this.isNativeOrIntegrationTest(context.getRequiredTestClass()) || this.isAfterTestCallbacksEmpty()) {
            return;
        }
        if (!failedBoot) {
            Map.Entry<Class<?>, ?> tuple = this.createQuarkusTestMethodContextTuple(context);
            this.invokeAfterTestExecutionCallbacks(tuple.getKey(), tuple.getValue());
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.isNativeOrIntegrationTest(context.getRequiredTestClass())) {
            return;
        }
        QuarkusTestExtension.resetHangTimeout();
        if (!failedBoot) {
            this.popMockContext();
            Map.Entry<Class<?>, ?> tuple = this.createQuarkusTestMethodContextTuple(context);
            this.invokeAfterEachCallbacks(tuple.getKey(), tuple.getValue());
            runningQuarkusApplication.getClassLoader().loadClass(RestAssuredURLManager.class.getName()).getDeclaredMethod("clearURL", new Class[0]).invoke(null, new Object[0]);
            runningQuarkusApplication.getClassLoader().loadClass(TestScopeManager.class.getName()).getDeclaredMethod("tearDown", Boolean.TYPE).invoke(null, false);
        }
    }

    private Map.Entry<Class<?>, ?> createQuarkusTestMethodContextTuple(ExtensionContext context) throws Exception {
        ClassLoader classLoader = runningQuarkusApplication.getClassLoader();
        if (quarkusTestMethodContextClass == null) {
            quarkusTestMethodContextClass = Class.forName(QuarkusTestMethodContext.class.getName(), true, classLoader);
        }
        Method originalTestMethod = context.getRequiredTestMethod();
        Class<?>[] originalParameterTypes = originalTestMethod.getParameterTypes();
        Method actualTestMethod = null;
        Class<?> c = this.resolveDeclaringClass(originalTestMethod, actualTestClass);
        ArrayList parameterTypesFromTccl = new ArrayList(originalParameterTypes.length);
        for (Class<?> type : originalParameterTypes) {
            if (type.isPrimitive()) {
                parameterTypesFromTccl.add(type);
                continue;
            }
            parameterTypesFromTccl.add(Class.forName(type.getName(), true, classLoader));
        }
        Class[] parameterTypes = parameterTypesFromTccl.toArray(new Class[0]);
        try {
            if (c != null) {
                actualTestMethod = c.getDeclaredMethod(originalTestMethod.getName(), parameterTypes);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (actualTestMethod == null) {
            throw new RuntimeException("Could not find method " + String.valueOf(originalTestMethod) + " on test class");
        }
        QuarkusTestExtensionState state = this.getState(context);
        Constructor<?> constructor = quarkusTestMethodContextClass.getConstructor(Object.class, List.class, Method.class, Throwable.class);
        return new AbstractMap.SimpleEntry(quarkusTestMethodContextClass, constructor.newInstance(actualTestInstance, new ArrayList<Object>(outerInstances), actualTestMethod, state.getTestErrorCause()));
    }

    private boolean isNativeOrIntegrationTest(Class<?> clazz) {
        for (Class i : currentTestClassStack) {
            if (!i.isAnnotationPresent(QuarkusIntegrationTest.class)) continue;
            return true;
        }
        return clazz.isAnnotationPresent(QuarkusIntegrationTest.class);
    }

    private QuarkusTestExtensionState ensureStarted(ExtensionContext extensionContext) {
        boolean isSameCuratedApplication;
        boolean isNewTestClass;
        QuarkusTestExtensionState state = this.getState(extensionContext);
        Class<? extends QuarkusTestProfile> selectedProfile = this.getQuarkusTestProfile(extensionContext);
        boolean wrongProfile = !Objects.equals(selectedProfile, quarkusTestProfile);
        boolean isNested = this.isNested(currentJUnitTestClass, extensionContext.getRequiredTestClass());
        if (wrongProfile && isNested) {
            throw new TestInstantiationException("@Nested tests may not contain @TestProfile annotations.");
        }
        boolean bl = isNewTestClass = !Objects.equals(extensionContext.getRequiredTestClass(), currentJUnitTestClass) && !isNested;
        if (isNewTestClass && state != null) {
            state.setTestFailed(null);
            currentJUnitTestClass = extensionContext.getRequiredTestClass();
        }
        boolean isNewApplication = this.isNewApplication(state, extensionContext.getRequiredTestClass());
        QuarkusClassLoader cl = QuarkusTestExtension.getClassLoaderFromTestClass(extensionContext.getRequiredTestClass());
        CuratedApplication curatedApplication = runningQuarkusApplication != null ? ((QuarkusClassLoader)runningQuarkusApplication.getClassLoader()).getCuratedApplication() : null;
        boolean bl2 = isSameCuratedApplication = cl.getCuratedApplication() == curatedApplication;
        if (cl.getCuratedApplication() == null) {
            throw new IllegalStateException("Internal error: ClassLoader " + String.valueOf(cl) + " does not have a linked curated application.");
        }
        cl.getCuratedApplication().setEligibleForReuse(isSameCuratedApplication);
        if (state == null && !failedBoot || runningQuarkusApplication != null && isNewApplication) {
            if (isNewApplication && state != null) {
                try {
                    state.close();
                }
                catch (Throwable throwable) {
                    this.markTestAsFailed(extensionContext, throwable);
                }
            }
            PropertyTestUtil.setLogFileProperty();
            try {
                state = this.doJavaStart(extensionContext, selectedProfile);
                this.setState(extensionContext, state);
            }
            catch (Throwable e) {
                failedBoot = true;
                this.markTestAsFailed(extensionContext, e);
                firstException = e;
                this.getStoreFromContext(extensionContext).put((Object)FailedCleanup.class.getName(), (Object)new FailedCleanup());
            }
        }
        return state;
    }

    private boolean isNested(Class<?> outerClass, Class<?> innerClass) {
        if (outerClass == null || innerClass == null || innerClass.getEnclosingClass() == null) {
            return false;
        }
        Class<?> enclosingTestClass = innerClass.getEnclosingClass();
        return Objects.equals(outerClass, enclosingTestClass) || this.isNested(outerClass, enclosingTestClass);
    }

    private void throwBootFailureException() {
        if (firstException != null) {
            Throwable throwable = firstException;
            firstException = null;
            throw new RuntimeException(throwable);
        }
        throw new TestAbortedException("Boot failed");
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        Class requiredTestClass = context.getRequiredTestClass();
        GroovyClassValue.disable();
        currentTestClassStack.push(requiredTestClass);
        LaunchMode.set((LaunchMode)LaunchMode.TEST);
        if (this.isNativeOrIntegrationTest(requiredTestClass)) {
            return;
        }
        QuarkusTestExtension.resetHangTimeout();
        this.ensureStarted(context);
        if (runningQuarkusApplication != null) {
            this.pushMockContext();
            this.invokeBeforeClassCallbacks(Class.class, runningQuarkusApplication.getClassLoader().loadClass(requiredTestClass.getName()));
        } else {
            this.invokeBeforeClassCallbacks(Class.class, requiredTestClass);
        }
    }

    private void pushMockContext() {
        try {
            Method pushContext = runningQuarkusApplication.getClassLoader().loadClass(MockSupport.class.getName()).getDeclaredMethod("pushContext", new Class[0]);
            pushContext.setAccessible(true);
            pushContext.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void popMockContext() {
        try {
            Method popContext = runningQuarkusApplication.getClassLoader().loadClass(MockSupport.class.getName()).getDeclaredMethod("popContext", new Class[0]);
            popContext.setAccessible(true);
            popContext.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            invocation.proceed();
            return;
        }
        QuarkusTestExtension.resetHangTimeout();
        this.ensureStarted(extensionContext);
        if (failedBoot) {
            this.throwBootFailureException();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    public <T> T interceptTestClassConstructor(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Constructor<T>> invocationContext, ExtensionContext extensionContext) throws Throwable {
        Object result;
        QuarkusTestExtensionState state;
        Class requiredTestClass = extensionContext.getRequiredTestClass();
        if (this.isNativeOrIntegrationTest(requiredTestClass)) {
            return (T)invocation.proceed();
        }
        boolean isOuterClassOfNestedTest = false;
        if (currentTestClassStack.size() > 1 && currentTestClassStack.contains(requiredTestClass) && !((Class)currentTestClassStack.peek()).equals(requiredTestClass)) {
            isOuterClassOfNestedTest = true;
        }
        QuarkusTestExtension.resetHangTimeout();
        QuarkusTestExtensionState quarkusTestExtensionState = state = isOuterClassOfNestedTest ? this.getState(extensionContext) : this.ensureStarted(extensionContext);
        if (failedBoot) {
            this.throwBootFailureException();
            return null;
        }
        try {
            result = invocation.proceed();
        }
        catch (NullPointerException e) {
            throw new RuntimeException("When using constructor injection in a test, the only legal operation is to assign the constructor values to fields. Offending class is " + String.valueOf(requiredTestClass), e);
        }
        this.initTestState(extensionContext, state);
        return (T)result;
    }

    private void initTestState(ExtensionContext extensionContext, QuarkusTestExtensionState state) {
        try {
            actualTestClass = extensionContext.getRequiredTestClass();
            if (extensionContext.getRequiredTestClass().isAnnotationPresent(Nested.class)) {
                Class<?> outerClass = actualTestClass.getEnclosingClass();
                Constructor<?> declaredConstructor = actualTestClass.getDeclaredConstructor(outerClass);
                declaredConstructor.setAccessible(true);
                if (outerClass.isInstance(actualTestInstance)) {
                    outerInstances.add(actualTestInstance);
                    actualTestInstance = declaredConstructor.newInstance(actualTestInstance);
                } else {
                    Object outerInstance = this.createActualTestInstance(outerClass, state);
                    this.invokeAfterConstructCallbacks(Object.class, outerInstance);
                    actualTestInstance = declaredConstructor.newInstance(outerInstance);
                    outerInstances.add(outerInstance);
                }
            } else {
                outerInstances.clear();
                actualTestInstance = this.createActualTestInstance(actualTestClass, state);
            }
            this.invokeAfterConstructCallbacks(Object.class, actualTestInstance);
        }
        catch (Exception e) {
            throw new TestInstantiationException("Failed to create test instance", e instanceof InvocationTargetException ? e.getCause() : e);
        }
    }

    private Object createActualTestInstance(Class<?> testClass, QuarkusTestExtensionState state) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object testInstance = runningQuarkusApplication.instance(testClass, new Annotation[0]);
        Class<?> resM = Thread.currentThread().getContextClassLoader().loadClass(TestHTTPResourceManager.class.getName());
        resM.getDeclaredMethod("inject", Object.class, List.class).invoke(null, testInstance, testHttpEndpointProviders);
        state.testResourceManager.getClass().getMethod("inject", Object.class).invoke((Object)state.testResourceManager, testInstance);
        return testInstance;
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext, true);
        invocation.skip();
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            invocation.proceed();
            return;
        }
        CopyOnWriteArrayList serverExceptions = new CopyOnWriteArrayList();
        ExceptionReporting.setListener(serverExceptions::add);
        try {
            this.runExtensionMethod(invocationContext, extensionContext, true);
            invocation.skip();
        }
        catch (Throwable t) {
            for (Throwable serverException : serverExceptions) {
                if (t == serverException) continue;
                t.addSuppressed(serverException);
            }
            throw t;
        }
        finally {
            ExceptionReporting.setListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interceptDynamicTest(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext) throws Throwable {
        if (runningQuarkusApplication == null) {
            invocation.proceed();
            return;
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(runningQuarkusApplication.getClassLoader());
            invocation.proceed();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            return (T)invocation.proceed();
        }
        Object result = this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
        return (T)result;
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext, true);
        invocation.skip();
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (runningQuarkusApplication == null || this.isNativeOrIntegrationTest(extensionContext.getRequiredTestClass())) {
            invocation.proceed();
            return;
        }
        this.runExtensionMethod(invocationContext, extensionContext);
        invocation.skip();
    }

    private Object runExtensionMethod(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        return this.runExtensionMethod(invocationContext, extensionContext, false);
    }

    private Object runExtensionMethod(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, boolean testMethodInvokersAllowed) throws Throwable {
        QuarkusTestExtension.resetHangTimeout();
        try {
            Class testClassFromTCCL = extensionContext.getRequiredTestClass();
            HashMap<Class, Object> allTestsClasses = new HashMap<Class, Object>();
            allTestsClasses.put(testClassFromTCCL, actualTestInstance);
            outerInstances.forEach(i -> allTestsClasses.put(i.getClass(), i));
            Method newMethod = null;
            Object effectiveTestInstance = null;
            for (Map.Entry entry : allTestsClasses.entrySet()) {
                newMethod = this.determineTCCLExtensionMethod((Method)invocationContext.getExecutable(), (Class)entry.getKey());
                if (newMethod == null) continue;
                effectiveTestInstance = entry.getValue();
                break;
            }
            if (newMethod == null) {
                throw new RuntimeException("Could not find method " + String.valueOf(invocationContext.getExecutable()) + " on test class");
            }
            newMethod.setAccessible(true);
            Object testMethodInvokerToUse = null;
            if (testMethodInvokersAllowed) {
                for (Object object : testMethodInvokers) {
                    boolean supportsMethod = (Boolean)object.getClass().getMethod("supportsMethod", Class.class, Method.class).invoke(object, extensionContext.getRequiredTestClass(), invocationContext.getExecutable());
                    if (!supportsMethod) continue;
                    testMethodInvokerToUse = object;
                    break;
                }
            }
            List list = invocationContext.getArguments();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Parameter[] parameters = ((Method)invocationContext.getExecutable()).getParameters();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (testMethodInvokerToUse != null) {
                    Class<?> argClass = parameters[i2].getType();
                    arrayList.add(testMethodInvokerToUse.getClass().getMethod("methodParamInstance", String.class).invoke(testMethodInvokerToUse, argClass.getName()));
                    continue;
                }
                Object arg = list.get(i2);
                arrayList.add(arg);
            }
            if (testMethodInvokerToUse != null) {
                return testMethodInvokerToUse.getClass().getMethod("invoke", Object.class, Method.class, List.class, String.class).invoke(testMethodInvokerToUse, effectiveTestInstance, newMethod, arrayList, extensionContext.getRequiredTestClass().getName());
            }
            return newMethod.invoke(effectiveTestInstance, arrayList.toArray(new Object[0]));
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Method determineTCCLExtensionMethod(Method originalMethod, Class<?> c) throws ClassNotFoundException {
        Class<?> declaringClass = this.resolveDeclaringClass(originalMethod, c);
        if (declaringClass == null) {
            return null;
        }
        try {
            Class<?>[] originalParameterTypes = originalMethod.getParameterTypes();
            ArrayList parameterTypesFromTccl = new ArrayList(originalParameterTypes.length);
            for (Class<?> type : originalParameterTypes) {
                if (type.isPrimitive()) {
                    parameterTypesFromTccl.add(type);
                    continue;
                }
                parameterTypesFromTccl.add(type);
            }
            return declaringClass.getDeclaredMethod(originalMethod.getName(), parameterTypesFromTccl.toArray(new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Class<?> resolveDeclaringClass(Method method, Class<?> c) {
        if (c == Object.class || c == null) {
            return null;
        }
        if (c.getName().equals(method.getDeclaringClass().getName())) {
            return c;
        }
        Class<?> declaringClass = this.resolveDeclaringClass(method, c.getSuperclass());
        if (declaringClass != null) {
            return declaringClass;
        }
        for (Class<?> anInterface : c.getInterfaces()) {
            declaringClass = this.resolveDeclaringClass(method, anInterface);
            if (declaringClass == null) continue;
            return declaringClass;
        }
        return null;
    }

    public void afterAll(ExtensionContext context) throws Exception {
        QuarkusTestExtension.resetHangTimeout();
        this.runAfterAllCallbacks(context);
        try {
            if (!this.isNativeOrIntegrationTest(context.getRequiredTestClass()) && runningQuarkusApplication != null) {
                this.popMockContext();
            }
        }
        finally {
            currentTestClassStack.pop();
            if (!outerInstances.isEmpty()) {
                actualTestInstance = outerInstances.pop();
            }
        }
    }

    private void runAfterAllCallbacks(ExtensionContext context) throws Exception {
        if (this.isNativeOrIntegrationTest(context.getRequiredTestClass()) || failedBoot) {
            return;
        }
        if (this.isAfterAllCallbacksEmpty()) {
            return;
        }
        QuarkusTestExtensionState state = this.getState(context);
        Class<?> quarkusTestContextClass = Class.forName(QuarkusTestContext.class.getName(), true, runningQuarkusApplication.getClassLoader());
        Object quarkusTestContextInstance = quarkusTestContextClass.getConstructor(Object.class, List.class, Throwable.class).newInstance(actualTestInstance, new ArrayList<Object>(outerInstances), state.getTestErrorCause());
        this.invokeAfterAllCallbacks(quarkusTestContextClass, quarkusTestContextInstance);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        boolean isConstructor = parameterContext.getDeclaringExecutable() instanceof Constructor;
        if (isConstructor) {
            return true;
        }
        if (!(parameterContext.getDeclaringExecutable() instanceof Method)) {
            return false;
        }
        if (testMethodInvokers == null) {
            return false;
        }
        for (Object testMethodInvoker : testMethodInvokers) {
            boolean handlesMethodParamType = this.testMethodInvokerHandlesParamType(testMethodInvoker, parameterContext);
            if (!handlesMethodParamType) continue;
            return true;
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        String className;
        if (parameterContext.getDeclaringExecutable() instanceof Method && testMethodInvokers != null) {
            for (Object testMethodInvoker : testMethodInvokers) {
                if (!this.testMethodInvokerHandlesParamType(testMethodInvoker, parameterContext)) continue;
                return null;
            }
        }
        switch (className = parameterContext.getParameter().getType().getName()) {
            case "boolean": {
                return false;
            }
            case "byte": 
            case "short": 
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
            case "char": {
                return Character.valueOf('\u0000');
            }
        }
        return null;
    }

    private boolean testMethodInvokerHandlesParamType(Object testMethodInvoker, ParameterContext parameterContext) {
        try {
            return (Boolean)testMethodInvoker.getClass().getMethod("handlesMethodParamType", String.class).invoke(testMethodInvoker, parameterContext.getParameter().getType().getName());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to determine if TestMethodInvoker supports parameter");
        }
    }

    private static void resetHangTimeout() {
        if (hangTaskKey != null) {
            hangTaskKey.cancel(false);
            ScheduledExecutorService h = hangDetectionExecutor;
            if (h != null) {
                try {
                    hangTaskKey = h.schedule(hangDetectionTask, hangTimeout.toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        outerInstances = new ArrayDeque<Object>(1);
        hangDetectionTask = new Runnable(){
            final AtomicBoolean runOnce = new AtomicBoolean();

            @Override
            public void run() {
                ThreadInfo[] threads;
                if (!this.runOnce.compareAndSet(false, true)) {
                    return;
                }
                System.err.println("@QuarkusTest has detected a hang, as there has been no test activity in " + String.valueOf(hangTimeout));
                System.err.println("To configure this timeout use the quarkus.test.hang-detection-timeout config property");
                System.err.println("A stack trace is below to help diagnose the potential hang");
                System.err.println("=== Stack Trace ===");
                for (ThreadInfo info : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                    if (info == null) {
                        System.err.println("  Inactive");
                        continue;
                    }
                    Thread.State state = info.getThreadState();
                    System.err.println("Thread " + info.getThreadName() + ": " + String.valueOf((Object)state));
                    if (state == Thread.State.WAITING) {
                        System.err.println("  Waiting on " + info.getLockName());
                    } else if (state == Thread.State.BLOCKED) {
                        System.err.println("  Blocked on " + info.getLockName());
                        System.err.println("  Blocked by " + info.getLockOwnerName());
                    }
                    System.err.println("  Stack:");
                    for (StackTraceElement frame : info.getStackTrace()) {
                        System.err.println("    " + frame.toString());
                    }
                }
                System.err.println("=== End Stack Trace ===");
            }
        };
        ClassLoader classLoader = QuarkusTestExtension.class.getClassLoader();
        if (classLoader instanceof QuarkusClassLoader) {
            ((QuarkusClassLoader)classLoader).addCloseTask(new Runnable(){

                @Override
                public void run() {
                    ScheduledExecutorService h = hangDetectionExecutor;
                    if (h != null) {
                        h.shutdownNow();
                        hangDetectionExecutor = null;
                    }
                }
            });
        }
    }

    public static class ExtensionState
    extends QuarkusTestExtensionState {
        public ExtensionState(Closeable testResourceManager, Closeable resource, Runnable clearCallbacks) {
            super(testResourceManager, resource, clearCallbacks);
        }

        public ExtensionState(Closeable trm, Closeable resource, Runnable clearCallbacks, Thread shutdownHook) {
            super(trm, resource, clearCallbacks, shutdownHook);
        }

        @Override
        protected void doClose() {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            if (AbstractJvmQuarkusTestExtension.runningQuarkusApplication != null) {
                Thread.currentThread().setContextClassLoader(AbstractJvmQuarkusTestExtension.runningQuarkusApplication.getClassLoader());
            }
            try {
                this.resource.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to shutdown Quarkus", e);
            }
            finally {
                if (AbstractJvmQuarkusTestExtension.runningQuarkusApplication != null) {
                    ((SmallRyeConfigProviderResolver)ConfigProviderResolver.instance()).releaseConfig(AbstractJvmQuarkusTestExtension.runningQuarkusApplication.getClassLoader());
                }
                AbstractJvmQuarkusTestExtension.runningQuarkusApplication = null;
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    class FailedCleanup
    implements ExtensionContext.Store.CloseableResource {
        FailedCleanup() {
        }

        public void close() {
            QuarkusTestExtension.this.shutdownHangDetection();
            firstException = null;
            failedBoot = false;
            ConfigProviderResolver.setInstance(null);
        }
    }
}

