/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.junit.callback.QuarkusTestAfterAllCallback;
import io.quarkus.test.junit.callback.QuarkusTestAfterConstructCallback;
import io.quarkus.test.junit.callback.QuarkusTestAfterEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestAfterTestExecutionCallback;
import io.quarkus.test.junit.callback.QuarkusTestBeforeClassCallback;
import io.quarkus.test.junit.callback.QuarkusTestBeforeEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestBeforeTestExecutionCallback;
import io.quarkus.test.junit.callback.QuarkusTestContext;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public abstract class AbstractTestWithCallbacksExtension {
    private static List<Object> beforeClassCallbacks;
    private static List<Object> afterConstructCallbacks;
    private static List<Object> beforeEachCallbacks;
    private static List<Object> beforeTestCallbacks;
    private static List<Object> afterTestCallbacks;
    private static List<Object> afterEachCallbacks;
    private static List<Object> afterAllCallbacks;

    protected boolean isBeforeTestCallbacksEmpty() {
        return beforeTestCallbacks == null || beforeTestCallbacks.isEmpty();
    }

    protected void invokeBeforeTestExecutionCallbacks(QuarkusTestMethodContext quarkusTestMethodContext) throws Exception {
        this.invokeBeforeTestExecutionCallbacks(QuarkusTestMethodContext.class, quarkusTestMethodContext);
    }

    protected void invokeBeforeTestExecutionCallbacks(Class<?> clazz, Object classInstance) throws Exception {
        this.invokeCallbacks(beforeTestCallbacks, "beforeTestExecution", clazz, classInstance);
    }

    protected boolean isAfterTestCallbacksEmpty() {
        return afterTestCallbacks == null || afterTestCallbacks.isEmpty();
    }

    protected void invokeAfterTestExecutionCallbacks(QuarkusTestMethodContext quarkusTestMethodContext) throws Exception {
        this.invokeAfterTestExecutionCallbacks(QuarkusTestMethodContext.class, quarkusTestMethodContext);
    }

    protected void invokeAfterTestExecutionCallbacks(Class<?> clazz, Object classInstance) throws Exception {
        this.invokeCallbacks(afterTestCallbacks, "afterTestExecution", clazz, classInstance);
    }

    protected void invokeBeforeClassCallbacks(Class<?> classInstance) throws Exception {
        this.invokeBeforeClassCallbacks(Class.class, classInstance);
    }

    protected void invokeBeforeClassCallbacks(Class<?> clazz, Object classInstance) throws Exception {
        this.invokeCallbacks(beforeClassCallbacks, "beforeClass", clazz, classInstance);
    }

    protected void invokeAfterConstructCallbacks(Object testInstance) throws Exception {
        this.invokeAfterConstructCallbacks(Object.class, testInstance);
    }

    protected void invokeAfterConstructCallbacks(Class<?> clazz, Object classInstance) throws Exception {
        this.invokeCallbacks(afterConstructCallbacks, "afterConstruct", clazz, classInstance);
    }

    protected boolean isBeforeEachCallbacksEmpty() {
        return beforeEachCallbacks == null || beforeEachCallbacks.isEmpty();
    }

    protected void invokeBeforeEachCallbacks(QuarkusTestMethodContext quarkusTestMethodContext) throws Exception {
        this.invokeBeforeEachCallbacks(QuarkusTestMethodContext.class, quarkusTestMethodContext);
    }

    protected void invokeBeforeEachCallbacks(Class<?> clazz, Object classInstance) throws Exception {
        this.invokeCallbacks(beforeEachCallbacks, "beforeEach", clazz, classInstance);
    }

    protected void invokeAfterEachCallbacks(QuarkusTestMethodContext testMethodContext) throws Exception {
        this.invokeAfterEachCallbacks(QuarkusTestMethodContext.class, testMethodContext);
    }

    protected boolean isAfterEachCallbacksEmpty() {
        return afterEachCallbacks == null || afterEachCallbacks.isEmpty();
    }

    protected void invokeAfterEachCallbacks(Class<?> clazz, Object classInstance) throws Exception {
        this.invokeCallbacks(afterEachCallbacks, "afterEach", clazz, classInstance);
    }

    protected boolean isAfterAllCallbacksEmpty() {
        return afterAllCallbacks == null || afterAllCallbacks.isEmpty();
    }

    protected void invokeAfterAllCallbacks(QuarkusTestContext testContext) throws Exception {
        this.invokeAfterAllCallbacks(QuarkusTestContext.class, testContext);
    }

    protected void invokeAfterAllCallbacks(Class<?> clazz, Object testContext) throws Exception {
        this.invokeCallbacks(afterAllCallbacks, "afterAll", clazz, testContext);
    }

    protected static void clearCallbacks() {
        beforeClassCallbacks = new ArrayList<Object>();
        afterConstructCallbacks = new ArrayList<Object>();
        beforeEachCallbacks = new ArrayList<Object>();
        beforeTestCallbacks = new ArrayList<Object>();
        afterTestCallbacks = new ArrayList<Object>();
        afterEachCallbacks = new ArrayList<Object>();
        afterAllCallbacks = new ArrayList<Object>();
    }

    protected void populateCallbacks(ClassLoader classLoader) throws ClassNotFoundException {
        AbstractTestWithCallbacksExtension.clearCallbacks();
        ServiceLoader<Object> quarkusTestBeforeClassLoader = ServiceLoader.load(Class.forName(QuarkusTestBeforeClassCallback.class.getName(), false, classLoader), classLoader);
        for (Iterator<Object> quarkusTestBeforeClassCallback : quarkusTestBeforeClassLoader) {
            beforeClassCallbacks.add(quarkusTestBeforeClassCallback);
        }
        ServiceLoader<Object> quarkusTestAfterConstructLoader = ServiceLoader.load(Class.forName(QuarkusTestAfterConstructCallback.class.getName(), false, classLoader), classLoader);
        for (Iterator<Object> quarkusTestAfterConstructCallback : quarkusTestAfterConstructLoader) {
            afterConstructCallbacks.add(quarkusTestAfterConstructCallback);
        }
        ServiceLoader<Object> quarkusTestBeforeEachLoader = ServiceLoader.load(Class.forName(QuarkusTestBeforeEachCallback.class.getName(), false, classLoader), classLoader);
        for (Iterator<Object> quarkusTestBeforeEachCallback : quarkusTestBeforeEachLoader) {
            beforeEachCallbacks.add(quarkusTestBeforeEachCallback);
        }
        ServiceLoader<Object> quarkusTestBeforeTestLoader = ServiceLoader.load(Class.forName(QuarkusTestBeforeTestExecutionCallback.class.getName(), false, classLoader), classLoader);
        for (Iterator<Object> quarkusTestBeforeTestCallback : quarkusTestBeforeTestLoader) {
            beforeTestCallbacks.add(quarkusTestBeforeTestCallback);
        }
        ServiceLoader<Object> quarkusTestAfterTestLoader = ServiceLoader.load(Class.forName(QuarkusTestAfterTestExecutionCallback.class.getName(), false, classLoader), classLoader);
        for (Iterator quarkusTestAfterTestCallback : quarkusTestAfterTestLoader) {
            afterTestCallbacks.add(quarkusTestAfterTestCallback);
        }
        ServiceLoader quarkusTestAfterEachLoader = ServiceLoader.load(Class.forName(QuarkusTestAfterEachCallback.class.getName(), false, classLoader), classLoader);
        for (Object quarkusTestAfterEach : quarkusTestAfterEachLoader) {
            afterEachCallbacks.add(quarkusTestAfterEach);
        }
        ServiceLoader<?> quarkusTestAfterAllLoader = ServiceLoader.load(Class.forName(QuarkusTestAfterAllCallback.class.getName(), false, classLoader), classLoader);
        for (Object quarkusTestAfterAll : quarkusTestAfterAllLoader) {
            afterAllCallbacks.add(quarkusTestAfterAll);
        }
    }

    private void invokeCallbacks(List<Object> callbacks, String methodName, Class<?> clazz, Object classInstance) throws Exception {
        if (callbacks == null || callbacks.isEmpty()) {
            return;
        }
        try {
            for (Object callback : callbacks) {
                callback.getClass().getMethod(methodName, clazz).invoke(callback, classInstance);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            if (e.getCause() instanceof AssertionError) {
                throw (AssertionError)((Object)e.getCause());
            }
            throw e;
        }
    }

    protected Class getTestingType() {
        Class<?> type = this.getClass();
        if (type.isAnonymousClass()) {
            return type.getSuperclass();
        }
        return type;
    }
}

