/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime.ui;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;

public abstract class AbstractHttpRequestHandler
implements Handler<RoutingContext> {
    private final ManagedContext currentManagedContext = Arc.container().requestContext();
    private final Handler currentManagedContextTerminationHandler = e -> this.currentManagedContext.terminate();

    public void handle(RoutingContext ctx) {
        if (this.currentManagedContext.isActive()) {
            this.doHandle(ctx);
        } else {
            this.currentManagedContext.activate();
            ctx.response().endHandler(this.currentManagedContextTerminationHandler).exceptionHandler(this.currentManagedContextTerminationHandler).closeHandler(this.currentManagedContextTerminationHandler);
            try {
                this.doHandle(ctx);
            }
            catch (Throwable t) {
                this.currentManagedContext.terminate();
                throw t;
            }
        }
    }

    public void doHandle(RoutingContext ctx) {
        try {
            HttpServerRequest request = ctx.request();
            switch (request.method().name()) {
                case "OPTIONS": {
                    this.handleOptions(ctx);
                    break;
                }
                case "POST": {
                    this.handlePost(ctx);
                    break;
                }
                case "GET": {
                    this.handleGet(ctx);
                    break;
                }
                default: {
                    ctx.next();
                    break;
                }
            }
        }
        catch (Exception e) {
            ctx.fail((Throwable)e);
        }
    }

    public abstract void handlePost(RoutingContext var1);

    public abstract void handleGet(RoutingContext var1);

    public abstract void handleOptions(RoutingContext var1);

    protected String getRequestPath(RoutingContext event) {
        HttpServerRequest request = event.request();
        return request.path();
    }
}

