/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.deployment;

import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.kubernetes.client.KubernetesResources;
import io.quarkus.kubernetes.client.runtime.internal.KubernetesSerializationRecorder;
import io.quarkus.kubernetes.client.spi.KubernetesResourcesBuildItem;
import jakarta.inject.Singleton;
import java.util.HashSet;
import java.util.ServiceLoader;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class KubernetesResourceBuildStep {
    @BuildStep
    void scanKubernetesResourceClasses(BuildProducer<ServiceProviderBuildItem> serviceProviderProducer, BuildProducer<KubernetesResourcesBuildItem> kubernetesResourcesBuildItemBuildProducer) {
        serviceProviderProducer.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)KubernetesResource.class.getName()));
        HashSet<String> resourceClasses = new HashSet<String>();
        ServiceLoader<KubernetesResource> serviceLoader = ServiceLoader.load(KubernetesResource.class);
        for (KubernetesResource kr : serviceLoader) {
            String className = kr.getClass().getName();
            if (!QuarkusClassLoader.isClassPresentAtRuntime((String)className)) continue;
            resourceClasses.add(className);
        }
        kubernetesResourcesBuildItemBuildProducer.produce((BuildItem)new KubernetesResourcesBuildItem((String[])resourceClasses.toArray(String[]::new)));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem kubernetesResourceClasses(KubernetesSerializationRecorder recorder, KubernetesResourcesBuildItem kubernetesResourcesBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KubernetesResources.class));
        Type classArray = Type.create((DotName)DotName.createSimple((String)Class[].class.getName()), (Type.Kind)Type.Kind.ARRAY);
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Object.class).providerType(classArray)).addType(classArray)).scope(Singleton.class)).qualifiers(new AnnotationInstance[]{AnnotationInstance.builder(KubernetesResources.class).build()})).runtimeValue(recorder.initKubernetesResources(kubernetesResourcesBuildItem.getResourceClasses())).done();
    }
}

