/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.runtime;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.vertx.VertxHttpClientBuilder;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.file.FileSystemOptions;
import jakarta.enterprise.inject.spi.CDI;
import java.io.Closeable;
import java.lang.annotation.Annotation;

public class QuarkusHttpClientFactory
implements HttpClient.Factory,
Closeable {
    private Vertx vertx;
    private boolean closeVertxOnExit;

    public QuarkusHttpClientFactory() {
        try {
            this.vertx = (Vertx)CDI.current().select(Vertx.class, new Annotation[0]).get();
            this.closeVertxOnExit = false;
        }
        catch (Exception e) {
            this.vertx = this.createVertxInstance();
            this.closeVertxOnExit = true;
        }
    }

    private Vertx createVertxInstance() {
        Vertx vertx;
        String originalValue = System.getProperty("vertx.disableDnsResolver");
        try {
            System.setProperty("vertx.disableDnsResolver", "true");
            vertx = Vertx.vertx((VertxOptions)new VertxOptions().setFileSystemOptions(new FileSystemOptions().setFileCachingEnabled(false).setClassPathResolvingEnabled(false)));
        }
        finally {
            if (originalValue == null) {
                System.clearProperty("vertx.disableDnsResolver");
            } else {
                System.setProperty("vertx.disableDnsResolver", originalValue);
            }
        }
        return vertx;
    }

    public HttpClient.Builder newBuilder(Config config) {
        return super.newBuilder(config);
    }

    public VertxHttpClientBuilder<QuarkusHttpClientFactory> newBuilder() {
        return new VertxHttpClientBuilder((HttpClient.Factory)this, this.vertx);
    }

    public int priority() {
        return 1;
    }

    @Override
    public void close() {
        if (this.closeVertxOnExit) {
            this.vertx.close();
        }
    }
}

