/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent;
import io.quarkus.kubernetes.spi.RoleRef;
import io.quarkus.kubernetes.spi.Subject;
import java.util.HashMap;
import java.util.Map;

public class AddClusterRoleBindingResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final String deploymentName;
    private final String name;
    private final Map<String, String> labels;
    private final RoleRef roleRef;
    private final Subject[] subjects;

    public AddClusterRoleBindingResourceDecorator(String deploymentName, String name, Map<String, String> labels, RoleRef roleRef, Subject ... subjects) {
        this.deploymentName = deploymentName;
        this.name = name;
        this.labels = labels;
        this.roleRef = roleRef;
        this.subjects = subjects;
    }

    public void visit(KubernetesListBuilder list) {
        if (this.contains(list, "rbac.authorization.k8s.io/v1", "ClusterRoleBinding", this.name)) {
            return;
        }
        HashMap<String, String> clusterRoleBindingLabels = new HashMap<String, String>();
        clusterRoleBindingLabels.putAll(this.labels);
        this.getDeploymentMetadata(list, this.deploymentName).map(ObjectMeta::getLabels).ifPresent(clusterRoleBindingLabels::putAll);
        ClusterRoleBindingBuilder builder = (ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.MetadataNested)((ClusterRoleBindingFluent.MetadataNested)new ClusterRoleBindingBuilder().withNewMetadata().withName(this.name)).withLabels(clusterRoleBindingLabels)).endMetadata()).withNewRoleRef().withKind("ClusterRole")).withName(this.roleRef.getName())).withApiGroup("rbac.authorization.k8s.io")).endRoleRef();
        for (Subject subject : this.subjects) {
            ((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingFluent.SubjectsNested)builder.addNewSubject().withApiGroup(subject.getApiGroup())).withKind(subject.getKind())).withName(Strings.defaultIfEmpty((String)subject.getName(), (String)this.deploymentName))).withNamespace(subject.getNamespace())).endSubject();
        }
        list.addToItems(new HasMetadata[]{builder.build()});
    }
}

