/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.AbstractAddProbeDecorator;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Metadata;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.HTTPGetActionFluent;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ApplyHttpGetActionPortDecorator
extends Decorator<HTTPGetActionFluent<?>> {
    private final String deployment;
    private final String container;
    private final Integer port;
    private final String scheme;
    private final String probeKind;

    public ApplyHttpGetActionPortDecorator(Integer port) {
        this(ANY, ANY, port, ANY);
    }

    public ApplyHttpGetActionPortDecorator(Integer port, String probeKind) {
        this(ANY, ANY, port, probeKind);
    }

    public ApplyHttpGetActionPortDecorator(String deployment, Integer port) {
        this(deployment, ANY, port, ANY);
    }

    public ApplyHttpGetActionPortDecorator(String deployment, Integer port, String probeKind) {
        this(deployment, ANY, port, probeKind);
    }

    public ApplyHttpGetActionPortDecorator(String deployment, String container, Integer port) {
        this(deployment, container, port, ANY);
    }

    public ApplyHttpGetActionPortDecorator(String deployment, String container, Integer port, String probeKind) {
        this(deployment, container, port, probeKind, port != null && (port == 443 || port == 8443) ? "HTTPS" : "HTTP");
    }

    public ApplyHttpGetActionPortDecorator(String deployment, String container, Integer port, String probeKind, String scheme) {
        this.deployment = deployment;
        this.container = container;
        this.port = port;
        this.probeKind = probeKind;
        this.scheme = scheme;
    }

    public void visit(List<Map.Entry<String, Object>> path, HTTPGetActionFluent<?> action) {
        boolean inMatchingResource;
        boolean inMatchingContainer;
        boolean inMatchingProbe;
        boolean bl = inMatchingProbe = this.probeKind == ANY || path.stream().map(e -> (String)e.getKey()).anyMatch(i -> i.equals(this.probeKind));
        if (!inMatchingProbe) {
            return;
        }
        boolean bl2 = inMatchingContainer = this.container == ANY || path.stream().map(e -> e.getValue()).filter(v -> v instanceof ContainerBuilder).map(v -> (ContainerBuilder)v).anyMatch(c -> c.getName() != null && c.getName().equals(this.container));
        if (!inMatchingContainer) {
            return;
        }
        boolean bl3 = inMatchingResource = this.deployment == ANY || path.stream().map(e -> e.getValue()).filter(v -> v instanceof Builder).map(v -> (Builder)v).map(b -> Metadata.getMetadata((Builder)b)).filter(m -> m.isPresent()).map(Optional::get).anyMatch(m -> m.getName() != null && m.getName().equals(this.deployment));
        if (!inMatchingResource) {
            return;
        }
        this.visit(action);
    }

    public void visit(HTTPGetActionFluent<?> action) {
        if (this.port == null) {
            action.withNewPort((Object)null);
        } else {
            action.withNewPort((Object)this.port);
        }
        if (this.scheme == null) {
            action.withScheme((String)null);
        } else {
            action.withScheme(this.scheme);
        }
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, AddSidecarDecorator.class, AbstractAddProbeDecorator.class};
    }
}

