/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.openshift.config.OpenshiftConfigFluent;
import io.dekorate.openshift.config.TLSConfig;
import io.quarkus.kubernetes.deployment.RouteConfig;

public class ApplyOpenshiftRouteConfigurator
extends Configurator<OpenshiftConfigFluent> {
    private final RouteConfig routeConfig;

    public ApplyOpenshiftRouteConfigurator(RouteConfig routeConfig) {
        this.routeConfig = routeConfig;
    }

    public void visit(OpenshiftConfigFluent config) {
        if (this.routeConfig.expose) {
            OpenshiftConfigFluent.RouteNested routeBuilder = config.editOrNewRoute();
            routeBuilder.withExpose(Boolean.valueOf(true));
            if (this.routeConfig.host.isPresent()) {
                routeBuilder.withHost(this.routeConfig.host.get());
            }
            routeBuilder.withTargetPort(this.routeConfig.targetPort);
            if (this.routeConfig.tls != null) {
                TLSConfig tls = new TLSConfig();
                this.routeConfig.tls.caCertificate.ifPresent(arg_0 -> ((TLSConfig)tls).setCaCertificate(arg_0));
                this.routeConfig.tls.certificate.ifPresent(arg_0 -> ((TLSConfig)tls).setCertificate(arg_0));
                this.routeConfig.tls.destinationCACertificate.ifPresent(arg_0 -> ((TLSConfig)tls).setDestinationCACertificate(arg_0));
                this.routeConfig.tls.key.ifPresent(arg_0 -> ((TLSConfig)tls).setKey(arg_0));
                this.routeConfig.tls.termination.ifPresent(arg_0 -> ((TLSConfig)tls).setTermination(arg_0));
                this.routeConfig.tls.insecureEdgeTerminationPolicy.ifPresent(arg_0 -> ((TLSConfig)tls).setInsecureEdgeTerminationPolicy(arg_0));
                routeBuilder.withTls(tls);
            }
            routeBuilder.endRoute();
        }
    }
}

