/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.InitTaskBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import io.quarkus.kubernetes.spi.KubernetesInitContainerBuildItem;
import io.quarkus.kubernetes.spi.KubernetesJobBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import io.quarkus.kubernetes.spi.PolicyRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class InitTaskProcessor {
    static void process(String target, String name, ContainerImageInfoBuildItem image, List<InitTaskBuildItem> initTasks, BuildProducer<KubernetesJobBuildItem> jobs, BuildProducer<KubernetesInitContainerBuildItem> initContainers, BuildProducer<KubernetesEnvBuildItem> env, BuildProducer<KubernetesRoleBuildItem> roles, BuildProducer<KubernetesRoleBindingBuildItem> roleBindings, BuildProducer<DecoratorBuildItem> decorators) {
        initTasks.forEach(task -> {
            initContainers.produce((BuildItem)KubernetesInitContainerBuildItem.create((String)"groundnuty/k8s-wait-for:1.3").withTarget(target).withArguments(Arrays.asList("job", task.getName())));
            jobs.produce((BuildItem)KubernetesJobBuildItem.create((String)image.getImage()).withName(task.getName()).withTarget(target).withEnvVars(task.getTaskEnvVars()).withCommand(task.getCommand()).withArguments(task.getArguments()).withSharedEnvironment(task.isSharedEnvironment()).withSharedFilesystem(task.isSharedFilesystem()));
            task.getAppEnvVars().forEach((k, v) -> decorators.produce((BuildItem)new DecoratorBuildItem(target, (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, (Env)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(k)).withValue(v)).build()))));
            roles.produce((BuildItem)new KubernetesRoleBuildItem("view-jobs", Collections.singletonList(new PolicyRule(Collections.singletonList("batch"), Collections.singletonList("jobs"), List.of("get"))), target));
            roleBindings.produce((BuildItem)new KubernetesRoleBindingBuildItem(null, "view-jobs", false, target));
        });
    }
}

