/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment.devui;

import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.kubernetes.deployment.devconsole.KubernetesDevConsoleProcessor;
import io.quarkus.kubernetes.runtime.devui.KubernetesManifestService;
import java.util.LinkedHashMap;
import java.util.List;

public class KubernetesDevUiProcessor {
    static final KubernetesDevConsoleProcessor.Holder holder = new KubernetesDevConsoleProcessor.Holder();

    @BuildStep(onlyIf={IsDevelopment.class})
    CardPageBuildItem create(CurateOutcomeBuildItem bi) {
        CardPageBuildItem pageBuildItem = new CardPageBuildItem();
        pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Kubernetes Manifests")).componentLink("qwc-kubernetes-manifest.js").icon("font-awesome-solid:rocket"));
        return pageBuildItem;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem createJsonRPCServiceForCache() {
        DevConsoleManager.register((String)"kubernetes-generate-manifest", ignored -> {
            try {
                List<KubernetesDevConsoleProcessor.Manifest> manifests = holder.getManifests();
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (KubernetesDevConsoleProcessor.Manifest manifest : manifests) {
                    map.put(manifest.getName(), manifest.getContent());
                }
                return map;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return new JsonRPCProvidersBuildItem(KubernetesManifestService.class);
    }
}

