/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.annotation.JobCompletionMode;
import io.dekorate.kubernetes.annotation.JobRestartPolicy;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent;
import java.util.List;

public class CreateJobResourceFromImageDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private static final String DEFAULT_RESTART_POLICY = JobRestartPolicy.OnFailure.name();
    private static final String DEFAULT_COMPLETION_MODE = JobCompletionMode.NonIndexed.name();
    private final String name;
    private final String image;
    private final List<String> command;
    private final List<String> arguments;

    public CreateJobResourceFromImageDecorator(String name, String image, List<String> command, List<String> arguments) {
        this.name = name;
        this.image = image;
        this.command = command;
        this.arguments = arguments;
    }

    public void visit(KubernetesListBuilder list) {
        if (!this.contains(list, "batch/v1", "Job", this.name)) {
            list.addToItems(new HasMetadata[]{((JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((JobFluent.SpecNested)((JobBuilder)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName(this.name)).endMetadata()).withNewSpec().withCompletionMode(DEFAULT_COMPLETION_MODE)).withNewTemplate().withNewSpec().withRestartPolicy(DEFAULT_RESTART_POLICY)).addNewContainer().withName(this.name)).withImage(this.image)).withCommand(this.command)).withArgs(this.arguments)).endContainer()).endSpec()).endTemplate()).endSpec()).build()});
        }
    }
}

