/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.config.Env;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.EnvVarHolder;
import io.quarkus.kubernetes.deployment.MountConfig;
import io.quarkus.kubernetes.deployment.PortConfig;
import io.quarkus.kubernetes.deployment.ProbeConfig;
import io.quarkus.kubernetes.deployment.ResourcesConfig;
import io.smallrye.config.WithDefault;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public interface ContainerConfig
extends EnvVarHolder {
    public Optional<String> image();

    public Optional<String> workingDir();

    public Optional<List<String>> command();

    public Optional<List<String>> arguments();

    public Optional<String> serviceAccount();

    public Optional<String> host();

    public Map<String, PortConfig> ports();

    @WithDefault(value="Always")
    public ImagePullPolicy imagePullPolicy();

    public Optional<List<String>> imagePullSecrets();

    public ProbeConfig livenessProbe();

    public ProbeConfig readinessProbe();

    public Map<String, MountConfig> mounts();

    public ResourcesConfig resources();

    @Override
    default public String targetPlatformName() {
        return null;
    }

    default public Collection<Env> convertToEnvs() {
        return this.convertToBuildItems().stream().map(kebi -> new Env(EnvConverter.convertName(kebi.getName()), kebi.getValue(), kebi.getSecret(), kebi.getConfigMap(), kebi.getField(), null, kebi.getPrefix())).collect(Collectors.toList());
    }
}

