/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.quarkus.container.image.deployment.ContainerImageCapabilitiesUtil;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.kubernetes.deployment.ContainerConfig;
import io.quarkus.kubernetes.deployment.CronJobConfig;
import io.quarkus.kubernetes.deployment.DebugConfig;
import io.quarkus.kubernetes.deployment.DeploymentResourceKind;
import io.quarkus.kubernetes.deployment.InitTaskConfig;
import io.quarkus.kubernetes.deployment.JobConfig;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import io.quarkus.kubernetes.deployment.RouteConfig;
import io.quarkus.kubernetes.spi.DeployStrategy;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigMapping(prefix="quarkus.openshift")
@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public interface OpenShiftConfig
extends PlatformConfiguration {
    @Override
    default public String targetPlatformName() {
        return "openshift";
    }

    @WithDefault(value="v4")
    public OpenshiftFlavor flavor();

    public Optional<DeploymentResourceKind> deploymentKind();

    @WithDefault(value="1")
    public Integer replicas();

    public OptionalInt nodePort();

    @Deprecated
    public Map<String, ContainerConfig> containers();

    public RouteConfig route();

    public JobConfig job();

    public CronJobConfig cronJob();

    public DebugConfig remoteDebug();

    @Deprecated(since="3.1", forRemoval=true)
    @WithDefault(value="true")
    public boolean externalizeInit();

    public Map<String, InitTaskConfig> initTasks();

    public InitTaskConfig initTaskDefaults();

    @WithDefault(value="false")
    public boolean deploy();

    @WithDefault(value="CreateOrUpdate")
    public DeployStrategy deployStrategy();

    public static boolean isOpenshiftBuildEnabled(ContainerImageConfig containerImageConfig, Capabilities capabilities) {
        boolean implicitlyEnabled = ContainerImageCapabilitiesUtil.getActiveContainerImageCapability((Capabilities)capabilities).filter(c -> c.contains("openshift") || c.contains("s2i")).isPresent();
        return containerImageConfig.builder.map(b -> b.equals("openshift") || b.equals("s2i")).orElse(implicitlyEnabled);
    }

    default public DeploymentResourceKind getDeploymentResourceKind(Capabilities capabilities) {
        if (this.deploymentKind().isPresent()) {
            return this.deploymentKind().filter(k -> k.isAvailalbleOn("openshift")).get();
        }
        if (capabilities.isPresent("io.quarkus.picocli")) {
            return DeploymentResourceKind.Job;
        }
        return this.flavor() == OpenshiftFlavor.v3 ? DeploymentResourceKind.DeploymentConfig : DeploymentResourceKind.Deployment;
    }

    @Override
    @Deprecated
    default public Map<String, ContainerConfig> getSidecars() {
        if (!this.containerName().isEmpty() && !this.sidecars().isEmpty()) {
            throw new IllegalStateException("'quarkus.openshift.sidecars' and 'quarkus.openshift.containers' cannot be used together. Please use the former as the latter has been deprecated");
        }
        if (!this.containers().isEmpty()) {
            return this.containers();
        }
        return this.sidecars();
    }

    public static enum OpenshiftFlavor {
        v3,
        v4;

    }
}

