/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.EditableItem;
import io.dekorate.kubernetes.config.Item;
import io.dekorate.kubernetes.config.ItemBuilder;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.SecretVolumeBuilder;
import io.quarkus.kubernetes.deployment.FilePermissionUtil;
import io.quarkus.kubernetes.deployment.SecretVolumeConfig;
import io.quarkus.kubernetes.deployment.VolumeItemConfig;
import java.util.ArrayList;
import java.util.Map;

public class SecretVolumeConverter {
    public static SecretVolume convert(Map.Entry<String, SecretVolumeConfig> e) {
        return ((SecretVolumeBuilder)SecretVolumeConverter.convert(e.getValue()).withVolumeName(e.getKey())).build();
    }

    public static SecretVolumeBuilder convert(SecretVolumeConfig c) {
        SecretVolumeBuilder b = new SecretVolumeBuilder();
        b.withSecretName(c.secretName);
        b.withDefaultMode(Integer.valueOf(FilePermissionUtil.parseInt(c.defaultMode)));
        b.withOptional(Boolean.valueOf(c.optional));
        if (c.items != null && !c.items.isEmpty()) {
            ArrayList<EditableItem> items = new ArrayList<EditableItem>(c.items.size());
            for (Map.Entry<String, VolumeItemConfig> item : c.items.entrySet()) {
                items.add(((ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder().withKey(item.getKey())).withPath(item.getValue().path)).withMode(Integer.valueOf(item.getValue().mode))).build());
            }
            b.withItems(items.toArray(new Item[items.size()]));
        }
        return b;
    }
}

