/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.quarkus.kubernetes.deployment.AddSidecarDecorator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AddNamespaceDecorator
extends Decorator<KubernetesListBuilder> {
    private final String namespace;

    public AddNamespaceDecorator(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public void visit(KubernetesListBuilder list) {
        List buildItems = list.buildItems().stream().peek(obj -> {
            ObjectMeta metadata;
            if (obj instanceof Namespaced && (metadata = obj.getMetadata()).getNamespace() == null) {
                metadata.setNamespace(this.namespace);
                obj.setMetadata(metadata);
            }
        }).collect(Collectors.toList());
        list.withItems(buildItems);
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, AddSidecarDecorator.class};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AddNamespaceDecorator that = (AddNamespaceDecorator)((Object)o);
        return this.namespace.equals(that.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.namespace);
    }
}

