/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpec;
import io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecFluent;
import io.quarkus.kubernetes.deployment.CronJobConfig;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class AddCronJobResourceDecorator
extends ResourceProvidingDecorator<KubernetesListFluent<?>> {
    private final String name;
    private final CronJobConfig config;

    public AddCronJobResourceDecorator(String name, CronJobConfig config) {
        this.name = name;
        this.config = config;
    }

    public void visit(KubernetesListFluent<?> list) {
        CronJobBuilder builder = (CronJobBuilder)list.buildItems().stream().filter(this::containsCronJobResource).map(this.replaceExistingCronJobResource(list)).findAny().orElseGet(this::createCronJobResource).accept(CronJobBuilder.class, this::initCronJobResourceWithDefaults);
        if (Strings.isNullOrEmpty((String)builder.buildSpec().getSchedule())) {
            throw new IllegalArgumentException("When generating a CronJob resource, you need to specify a schedule CRON expression.");
        }
        list.addToItems(new HasMetadata[]{builder.build()});
    }

    private boolean containsCronJobResource(HasMetadata metadata) {
        return "CronJob".equalsIgnoreCase(metadata.getKind()) && this.name.equals(metadata.getMetadata().getName());
    }

    private void initCronJobResourceWithDefaults(CronJobBuilder builder) {
        CronJobFluent.SpecNested spec = builder.editOrNewSpec();
        JobTemplateSpecFluent.SpecNested jobTemplateSpec = spec.editOrNewJobTemplate().editOrNewSpec();
        ((JobSpecFluent.TemplateNested)((JobTemplateSpecFluent.SpecNested)jobTemplateSpec.editOrNewSelector().endSelector()).editOrNewTemplate().editOrNewSpec().endSpec()).endTemplate();
        if (jobTemplateSpec.buildSelector().getMatchLabels() == null) {
            ((JobSpecFluent.SelectorNested)jobTemplateSpec.editSelector().withMatchLabels(new HashMap())).endSelector();
        } else {
            jobTemplateSpec.withSelector(null);
        }
        if (jobTemplateSpec.buildTemplate().getSpec().getTerminationGracePeriodSeconds() == null) {
            ((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)jobTemplateSpec.editTemplate().editSpec().withTerminationGracePeriodSeconds(Long.valueOf(10L))).endSpec()).endTemplate();
        }
        if (!this.containsContainerWithName((CronJobFluent.SpecNested<CronJobBuilder>)spec)) {
            ((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)jobTemplateSpec.editTemplate().editSpec().addNewContainer().withName(this.name)).endContainer()).endSpec()).endTemplate();
        }
        spec.withSuspend(Boolean.valueOf(this.config.suspend));
        spec.withConcurrencyPolicy(this.config.concurrencyPolicy.name());
        this.config.schedule.ifPresent(arg_0 -> ((CronJobFluent.SpecNested)spec).withSchedule(arg_0));
        this.config.successfulJobsHistoryLimit.ifPresent(arg_0 -> ((CronJobFluent.SpecNested)spec).withSuccessfulJobsHistoryLimit(arg_0));
        this.config.failedJobsHistoryLimit.ifPresent(arg_0 -> ((CronJobFluent.SpecNested)spec).withFailedJobsHistoryLimit(arg_0));
        this.config.startingDeadlineSeconds.ifPresent(arg_0 -> ((CronJobFluent.SpecNested)spec).withStartingDeadlineSeconds(arg_0));
        jobTemplateSpec.withCompletionMode(this.config.completionMode.name());
        ((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)jobTemplateSpec.editTemplate().editSpec().withRestartPolicy(this.config.restartPolicy.name())).endSpec()).endTemplate();
        this.config.parallelism.ifPresent(arg_0 -> ((JobTemplateSpecFluent.SpecNested)jobTemplateSpec).withParallelism(arg_0));
        this.config.completions.ifPresent(arg_0 -> ((JobTemplateSpecFluent.SpecNested)jobTemplateSpec).withCompletions(arg_0));
        this.config.backoffLimit.ifPresent(arg_0 -> ((JobTemplateSpecFluent.SpecNested)jobTemplateSpec).withBackoffLimit(arg_0));
        this.config.activeDeadlineSeconds.ifPresent(arg_0 -> ((JobTemplateSpecFluent.SpecNested)jobTemplateSpec).withActiveDeadlineSeconds(arg_0));
        this.config.ttlSecondsAfterFinished.ifPresent(arg_0 -> ((JobTemplateSpecFluent.SpecNested)jobTemplateSpec).withTtlSecondsAfterFinished(arg_0));
        ((CronJobSpecFluent.JobTemplateNested)jobTemplateSpec.endSpec()).endJobTemplate();
        spec.endSpec();
    }

    private CronJobBuilder createCronJobResource() {
        return (CronJobBuilder)((CronJobFluent.MetadataNested)new CronJobBuilder().withNewMetadata().withName(this.name)).endMetadata();
    }

    private Function<HasMetadata, CronJobBuilder> replaceExistingCronJobResource(KubernetesListFluent<?> list) {
        return metadata -> {
            list.removeFromItems(new HasMetadata[]{metadata});
            return new CronJobBuilder((CronJob)metadata);
        };
    }

    private boolean containsContainerWithName(CronJobFluent.SpecNested<CronJobBuilder> spec) {
        JobTemplateSpec jobTemplate = spec.buildJobTemplate();
        if (jobTemplate == null || jobTemplate.getSpec() == null || jobTemplate.getSpec().getTemplate() == null || jobTemplate.getSpec().getTemplate().getSpec() == null) {
            return false;
        }
        List containers = jobTemplate.getSpec().getTemplate().getSpec().getContainers();
        return containers == null || containers.stream().anyMatch(c -> this.name.equals(c.getName()));
    }
}

