/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent;
import io.quarkus.kubernetes.deployment.JobConfig;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class AddJobResourceDecorator
extends ResourceProvidingDecorator<KubernetesListFluent<?>> {
    private final String name;
    private final JobConfig config;

    public AddJobResourceDecorator(String name, JobConfig config) {
        this.name = name;
        this.config = config;
    }

    public void visit(KubernetesListFluent<?> list) {
        JobBuilder builder = (JobBuilder)list.buildItems().stream().filter(this::containsJobResource).map(this.replaceExistingJobResource(list)).findAny().orElseGet(this::createJobResource).accept(JobBuilder.class, this::initJobResourceWithDefaults);
        list.addToItems(new HasMetadata[]{builder.build()});
    }

    private boolean containsJobResource(HasMetadata metadata) {
        return "Job".equalsIgnoreCase(metadata.getKind()) && this.name.equals(metadata.getMetadata().getName());
    }

    private void initJobResourceWithDefaults(JobBuilder builder) {
        JobFluent.SpecNested spec = builder.editOrNewSpec();
        ((JobSpecFluent.TemplateNested)((JobFluent.SpecNested)spec.editOrNewSelector().endSelector()).editOrNewTemplate().editOrNewSpec().endSpec()).endTemplate();
        if (spec.buildSelector().getMatchLabels() == null) {
            ((JobSpecFluent.SelectorNested)spec.editSelector().withMatchLabels(new HashMap())).endSelector();
        }
        if (spec.buildTemplate().getSpec().getTerminationGracePeriodSeconds() == null) {
            ((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)spec.editTemplate().editSpec().withTerminationGracePeriodSeconds(Long.valueOf(10L))).endSpec()).endTemplate();
        }
        if (!this.containsContainerWithName((JobFluent.SpecNested<JobBuilder>)spec)) {
            ((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)spec.editTemplate().editSpec().addNewContainer().withName(this.name)).endContainer()).endSpec()).endTemplate();
        }
        spec.withSuspend(Boolean.valueOf(this.config.suspend));
        spec.withCompletionMode(this.config.completionMode.name());
        ((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)spec.editTemplate().editSpec().withRestartPolicy(this.config.restartPolicy.name())).endSpec()).endTemplate();
        this.config.parallelism.ifPresent(arg_0 -> ((JobFluent.SpecNested)spec).withParallelism(arg_0));
        this.config.completions.ifPresent(arg_0 -> ((JobFluent.SpecNested)spec).withCompletions(arg_0));
        this.config.backoffLimit.ifPresent(arg_0 -> ((JobFluent.SpecNested)spec).withBackoffLimit(arg_0));
        this.config.activeDeadlineSeconds.ifPresent(arg_0 -> ((JobFluent.SpecNested)spec).withActiveDeadlineSeconds(arg_0));
        this.config.ttlSecondsAfterFinished.ifPresent(arg_0 -> ((JobFluent.SpecNested)spec).withTtlSecondsAfterFinished(arg_0));
        spec.endSpec();
    }

    private JobBuilder createJobResource() {
        return (JobBuilder)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName(this.name)).endMetadata();
    }

    private Function<HasMetadata, JobBuilder> replaceExistingJobResource(KubernetesListFluent<?> list) {
        return metadata -> {
            list.removeFromItems(new HasMetadata[]{metadata});
            return new JobBuilder((Job)metadata);
        };
    }

    private boolean containsContainerWithName(JobFluent.SpecNested<JobBuilder> spec) {
        List containers = spec.buildTemplate().getSpec().getContainers();
        return containers == null || containers.stream().anyMatch(c -> this.name.equals(c.getName()));
    }
}

