/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.liquibase.runtime.LiquibaseDataSourceBuildTimeConfig;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Collections;
import java.util.Map;

@ConfigRoot(name="liquibase", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public final class LiquibaseBuildTimeConfig {
    @ConfigItem(name="<<parent>>")
    public LiquibaseDataSourceBuildTimeConfig defaultDataSource;
    @ConfigItem(name="<<parent>>")
    @ConfigDocMapKey(value="datasource-name")
    @ConfigDocSection
    public Map<String, LiquibaseDataSourceBuildTimeConfig> namedDataSources = Collections.emptyMap();

    public static LiquibaseBuildTimeConfig defaultConfig() {
        LiquibaseBuildTimeConfig defaultConfig = new LiquibaseBuildTimeConfig();
        defaultConfig.defaultDataSource = LiquibaseDataSourceBuildTimeConfig.defaultConfig();
        return defaultConfig;
    }

    public LiquibaseDataSourceBuildTimeConfig getConfigForDataSourceName(String dataSourceName) {
        return DataSourceUtil.isDefault((String)dataSourceName) ? this.defaultDataSource : this.namedDataSources.getOrDefault(dataSourceName, LiquibaseDataSourceBuildTimeConfig.defaultConfig());
    }
}

