/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.runtime.DatabaseSchemaProvider;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseFactoryUtil;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;

public class LiquibaseSchemaProvider
implements DatabaseSchemaProvider {
    public void resetDatabase(String dbName) {
        try {
            try {
                LiquibaseFactory liquibaseFactory = (LiquibaseFactory)LiquibaseFactoryUtil.getLiquibaseFactory(dbName).get();
                this.doReset(liquibaseFactory);
            }
            catch (UnsatisfiedResolutionException liquibaseFactory) {}
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting Liquibase", e);
        }
    }

    public void resetAllDatabases() {
        try {
            for (InstanceHandle<LiquibaseFactory> liquibaseFactoryHandle : LiquibaseFactoryUtil.getActiveLiquibaseFactories()) {
                try {
                    LiquibaseFactory liquibaseFactory = (LiquibaseFactory)liquibaseFactoryHandle.get();
                    this.doReset(liquibaseFactory);
                }
                catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {}
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting Liquibase", e);
        }
    }

    public void doReset(LiquibaseFactory liquibaseFactory) throws LiquibaseException {
        try (Liquibase liquibase = liquibaseFactory.createLiquibase();){
            liquibase.dropAll();
        }
        liquibase = liquibaseFactory.createLiquibase();
        try {
            liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
        }
        finally {
            if (liquibase != null) {
                liquibase.close();
            }
        }
    }
}

