/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import liquibase.resource.AbstractPathResourceAccessor;
import liquibase.resource.PathResource;
import liquibase.resource.Resource;
import org.jboss.logging.Logger;

public class NativeImageResourceAccessor
extends AbstractPathResourceAccessor {
    private static final URI NATIVE_IMAGE_FILESYSTEM_URI = URI.create("resource:/");
    private static final Logger log = Logger.getLogger(NativeImageResourceAccessor.class);
    private final FileSystem fileSystem;

    public NativeImageResourceAccessor() {
        FileSystem fs;
        try {
            fs = FileSystems.newFileSystem(NATIVE_IMAGE_FILESYSTEM_URI, Collections.singletonMap("create", "true"));
            log.debug((Object)"Creating new filesystem for native image");
        }
        catch (FileSystemAlreadyExistsException ex) {
            fs = FileSystems.getFileSystem(NATIVE_IMAGE_FILESYSTEM_URI);
            log.debug((Object)"Native image file system already exists", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        this.fileSystem = fs;
    }

    protected Path getRootPath() {
        return this.fileSystem.getPath("/", new String[0]);
    }

    protected Resource createResource(Path file, String pathToAdd) {
        return new PathResource(pathToAdd, file);
    }

    public void close() {
    }

    public List<String> describeLocations() {
        return Collections.singletonList(this.fileSystem.toString());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " (" + String.valueOf(this.getRootPath()) + ") (" + this.fileSystem.toString() + ")";
    }
}

