/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.quarkus.agroal.runtime.AgroalDataSourceUtil;
import io.quarkus.arc.ActiveResult;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InactiveBeanException;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseDataSourceRuntimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseFactoryProducer;
import io.quarkus.liquibase.runtime.LiquibaseFactoryUtil;
import io.quarkus.liquibase.runtime.LiquibaseRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;

@Recorder
public class LiquibaseRecorder {
    private final RuntimeValue<LiquibaseRuntimeConfig> config;

    public LiquibaseRecorder(RuntimeValue<LiquibaseRuntimeConfig> config) {
        this.config = config;
    }

    public Supplier<ActiveResult> liquibaseCheckActiveSupplier(final String dataSourceName) {
        return new Supplier<ActiveResult>(){

            @Override
            public ActiveResult get() {
                InjectableBean dataSourceBean = AgroalDataSourceUtil.dataSourceInstance((String)dataSourceName).getHandle().getBean();
                ActiveResult dataSourceActive = dataSourceBean.checkActive();
                if (!dataSourceActive.value()) {
                    return ActiveResult.inactive((String)String.format(Locale.ROOT, "Liquibase for datasource '%s' was deactivated automatically because this datasource was deactivated.", dataSourceName), (ActiveResult)dataSourceActive);
                }
                return ActiveResult.active();
            }
        };
    }

    public Function<SyntheticCreationalContext<LiquibaseFactory>, LiquibaseFactory> liquibaseFunction(final String dataSourceName) {
        return new Function<SyntheticCreationalContext<LiquibaseFactory>, LiquibaseFactory>(){

            @Override
            public LiquibaseFactory apply(SyntheticCreationalContext<LiquibaseFactory> context) {
                DataSource dataSource = (DataSource)context.getInjectedReference(DataSource.class, new Annotation[]{AgroalDataSourceUtil.qualifier((String)dataSourceName)});
                LiquibaseFactoryProducer liquibaseProducer = (LiquibaseFactoryProducer)context.getInjectedReference(LiquibaseFactoryProducer.class, new Annotation[0]);
                return liquibaseProducer.createLiquibaseFactory(dataSource, dataSourceName);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStartActions(String dataSourceName) {
        block17: {
            if (!((LiquibaseRuntimeConfig)this.config.getValue()).enabled()) {
                return;
            }
            LiquibaseDataSourceRuntimeConfig dataSourceConfig = ((LiquibaseRuntimeConfig)this.config.getValue()).datasources().get(dataSourceName);
            if (!dataSourceConfig.cleanAtStart() && !dataSourceConfig.migrateAtStart()) {
                return;
            }
            InjectableInstance liquibaseFactoryInstance = Arc.container().select(LiquibaseFactory.class, new Annotation[]{LiquibaseFactoryUtil.getLiquibaseFactoryQualifier(dataSourceName)});
            if (!liquibaseFactoryInstance.isResolvable() || !liquibaseFactoryInstance.getHandle().getBean().isActive()) {
                return;
            }
            LiquibaseFactory liquibaseFactory = (LiquibaseFactory)liquibaseFactoryInstance.get();
            try (Liquibase liquibase = liquibaseFactory.createLiquibase();){
                if (dataSourceConfig.cleanAtStart()) {
                    liquibase.dropAll();
                }
                if (!dataSourceConfig.migrateAtStart()) break block17;
                LockService lockService = LockServiceFactory.getInstance().getLockService(liquibase.getDatabase());
                lockService.waitForLock();
                try {
                    if (dataSourceConfig.validateOnMigrate()) {
                        liquibase.validate();
                    }
                    liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
                }
                finally {
                    lockService.releaseLock();
                }
            }
            catch (InactiveBeanException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Error starting Liquibase", e);
            }
        }
    }
}

