/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.commands.CreateJBangProject;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.CodestartResourceLoadersBuilder;
import io.quarkus.devtools.project.JavaVersion;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.maven.CreateProjectMojo;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.platform.tools.maven.MojoMessageWriter;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.fusesource.jansi.Ansi;

@Mojo(name="create-jbang", requiresProject=false)
public class CreateJBangMojo
extends AbstractMojo {
    @Parameter(property="noJBangWrapper", defaultValue="false")
    private boolean noJBangWrapper;
    @Parameter(property="platformGroupId", required=false)
    private String bomGroupId;
    @Parameter(property="platformArtifactId", required=false)
    private String bomArtifactId;
    @Parameter(property="platformVersion", required=false)
    private String bomVersion;
    @Parameter(property="extensions")
    private Set<String> extensions;
    @Parameter(property="outputDirectory", defaultValue="${basedir}/jbang-with-quarkus")
    private File outputDirectory;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(property="javaVersion")
    private String javaVersion;
    @Component
    private RepositorySystem repoSystem;
    @Component
    RemoteRepositoryManager remoteRepoManager;

    public void execute() throws MojoExecutionException {
        boolean success;
        ExtensionCatalog catalog;
        MavenArtifactResolver mvn;
        try {
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create directory " + this.outputDirectory, (Exception)e);
        }
        File projectRoot = this.outputDirectory;
        Path projectDirPath = projectRoot.toPath();
        try {
            mvn = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRepositorySystemSession(this.getLog().isDebugEnabled() ? this.repoSession : MojoUtils.muteTransferListener((RepositorySystemSession)this.repoSession))).setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).build();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", e);
        }
        MojoMessageWriter log = new MojoMessageWriter(this.getLog());
        try {
            catalog = CreateProjectMojo.resolveExtensionsCatalog(this, this.bomGroupId, this.bomArtifactId, this.bomVersion, QuarkusProjectHelper.getCatalogResolver((MavenArtifactResolver)mvn, (MessageWriter)log), mvn, log);
        }
        catch (RegistryResolutionException e) {
            throw new MojoExecutionException("Failed to resolve Quarkus extension catalog", (Exception)((Object)e));
        }
        List codestartsResourceLoader = CodestartResourceLoadersBuilder.codestartLoadersBuilder().catalog(catalog).artifactResolver(mvn).build();
        CreateJBangProject createJBangProject = new CreateJBangProject(QuarkusProject.of((Path)projectDirPath, (ExtensionCatalog)catalog, (List)codestartsResourceLoader, (MessageWriter)log, (BuildTool)BuildTool.MAVEN, (JavaVersion)new JavaVersion(this.javaVersion))).extensions(this.extensions).javaVersion(this.javaVersion).setValue("codegen.no-jbang-wrapper", (Object)this.noJBangWrapper);
        try {
            success = createJBangProject.execute().isSuccess();
        }
        catch (QuarkusCommandException e) {
            throw new MojoExecutionException("Failed to generate JBang Quarkus project", (Exception)((Object)e));
        }
        if (!success) {
            throw new MojoExecutionException("Failed to generate JBang Quarkus project");
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"========================================================================");
        this.getLog().warn((CharSequence)Ansi.ansi().a("Quarkus JBang project is an experimental feature.").toString());
        this.getLog().info((CharSequence)"========================================================================");
        this.getLog().info((CharSequence)"");
    }
}

