/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.components;

import io.quarkus.maven.BuildAnalyticsProvider;
import io.quarkus.maven.QuarkusBootstrapProvider;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;

@Singleton
@Named(value="quarkus-bootstrap")
public class BootstrapSessionListener
extends AbstractMavenLifecycleParticipant {
    private final QuarkusBootstrapProvider bootstrapProvider;
    private final BuildAnalyticsProvider buildAnalyticsProvider;
    private boolean enabled;

    @Inject
    public BootstrapSessionListener(QuarkusBootstrapProvider bootstrapProvider, BuildAnalyticsProvider buildAnalyticsProvider) {
        this.bootstrapProvider = bootstrapProvider;
        this.buildAnalyticsProvider = buildAnalyticsProvider;
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        try {
            this.bootstrapProvider.close();
            this.buildAnalyticsProvider.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

