/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.amqp.runtime;

import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.tls.runtime.config.TlsConfigUtils;
import io.smallrye.reactive.messaging.ClientCustomizer;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.core.net.NetClientOptions;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

@ApplicationScoped
public class AmqpClientConfigCustomizer
implements ClientCustomizer<AmqpClientOptions> {
    private static final Logger log = Logger.getLogger(AmqpClientConfigCustomizer.class);
    @Inject
    TlsConfigurationRegistry tlsRegistry;

    public AmqpClientOptions customize(String channel, Config channelConfig, AmqpClientOptions options) {
        String tlsConfig;
        Optional maybeTlsConfig;
        Optional tlsConfigName = channelConfig.getOptionalValue("tls-configuration-name", String.class);
        if (tlsConfigName.isPresent() && (maybeTlsConfig = this.tlsRegistry.get(tlsConfig = (String)tlsConfigName.get())).isPresent()) {
            TlsConfigUtils.configure((NetClientOptions)options, (TlsConfiguration)((TlsConfiguration)maybeTlsConfig.get()));
            log.debugf("Configured RabbitMQOptions for channel %s with TLS configuration %s", (Object)channel, (Object)tlsConfig);
        }
        return options;
    }
}

