/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime.dev.ui;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.smallrye.reactivemessaging.runtime.SmallRyeReactiveMessagingRecorder;
import io.quarkus.smallrye.reactivemessaging.runtime.dev.ui.Connectors;
import io.quarkus.smallrye.reactivemessaging.runtime.dev.ui.DevConsoleRecorder;
import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.providers.extension.ChannelConfiguration;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class DevReactiveMessagingInfos {
    private final LazyValue<List<DevChannelInfo>> channels = new LazyValue((Supplier)new Supplier<List<DevChannelInfo>>(){

        @Override
        public List<DevChannelInfo> get() {
            ArcContainer container = Arc.container();
            SmallRyeReactiveMessagingRecorder.SmallRyeReactiveMessagingContext context = (SmallRyeReactiveMessagingRecorder.SmallRyeReactiveMessagingContext)container.instance(SmallRyeReactiveMessagingRecorder.SmallRyeReactiveMessagingContext.class, new Annotation[0]).get();
            HashMap<String, List> publishers = new HashMap<String, List>();
            HashMap<String, List> consumers = new HashMap<String, List>();
            Function<String, List> fun = e -> new ArrayList();
            Connectors connectors = (Connectors)container.instance(Connectors.class, new Annotation[0]).get();
            for (Map.Entry<String, Component> entry : connectors.outgoingConnectors.entrySet()) {
                publishers.computeIfAbsent(entry.getKey(), fun).add(entry.getValue());
            }
            for (Map.Entry<String, Component> entry : connectors.incomingConnectors.entrySet()) {
                consumers.computeIfAbsent(entry.getKey(), fun).add(entry.getValue());
            }
            Iterator<Map.Entry<String, Component>> iterator = context.getEmitterConfigurations().iterator();
            while (iterator.hasNext()) {
                EmitterConfiguration emitter;
                publishers.computeIfAbsent(emitter.name(), fun).add(new Component(ComponentType.EMITTER, (String)((emitter = (EmitterConfiguration)iterator.next()).broadcast() ? "<span class=\"annotation\">&#64;Broadcast</span> " : DevReactiveMessagingInfos.asCode(DevConsoleRecorder.EMITTERS.get(emitter.name())))));
            }
            for (ChannelConfiguration channel : context.getChannelConfigurations()) {
                consumers.computeIfAbsent(channel.channelName, fun).add(new Component(ComponentType.CHANNEL, DevReactiveMessagingInfos.asCode(DevConsoleRecorder.CHANNELS.get(channel.channelName))));
            }
            for (MediatorConfiguration mediator : context.getMediatorConfigurations()) {
                boolean isProcessor;
                boolean bl = isProcessor = !mediator.getIncoming().isEmpty() && !mediator.getOutgoings().isEmpty();
                if (isProcessor) {
                    for (String outgoing : mediator.getOutgoings()) {
                        publishers.computeIfAbsent(outgoing, fun).add(new Component(ComponentType.PROCESSOR, DevReactiveMessagingInfos.asMethod(mediator.methodAsString())));
                    }
                    for (String incoming : mediator.getIncoming()) {
                        consumers.computeIfAbsent(incoming, fun).add(new Component(ComponentType.PROCESSOR, DevReactiveMessagingInfos.asMethod(mediator.methodAsString())));
                    }
                    continue;
                }
                if (!mediator.getOutgoings().isEmpty()) {
                    for (String outgoing : mediator.getOutgoings()) {
                        StringBuilder builder = new StringBuilder();
                        builder.append(DevReactiveMessagingInfos.asMethod(mediator.methodAsString()));
                        if (mediator.getBroadcast()) {
                            builder.append("[broadcast: true]");
                        }
                        publishers.computeIfAbsent(outgoing, fun).add(new Component(ComponentType.PUBLISHER, builder.toString()));
                    }
                    continue;
                }
                if (mediator.getIncoming().isEmpty()) continue;
                for (String incoming : mediator.getIncoming()) {
                    consumers.computeIfAbsent(incoming, fun).add(new Component(ComponentType.SUBSCRIBER, DevReactiveMessagingInfos.asMethod(mediator.methodAsString())));
                }
            }
            HashSet channels = new HashSet();
            channels.addAll(publishers.keySet());
            channels.addAll(consumers.keySet());
            ArrayList<DevChannelInfo> infos = new ArrayList<DevChannelInfo>();
            for (String channel : channels) {
                infos.add(new DevChannelInfo(channel, (List)publishers.get(channel), (List)consumers.get(channel)));
            }
            Collections.sort(infos);
            return infos;
        }
    });

    static String asMethod(String value) {
        return DevReactiveMessagingInfos.asCode(value + "()");
    }

    static String asCode(String value) {
        return "<code>" + value + "</code>";
    }

    public List<DevChannelInfo> getChannels() {
        return (List)this.channels.get();
    }

    public static enum ComponentType {
        CONNECTOR,
        PROCESSOR,
        PUBLISHER,
        EMITTER,
        CHANNEL,
        SUBSCRIBER;

    }

    public static class Component {
        public final ComponentType type;
        public final String description;

        public Component(ComponentType type, String description) {
            this.type = type;
            this.description = description;
        }

        boolean isConnector() {
            return this.type == ComponentType.CONNECTOR;
        }
    }

    public static class DevChannelInfo
    implements Comparable<DevChannelInfo> {
        private final String name;
        private final List<Component> publishers;
        private final List<Component> consumers;

        public DevChannelInfo(String name, List<Component> publishers, List<Component> consumers) {
            this.name = name;
            this.publishers = publishers != null ? publishers : Collections.emptyList();
            this.consumers = consumers != null ? consumers : Collections.emptyList();
        }

        public String getName() {
            return this.name;
        }

        public List<Component> getPublishers() {
            return this.publishers;
        }

        public List<Component> getConsumers() {
            return this.consumers;
        }

        @Override
        public int compareTo(DevChannelInfo other) {
            long otherConsumersConnectors;
            long otherPublisherConnectors;
            long publisherConnectors = this.publishers.stream().filter(Component::isConnector).count();
            if (publisherConnectors != (otherPublisherConnectors = other.publishers.stream().filter(Component::isConnector).count())) {
                return Long.compare(otherPublisherConnectors, publisherConnectors);
            }
            long consumerConnectors = this.consumers.stream().filter(Component::isConnector).count();
            if (consumerConnectors != (otherConsumersConnectors = other.consumers.stream().filter(Component::isConnector).count())) {
                return Long.compare(otherConsumersConnectors, consumerConnectors);
            }
            return this.name.compareTo(other.name);
        }
    }
}

