/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder.mpmetrics;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.micrometer.deployment.MicrometerProcessor;
import io.quarkus.micrometer.deployment.binder.mpmetrics.MetricAnnotationInfo;
import io.quarkus.micrometer.deployment.binder.mpmetrics.MetricDotNames;
import java.util.Collection;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class AnnotationHandler {
    private static final Logger log = Logger.getLogger(AnnotationHandler.class);

    static AnnotationsTransformerBuildItem transformAnnotations(IndexView index, DotName meterAnnotation) {
        return AnnotationHandler.transformAnnotations(index, meterAnnotation, meterAnnotation);
    }

    static AnnotationsTransformerBuildItem transformAnnotations(final IndexView index, final DotName sourceAnnotation, final DotName targetAnnotation) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                Collection annotations = ctx.getAnnotations();
                AnnotationInstance annotation = MicrometerProcessor.findAnnotation(annotations, sourceAnnotation);
                if (annotation == null) {
                    return;
                }
                AnnotationTarget target = ctx.getTarget();
                ClassInfo classInfo = null;
                MethodInfo methodInfo = null;
                FieldInfo fieldInfo = null;
                if (ctx.isMethod()) {
                    methodInfo = target.asMethod();
                    classInfo = methodInfo.declaringClass();
                } else if (ctx.isField()) {
                    fieldInfo = target.asField();
                    classInfo = fieldInfo.declaringClass();
                } else if (ctx.isClass()) {
                    classInfo = target.asClass();
                    if (target.asClass().classAnnotation(DotNames.INTERCEPTOR) != null) {
                        return;
                    }
                }
                if (AnnotationHandler.removeCountedWhenTimed(sourceAnnotation, target, classInfo, methodInfo) || AnnotationHandler.removeMetricWhenProduces(sourceAnnotation, target, methodInfo, fieldInfo)) {
                    ((Transformation)ctx.transform().remove(x -> x == annotation)).done();
                    return;
                }
                MetricAnnotationInfo annotationInfo = new MetricAnnotationInfo(annotation, index, classInfo, methodInfo, fieldInfo);
                ((Transformation)((Transformation)ctx.transform().remove(x -> x == annotation)).add(targetAnnotation, annotationInfo.getAnnotationValues())).done();
            }
        });
    }

    static boolean removeCountedWhenTimed(DotName sourceAnnotation, AnnotationTarget target, ClassInfo classInfo, MethodInfo methodInfo) {
        if (MetricDotNames.COUNTED_ANNOTATION.equals((Object)sourceAnnotation)) {
            if (methodInfo == null) {
                if (MicrometerProcessor.findAnnotation(classInfo.classAnnotations(), MetricDotNames.TIMED_ANNOTATION) == null && MicrometerProcessor.findAnnotation(classInfo.classAnnotations(), MetricDotNames.SIMPLY_TIMED_ANNOTATION) == null) {
                    return false;
                }
                log.warnf("Bean %s is both counted and timed. The @Counted annotation will be suppressed in favor of the count emitted by the timer.", (Object)classInfo.name().toString());
                return true;
            }
            if (!methodInfo.hasAnnotation(MetricDotNames.SIMPLY_TIMED_ANNOTATION) && !methodInfo.hasAnnotation(MetricDotNames.TIMED_ANNOTATION)) {
                return false;
            }
            log.warnf("Method %s of bean %s is both counted and timed. The @Counted annotation will be suppressed in favor of the count emitted by the timer.", (Object)methodInfo.name(), (Object)classInfo.name().toString());
            return true;
        }
        return false;
    }

    private static boolean removeMetricWhenProduces(DotName sourceAnnotation, AnnotationTarget target, MethodInfo methodInfo, FieldInfo fieldInfo) {
        if (MetricDotNames.METRIC_ANNOTATION.equals((Object)sourceAnnotation)) {
            if (methodInfo != null && !methodInfo.hasAnnotation(DotNames.PRODUCES) || fieldInfo != null && !fieldInfo.hasAnnotation(DotNames.PRODUCES)) {
                return false;
            }
            log.errorf("A declared bean uses the @Metric annotation with a @Producer field or method, which is not compatible with micrometer support. The annotation target will be ignored. (%s - %s)", (Object)target, (Object)System.identityHashCode(target));
            return true;
        }
        return false;
    }
}

