/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.NetworkMetrics;
import java.util.Map;

public class VertxNetworkMetrics
implements NetworkMetrics<Map<String, Object>> {
    final MeterRegistry registry;
    final String nameBytesRead;
    final String nameBytesWritten;
    final String nameExceptionOccurred;

    VertxNetworkMetrics(MeterRegistry registry, String prefix) {
        this.registry = registry;
        this.nameBytesRead = prefix + ".bytes.read";
        this.nameBytesWritten = prefix + ".bytes.written";
        this.nameExceptionOccurred = prefix + ".errors";
    }

    public void bytesRead(Map<String, Object> socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        DistributionSummary.builder((String)this.nameBytesRead).register(this.registry).record((double)numberOfBytes);
    }

    public void bytesWritten(Map<String, Object> socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        DistributionSummary.builder((String)this.nameBytesWritten).register(this.registry).record((double)numberOfBytes);
    }

    public void exceptionOccurred(Map<String, Object> socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.registry.counter(this.nameExceptionOccurred, new String[]{"class", t.getClass().getName()}).increment();
    }
}

