/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.stork;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.smallrye.stork.api.observability.ObservationCollector;
import io.smallrye.stork.api.observability.StorkEventHandler;
import io.smallrye.stork.api.observability.StorkObservation;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Typed;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

@ApplicationScoped
@Typed(value={ObservationCollector.class})
public class StorkObservationCollectorBean
implements ObservationCollector,
StorkEventHandler {
    public static final String METRICS_SUFIX = "-metrics";
    final MeterRegistry registry = Metrics.globalRegistry;
    public static final Map<String, StorkObservation> STORK_METRICS = new ConcurrentHashMap<String, StorkObservation>();

    public StorkObservation create(String serviceName, String serviceDiscoveryType, String serviceSelectionType) {
        return STORK_METRICS.computeIfAbsent(serviceName + METRICS_SUFIX, key -> new StorkObservation(serviceName, serviceDiscoveryType, serviceSelectionType, (StorkEventHandler)this));
    }

    public void complete(StorkObservation observation) {
        Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"service-name", (String)observation.getServiceName())});
        Counter instanceCounter = Counter.builder((String)"stork.service-discovery.instances.count").description("The number of service instances discovered").tags((Iterable)tags).register(this.registry);
        Timer serviceDiscoveryTimer = Timer.builder((String)"stork.service-discovery.duration").description("The duration of the discovery operation").tags((Iterable)tags).register(this.registry);
        Timer serviceSelectionTimer = Timer.builder((String)"stork.service-selection.duration").description("The duration of the selection operation ").tags((Iterable)tags).register(this.registry);
        Counter serviceDiscoveryFailures = Counter.builder((String)"stork.service-discovery.failures").description("The number of failures during service discovery").tags((Iterable)tags).register(this.registry);
        Counter serviceSelectionFailures = Counter.builder((String)"stork.service-selection.failures").description("The number of failures during service selection.").tags((Iterable)tags).register(this.registry);
        instanceCounter.increment((double)observation.getDiscoveredInstancesCount());
        serviceDiscoveryTimer.record((long)observation.getServiceDiscoveryDuration().getNano(), TimeUnit.NANOSECONDS);
        serviceSelectionTimer.record((long)observation.getServiceSelectionDuration().getNano(), TimeUnit.NANOSECONDS);
        if (observation.failure() != null) {
            if (observation.isServiceDiscoverySuccessful()) {
                serviceSelectionFailures.increment();
            } else {
                serviceDiscoveryFailures.increment();
            }
        }
    }
}

