/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.tracing;

import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.opentracing.contrib.mongo.common.TracingCommandListener;
import io.opentracing.util.GlobalTracer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class MongoTracingCommandListener
implements CommandListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoTracingCommandListener.class);
    private TracingCommandListener delegate = new TracingCommandListener.Builder(GlobalTracer.get()).build();

    public MongoTracingCommandListener() {
        LOGGER.debug((Object)"TracingCommandListener Delegate created");
    }

    public void commandStarted(CommandStartedEvent event) {
        LOGGER.trace((Object)("commandStarted event " + event.getCommandName()));
        this.delegate.commandStarted(event);
    }

    public void commandFailed(CommandFailedEvent event) {
        LOGGER.trace((Object)("commandFailed event " + event.getCommandName()));
        this.delegate.commandFailed(event);
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        LOGGER.trace((Object)("commandSucceeded event " + event.getCommandName()));
        this.delegate.commandSucceeded(event);
    }
}

