/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mutiny.runtime;

import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.threads.ContextHandler;

class ContextualRunnableScheduledFuture<V>
implements RunnableScheduledFuture<V> {
    private final RunnableScheduledFuture<V> runnable;
    private final Object context;
    private final ContextHandler<Object> contextHandler;

    public ContextualRunnableScheduledFuture(ContextHandler<Object> contextHandler, Object context, RunnableScheduledFuture<V> runnable) {
        this.contextHandler = contextHandler;
        this.context = context;
        this.runnable = runnable;
    }

    @Override
    public boolean isPeriodic() {
        return this.runnable.isPeriodic();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.runnable.getDelay(unit);
    }

    @Override
    public int compareTo(Delayed o) {
        return this.runnable.compareTo(o);
    }

    @Override
    public void run() {
        if (this.contextHandler != null) {
            this.contextHandler.runWith(this.runnable, this.context);
        } else {
            this.runnable.run();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.runnable.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.runnable.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.runnable.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.runnable.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.runnable.get(timeout, unit);
    }
}

