/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public interface OidcTlsSupport {
    public TlsConfigSupport forConfig(OidcCommonConfig.Tls var1);

    public static OidcTlsSupport empty() {
        return new OidcTlsSupport(){

            @Override
            public TlsConfigSupport forConfig(OidcCommonConfig.Tls config) {
                return new TlsConfigSupport(Optional.empty(), null, false);
            }
        };
    }

    public static OidcTlsSupport of(Supplier<TlsConfigurationRegistry> registrySupplier) {
        return OidcTlsSupport.of(registrySupplier.get());
    }

    public static OidcTlsSupport of(final TlsConfigurationRegistry registry) {
        return new OidcTlsSupport(){
            private final boolean globalTrustAll;
            {
                this.globalTrustAll = registry.getDefault().map(new Function<TlsConfiguration, Boolean>(){

                    @Override
                    public Boolean apply(TlsConfiguration tlsConfiguration) {
                        return tlsConfiguration.isTrustAll();
                    }
                }).orElse(Boolean.FALSE);
            }

            @Override
            public TlsConfigSupport forConfig(OidcCommonConfig.Tls config) {
                return new TlsConfigSupport(config.tlsConfigurationName, registry, this.globalTrustAll);
            }
        };
    }

    public static final class TlsConfigSupport {
        private final TlsConfiguration tlsConfig;
        private final boolean globalTrustAll;
        private final String tlsConfigName;

        private TlsConfigSupport(Optional<String> tlsConfigurationName, TlsConfigurationRegistry registry, boolean globalTrustAll) {
            if (registry != null) {
                this.tlsConfig = TlsConfiguration.from((TlsConfigurationRegistry)registry, tlsConfigurationName).orElse(null);
                this.tlsConfigName = tlsConfigurationName.orElse(null);
            } else {
                this.tlsConfig = null;
                this.tlsConfigName = null;
            }
            this.globalTrustAll = globalTrustAll;
        }

        public boolean useTlsRegistry() {
            return this.tlsConfig != null;
        }

        public TlsConfiguration getTlsConfig() {
            return this.tlsConfig;
        }

        public boolean isGlobalTrustAll() {
            return this.globalTrustAll;
        }

        public SSLContext getSslContext() {
            if (this.useTlsRegistry()) {
                try {
                    return this.tlsConfig.createSSLContext();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create SSLContext", e);
                }
            }
            return null;
        }

        public String getTlsConfigName() {
            return this.tlsConfigName;
        }
    }
}

