/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.reactive;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.oidc.token.propagation.AccessToken;
import io.quarkus.oidc.token.propagation.reactive.AccessTokenRequestReactiveFilter;
import io.quarkus.oidc.token.propagation.reactive.OidcTokenPropagationReactiveBuildTimeConfig;
import io.quarkus.rest.client.reactive.deployment.DotNames;
import io.quarkus.rest.client.reactive.deployment.RegisterProviderAnnotationInstanceBuildItem;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

@BuildSteps(onlyIf={IsEnabled.class})
public class OidcTokenPropagationReactiveBuildStep {
    private static final DotName ACCESS_TOKEN = DotName.createSimple((String)AccessToken.class.getName());
    private static final DotName ACCESS_TOKEN_REQUEST_REACTIVE_FILTER = DotName.createSimple((String)AccessTokenRequestReactiveFilter.class.getName());

    @BuildStep
    void oidcClientFilterSupport(CombinedIndexBuildItem indexBuildItem, BuildProducer<RegisterProviderAnnotationInstanceBuildItem> producer) {
        Collection instances = indexBuildItem.getIndex().getAnnotations(ACCESS_TOKEN);
        for (AnnotationInstance instance : instances) {
            String targetClass = instance.target().asClass().name().toString();
            producer.produce((BuildItem)new RegisterProviderAnnotationInstanceBuildItem(targetClass, AnnotationInstance.create((DotName)DotNames.REGISTER_PROVIDER, (AnnotationTarget)instance.target(), List.of(AnnotationValue.createClassValue((String)"value", (Type)Type.create((DotName)ACCESS_TOKEN_REQUEST_REACTIVE_FILTER, (Type.Kind)Type.Kind.CLASS))))));
        }
    }

    @BuildStep
    void registerProvider(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClassesBuildItem) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(AccessTokenRequestReactiveFilter.class));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{AccessTokenRequestReactiveFilter.class}).methods().fields().build());
        additionalIndexedClassesBuildItem.produce((BuildItem)new AdditionalIndexedClassesBuildItem(AccessTokenRequestReactiveFilter.class.getName()));
    }

    public static class IsEnabled
    implements BooleanSupplier {
        OidcTokenPropagationReactiveBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled;
        }
    }
}

