/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.MemoryCache;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.runtime.ShutdownEvent;
import io.vertx.core.Vertx;
import jakarta.enterprise.event.Observes;

public class BackChannelLogoutTokenCache {
    final MemoryCache<TokenVerificationResult> cache;

    public BackChannelLogoutTokenCache(OidcTenantConfig oidcTenantConfig, Vertx vertx) {
        this.cache = new MemoryCache(vertx, oidcTenantConfig.logout.backchannel.cleanUpTimerInterval, oidcTenantConfig.logout.backchannel.tokenCacheTimeToLive, oidcTenantConfig.logout.backchannel.tokenCacheSize);
    }

    public void addTokenVerification(String token, TokenVerificationResult result) {
        this.cache.add(token, result);
    }

    public TokenVerificationResult removeTokenVerification(String token) {
        return this.cache.remove(token);
    }

    public boolean containsTokenVerification(String token) {
        return this.cache.containsKey(token);
    }

    void shutdown(@Observes ShutdownEvent event, Vertx vertx) {
        this.cache.stopTimer(vertx);
    }
}

