/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.JavaScriptRequestChecker;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.runtime.BackChannelLogoutTokenCache;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.security.ImmutablePathMatcher;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DefaultTenantConfigResolver {
    private static final Logger LOG = Logger.getLogger(DefaultTenantConfigResolver.class);
    private static final String CURRENT_STATIC_TENANT_ID = "static.tenant.id";
    private static final String CURRENT_STATIC_TENANT_ID_NULL = "static.tenant.id.null";
    private static final String CURRENT_DYNAMIC_TENANT_CONFIG = "dynamic.tenant.config";
    private final ConcurrentHashMap<String, BackChannelLogoutTokenCache> backChannelLogoutTokens = new ConcurrentHashMap();
    private final BlockingTaskRunner<OidcTenantConfig> blockingRequestContext;
    private final boolean securityEventObserved;
    private final TenantConfigBean tenantConfigBean;
    private final TenantResolver[] staticTenantResolvers;
    private final boolean annotationBasedTenantResolutionEnabled;
    private final String rootPath;
    @Inject
    Instance<TenantConfigResolver> tenantConfigResolver;
    @Inject
    Instance<JavaScriptRequestChecker> javaScriptRequestChecker;
    @Inject
    Instance<TokenStateManager> tokenStateManager;
    @Inject
    Instance<TokenIntrospectionCache> tokenIntrospectionCache;
    @Inject
    Instance<UserInfoCache> userInfoCache;
    @Inject
    Event<SecurityEvent> securityEvent;
    @Inject
    @ConfigProperty(name="quarkus.http.proxy.enable-forwarded-prefix")
    boolean enableHttpForwardedPrefix;

    DefaultTenantConfigResolver(BlockingSecurityExecutor blockingExecutor, BeanManager beanManager, Instance<TenantResolver> tenantResolverInstance, @ConfigProperty(name="quarkus.oidc.resolve-tenants-with-issuer") boolean resolveTenantsWithIssuer, @ConfigProperty(name="quarkus.security.events.enabled") boolean securityEventsEnabled, @ConfigProperty(name="quarkus.http.root-path") String rootPath, TenantConfigBean tenantConfigBean) {
        this.blockingRequestContext = new BlockingTaskRunner(blockingExecutor);
        this.securityEventObserved = SecurityEventHelper.isEventObserved((io.quarkus.security.spi.runtime.SecurityEvent)new SecurityEvent(null, (SecurityIdentity)null), (BeanManager)beanManager, (boolean)securityEventsEnabled);
        this.tenantConfigBean = tenantConfigBean;
        this.staticTenantResolvers = DefaultTenantConfigResolver.prepareStaticTenantResolvers(tenantConfigBean, rootPath, tenantResolverInstance, resolveTenantsWithIssuer, new DefaultStaticTenantResolver());
        this.annotationBasedTenantResolutionEnabled = Boolean.getBoolean("io.quarkus.oidc.runtime.select-tenants-with-annotation");
        this.rootPath = rootPath;
    }

    @PostConstruct
    public void verifyResolvers() {
        if (this.tenantConfigResolver.isResolvable() && this.tenantConfigResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantConfigResolver.class + " beans registered");
        }
        if (this.tokenStateManager.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TokenStateManager.class + " beans registered");
        }
        if (this.tokenIntrospectionCache.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TokenIntrospectionCache.class + " beans registered");
        }
        if (this.userInfoCache.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + UserInfo.class + " beans registered");
        }
        if (this.javaScriptRequestChecker.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + JavaScriptRequestChecker.class + " beans registered");
        }
    }

    Uni<OidcTenantConfig> resolveConfig(final RoutingContext context) {
        return this.getDynamicTenantConfig(context).map((Function)new Function<OidcTenantConfig, OidcTenantConfig>(){

            @Override
            public OidcTenantConfig apply(OidcTenantConfig tenantConfig) {
                if (tenantConfig == null) {
                    TenantConfigContext tenantContext;
                    String tenantId = (String)context.get("tenant-id");
                    if (tenantId != null && !DefaultTenantConfigResolver.this.isTenantSetByAnnotation(context, tenantId) && (tenantContext = DefaultTenantConfigResolver.this.tenantConfigBean.getDynamicTenantsConfig().get(tenantId)) != null) {
                        if (DefaultTenantConfigResolver.this.tenantConfigBean.getStaticTenantsConfig().containsKey(tenantId)) {
                            context.put(DefaultTenantConfigResolver.CURRENT_STATIC_TENANT_ID, (Object)tenantId);
                        }
                        return tenantContext.getOidcTenantConfig();
                    }
                    TenantConfigContext tenant = DefaultTenantConfigResolver.this.getStaticTenantContext(context);
                    if (tenant != null) {
                        tenantConfig = tenant.oidcConfig;
                    }
                }
                return tenantConfig;
            }
        });
    }

    Uni<TenantConfigContext> resolveContext(String tenantId) {
        return this.initializeStaticTenantIfContextNotReady(this.getStaticTenantContext(tenantId));
    }

    Uni<TenantConfigContext> resolveContext(final RoutingContext context) {
        return this.getDynamicTenantContext(context).onItem().ifNull().switchTo((Supplier)new Supplier<Uni<? extends TenantConfigContext>>(){

            @Override
            public Uni<? extends TenantConfigContext> get() {
                return DefaultTenantConfigResolver.this.initializeStaticTenantIfContextNotReady(DefaultTenantConfigResolver.this.getStaticTenantContext(context));
            }
        });
    }

    private Uni<TenantConfigContext> initializeStaticTenantIfContextNotReady(TenantConfigContext tenantContext) {
        if (tenantContext != null && !tenantContext.ready) {
            TenantConfigContext readyTenantContext = this.tenantConfigBean.getDynamicTenantsConfig().get(tenantContext.oidcConfig.tenantId.get());
            if (readyTenantContext == null) {
                LOG.debugf("Tenant '%s' is not initialized yet, trying to create OIDC connection now", (Object)tenantContext.oidcConfig.tenantId.get());
                return this.tenantConfigBean.getTenantConfigContextFactory().apply(tenantContext.oidcConfig);
            }
            tenantContext = readyTenantContext;
        }
        return Uni.createFrom().item((Object)tenantContext);
    }

    private TenantConfigContext getStaticTenantContext(RoutingContext context) {
        String tenantId = (String)context.get(CURRENT_STATIC_TENANT_ID);
        if (tenantId == null && context.get(CURRENT_STATIC_TENANT_ID_NULL) == null) {
            tenantId = this.resolveStaticTenantId(context);
            if (tenantId != null) {
                context.put(CURRENT_STATIC_TENANT_ID, (Object)tenantId);
            } else {
                context.put(CURRENT_STATIC_TENANT_ID_NULL, (Object)true);
            }
        }
        return this.getStaticTenantContext(tenantId);
    }

    private String resolveStaticTenantId(RoutingContext context) {
        String tenantId = (String)context.get("tenant-id");
        if (this.isTenantSetByAnnotation(context, tenantId)) {
            return tenantId;
        }
        for (TenantResolver staticTenantResolver : this.staticTenantResolvers) {
            tenantId = staticTenantResolver.resolve(context);
            if (tenantId == null) continue;
            return tenantId;
        }
        return (String)context.get("tenant-id");
    }

    private boolean isTenantSetByAnnotation(RoutingContext context, String tenantId) {
        return this.annotationBasedTenantResolutionEnabled && tenantId != null && context.get("tenant-id-set-by-annotation") != null;
    }

    private TenantConfigContext getStaticTenantContext(String tenantId) {
        TenantConfigContext configContext;
        TenantConfigContext tenantConfigContext = configContext = tenantId != null ? this.tenantConfigBean.getStaticTenantsConfig().get(tenantId) : null;
        if (configContext == null) {
            if (tenantId != null && !tenantId.isEmpty()) {
                LOG.debugf("Registered TenantResolver has not provided the configuration for tenant '%s', using the default tenant", (Object)tenantId);
            }
            configContext = this.tenantConfigBean.getDefaultTenant();
        }
        return configContext;
    }

    boolean isSecurityEventObserved() {
        return this.securityEventObserved;
    }

    Event<SecurityEvent> getSecurityEvent() {
        return this.securityEvent;
    }

    TokenStateManager getTokenStateManager() {
        return (TokenStateManager)this.tokenStateManager.get();
    }

    TokenIntrospectionCache getTokenIntrospectionCache() {
        return this.tokenIntrospectionCache.isResolvable() ? (TokenIntrospectionCache)this.tokenIntrospectionCache.get() : null;
    }

    UserInfoCache getUserInfoCache() {
        return this.userInfoCache.isResolvable() ? (UserInfoCache)this.userInfoCache.get() : null;
    }

    private Uni<OidcTenantConfig> getDynamicTenantConfig(RoutingContext context) {
        if (this.isTenantSetByAnnotation(context, (String)context.get("tenant-id"))) {
            return Uni.createFrom().nullItem();
        }
        if (this.tenantConfigResolver.isResolvable()) {
            Uni oidcConfig = (Uni)context.get(CURRENT_DYNAMIC_TENANT_CONFIG);
            if (oidcConfig == null) {
                oidcConfig = ((TenantConfigResolver)this.tenantConfigResolver.get()).resolve(context, this.blockingRequestContext);
                if (oidcConfig == null) {
                    oidcConfig = Uni.createFrom().nullItem();
                }
                oidcConfig = (oidcConfig = oidcConfig.memoize().indefinitely()) == null ? Uni.createFrom().nullItem() : oidcConfig.onItem().transform(cfg -> OidcUtils.resolveProviderConfig(cfg));
                context.put(CURRENT_DYNAMIC_TENANT_CONFIG, (Object)oidcConfig);
            }
            return oidcConfig;
        }
        return Uni.createFrom().nullItem();
    }

    private Uni<TenantConfigContext> getDynamicTenantContext(final RoutingContext context) {
        return this.getDynamicTenantConfig(context).chain((Function)new Function<OidcTenantConfig, Uni<? extends TenantConfigContext>>(){

            @Override
            public Uni<? extends TenantConfigContext> apply(OidcTenantConfig tenantConfig) {
                TenantConfigContext tenantContext;
                if (tenantConfig != null) {
                    String tenantId = tenantConfig.getTenantId().orElseThrow(() -> new OIDCException("Tenant configuration must have tenant id"));
                    TenantConfigContext tenantContext2 = DefaultTenantConfigResolver.this.tenantConfigBean.getDynamicTenantsConfig().get(tenantId);
                    if (tenantContext2 == null) {
                        return DefaultTenantConfigResolver.this.tenantConfigBean.getTenantConfigContextFactory().apply(tenantConfig);
                    }
                    return Uni.createFrom().item((Object)tenantContext2);
                }
                String tenantId = (String)context.get("tenant-id");
                if (tenantId != null && !DefaultTenantConfigResolver.this.isTenantSetByAnnotation(context, tenantId) && (tenantContext = DefaultTenantConfigResolver.this.tenantConfigBean.getDynamicTenantsConfig().get(tenantId)) != null) {
                    return Uni.createFrom().item((Object)tenantContext);
                }
                return Uni.createFrom().nullItem();
            }
        });
    }

    boolean isEnableHttpForwardedPrefix() {
        return this.enableHttpForwardedPrefix;
    }

    public Map<String, BackChannelLogoutTokenCache> getBackChannelLogoutTokens() {
        return this.backChannelLogoutTokens;
    }

    public TenantConfigBean getTenantConfigBean() {
        return this.tenantConfigBean;
    }

    public JavaScriptRequestChecker getJavaScriptRequestChecker() {
        return this.javaScriptRequestChecker.isResolvable() ? (JavaScriptRequestChecker)this.javaScriptRequestChecker.get() : null;
    }

    private static TenantResolver[] prepareStaticTenantResolvers(TenantConfigBean tenantConfigBean, String rootPath, Instance<TenantResolver> tenantResolverInstance, boolean resolveTenantsWithIssuer, TenantResolver defaultStaticTenantResolver) {
        PathMatchingTenantResolver pathMatchingTenantResolver;
        ArrayList<TenantResolver> staticTenantResolvers = new ArrayList<TenantResolver>();
        if (tenantResolverInstance.isResolvable()) {
            if (tenantResolverInstance.isAmbiguous()) {
                throw new IllegalStateException("Multiple " + TenantResolver.class + " beans registered");
            }
            staticTenantResolvers.add((TenantResolver)tenantResolverInstance.get());
        }
        if ((pathMatchingTenantResolver = PathMatchingTenantResolver.of(tenantConfigBean.getStaticTenantsConfig(), rootPath, tenantConfigBean.getDefaultTenant())) != null) {
            staticTenantResolvers.add(pathMatchingTenantResolver);
        }
        if (!tenantConfigBean.getStaticTenantsConfig().isEmpty()) {
            staticTenantResolvers.add(defaultStaticTenantResolver);
        }
        if (resolveTenantsWithIssuer) {
            IssuerBasedTenantResolver.addIssuerBasedTenantResolver(staticTenantResolvers, tenantConfigBean.getStaticTenantsConfig(), tenantConfigBean.getDefaultTenant());
        }
        return staticTenantResolvers.toArray(new TenantResolver[0]);
    }

    public OidcTenantConfig getResolvedConfig(String sessionTenantId) {
        if ("Default".equals(sessionTenantId)) {
            return this.tenantConfigBean.getDefaultTenant().getOidcTenantConfig();
        }
        if (this.tenantConfigBean.getStaticTenantsConfig().containsKey(sessionTenantId)) {
            return this.tenantConfigBean.getStaticTenantsConfig().get(sessionTenantId).getOidcTenantConfig();
        }
        if (this.tenantConfigBean.getDynamicTenantsConfig().containsKey(sessionTenantId)) {
            return this.tenantConfigBean.getDynamicTenantsConfig().get(sessionTenantId).getOidcTenantConfig();
        }
        return null;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    private class DefaultStaticTenantResolver
    implements TenantResolver {
        private DefaultStaticTenantResolver() {
        }

        @Override
        public String resolve(RoutingContext context) {
            String[] pathSegments = context.request().path().split("/");
            if (pathSegments.length > 0) {
                String lastPathSegment = pathSegments[pathSegments.length - 1];
                if (DefaultTenantConfigResolver.this.tenantConfigBean.getStaticTenantsConfig().containsKey(lastPathSegment)) {
                    LOG.debugf("Tenant id '%s' is selected on the '%s' request path", (Object)lastPathSegment, (Object)context.normalizedPath());
                    return lastPathSegment;
                }
            }
            return null;
        }
    }

    private static class PathMatchingTenantResolver
    implements TenantResolver {
        private static final String DEFAULT_TENANT = "PathMatchingTenantResolver#DefaultTenant";
        private final ImmutablePathMatcher<String> staticTenantPaths;

        private PathMatchingTenantResolver(ImmutablePathMatcher<String> staticTenantPaths) {
            this.staticTenantPaths = staticTenantPaths;
        }

        private static PathMatchingTenantResolver of(Map<String, TenantConfigContext> staticTenantsConfig, String rootPath, TenantConfigContext defaultTenant) {
            ImmutablePathMatcher.ImmutablePathMatcherBuilder builder = ImmutablePathMatcher.builder().rootPath(rootPath);
            PathMatchingTenantResolver.addPath(DEFAULT_TENANT, defaultTenant.oidcConfig, (ImmutablePathMatcher.ImmutablePathMatcherBuilder<String>)builder);
            for (Map.Entry<String, TenantConfigContext> e : staticTenantsConfig.entrySet()) {
                PathMatchingTenantResolver.addPath(e.getKey(), e.getValue().oidcConfig, (ImmutablePathMatcher.ImmutablePathMatcherBuilder<String>)builder);
            }
            return builder.hasPaths() ? new PathMatchingTenantResolver((ImmutablePathMatcher<String>)builder.build()) : null;
        }

        @Override
        public String resolve(RoutingContext context) {
            String tenantId = (String)this.staticTenantPaths.match(context.normalizedPath()).getValue();
            if (tenantId != null) {
                LOG.debugf("Tenant id '%s' is selected on the '%s' request path", (Object)tenantId, (Object)context.normalizedPath());
                return tenantId;
            }
            return null;
        }

        private static ImmutablePathMatcher.ImmutablePathMatcherBuilder<String> addPath(String tenant, OidcTenantConfig config, ImmutablePathMatcher.ImmutablePathMatcherBuilder<String> builder) {
            if (config != null && config.tenantPaths.isPresent()) {
                for (String path : config.tenantPaths.get()) {
                    builder.addPath(path, (Object)tenant);
                }
            }
            return builder;
        }
    }

    private static final class IssuerBasedTenantResolver
    implements TenantResolver {
        private final TenantConfigContext[] tenantConfigContexts;
        private final boolean detectedTenantWithoutMetadata;

        private IssuerBasedTenantResolver(TenantConfigContext[] tenantConfigContexts, boolean detectedTenantWithoutMetadata) {
            this.tenantConfigContexts = tenantConfigContexts;
            this.detectedTenantWithoutMetadata = detectedTenantWithoutMetadata;
        }

        @Override
        public String resolve(RoutingContext context) {
            for (TenantConfigContext tenantContext : this.tenantConfigContexts) {
                JsonObject tokenJson;
                String token;
                if (this.detectedTenantWithoutMetadata && (tenantContext.getOidcMetadata() == null || tenantContext.getOidcMetadata().getIssuer() == null || "any".equals(tenantContext.getOidcMetadata().getIssuer())) || (token = OidcUtils.extractBearerToken(context, tenantContext.oidcConfig)) == null || OidcUtils.isOpaqueToken(token) || (tokenJson = OidcUtils.decodeJwtContent(token)) == null) continue;
                String iss = tokenJson.getString(Claims.iss.name());
                if (!tenantContext.getOidcMetadata().getIssuer().equals(iss)) continue;
                OidcUtils.storeExtractedBearerToken(context, token);
                String tenantId = tenantContext.oidcConfig.tenantId.get();
                LOG.debugf("Resolved the '%s' OIDC tenant based on the matching issuer '%s'", (Object)tenantId, (Object)iss);
                return tenantId;
            }
            return null;
        }

        private static TenantResolver of(Map<String, TenantConfigContext> tenantConfigContexts) {
            ArrayList<TenantConfigContext> contextsWithIssuer = new ArrayList<TenantConfigContext>();
            boolean detectedTenantWithoutMetadata = false;
            for (TenantConfigContext context : tenantConfigContexts.values()) {
                if (!context.oidcConfig.tenantEnabled || OidcUtils.isWebApp(context.oidcConfig)) continue;
                if (context.getOidcMetadata() == null) {
                    detectedTenantWithoutMetadata = true;
                    contextsWithIssuer.add(context);
                    continue;
                }
                if (context.getOidcMetadata().getIssuer() == null || "any".equals(context.getOidcMetadata().getIssuer())) continue;
                contextsWithIssuer.add(context);
            }
            if (contextsWithIssuer.isEmpty()) {
                return null;
            }
            return new IssuerBasedTenantResolver(contextsWithIssuer.toArray(new TenantConfigContext[0]), detectedTenantWithoutMetadata);
        }

        private static void addIssuerBasedTenantResolver(List<TenantResolver> resolvers, Map<String, TenantConfigContext> staticTenantsConfig, TenantConfigContext defaultTenant) {
            HashMap<String, TenantConfigContext> tenantConfigContexts = new HashMap<String, TenantConfigContext>(staticTenantsConfig);
            tenantConfigContexts.put("Default", defaultTenant);
            TenantResolver issuerTenantResolver = IssuerBasedTenantResolver.of(tenantConfigContexts);
            if (issuerTenantResolver != null) {
                resolvers.add(issuerTenantResolver);
            } else {
                LOG.debug((Object)"The 'quarkus.oidc.resolve-tenants-with-issuer' configuration property is set to true, but no static tenant supports this feature. To use this feature, please configure at least one static tenant with the discovered or configured issuer and set either 'service' or 'hybrid' application type");
            }
        }
    }
}

