/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcRedirectFilter;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.Redirect;
import io.quarkus.oidc.runtime.OidcProvider;
import io.quarkus.oidc.runtime.OidcProviderClient;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.function.Supplier;
import javax.crypto.SecretKey;
import org.jboss.logging.Logger;

final class LazyTenantConfigContext
implements TenantConfigContext {
    private static final Logger LOG = Logger.getLogger(LazyTenantConfigContext.class);
    private final Supplier<Uni<TenantConfigContext>> staticTenantCreator;
    private volatile TenantConfigContext delegate;

    LazyTenantConfigContext(TenantConfigContext delegate, Supplier<Uni<TenantConfigContext>> staticTenantCreator) {
        this.staticTenantCreator = staticTenantCreator;
        this.delegate = delegate;
    }

    @Override
    public Uni<TenantConfigContext> initialize() {
        if (!this.delegate.ready()) {
            LOG.debugf("Tenant '%s' is not initialized yet, trying to create OIDC connection now", (Object)this.delegate.oidcConfig().tenantId.get());
            return this.staticTenantCreator.get().invoke(ctx -> {
                this.delegate = ctx;
            });
        }
        return Uni.createFrom().item((Object)this.delegate);
    }

    @Override
    public OidcTenantConfig oidcConfig() {
        return this.delegate.oidcConfig();
    }

    @Override
    public OidcProvider provider() {
        return this.delegate.provider();
    }

    @Override
    public boolean ready() {
        return this.delegate.ready();
    }

    @Override
    public OidcTenantConfig getOidcTenantConfig() {
        return this.delegate.getOidcTenantConfig();
    }

    @Override
    public OidcConfigurationMetadata getOidcMetadata() {
        return this.delegate.getOidcMetadata();
    }

    @Override
    public OidcProviderClient getOidcProviderClient() {
        return this.delegate.getOidcProviderClient();
    }

    @Override
    public SecretKey getStateEncryptionKey() {
        return this.delegate.getStateEncryptionKey();
    }

    @Override
    public SecretKey getTokenEncSecretKey() {
        return this.delegate.getTokenEncSecretKey();
    }

    @Override
    public SecretKey getInternalIdTokenSecretKey() {
        return this.delegate.getInternalIdTokenSecretKey();
    }

    @Override
    public List<OidcRedirectFilter> getOidcRedirectFilters(Redirect.Location loc) {
        return this.delegate.getOidcRedirectFilters(loc);
    }
}

