/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.oidc.common.runtime.OidcClientCommonConfig;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public class OidcTenantConfig
extends OidcClientCommonConfig {
    public Optional<String> tenantId = Optional.empty();
    public boolean tenantEnabled = true;
    public Optional<ApplicationType> applicationType = Optional.empty();
    public Optional<String> authorizationPath = Optional.empty();
    public Optional<String> userInfoPath = Optional.empty();
    public Optional<String> introspectionPath = Optional.empty();
    public Optional<String> jwksPath = Optional.empty();
    public Optional<String> endSessionPath = Optional.empty();
    public Optional<List<String>> tenantPaths = Optional.empty();
    public Optional<String> publicKey = Optional.empty();
    public IntrospectionCredentials introspectionCredentials = new IntrospectionCredentials();
    public Roles roles = new Roles();
    public Token token = new Token();
    public Logout logout = new Logout();
    public CertificateChain certificateChain = new CertificateChain();
    public Authentication authentication = new Authentication();
    public CodeGrant codeGrant = new CodeGrant();
    public TokenStateManager tokenStateManager = new TokenStateManager();
    public boolean allowTokenIntrospectionCache = true;
    public boolean allowUserInfoCache = true;
    public Optional<Boolean> cacheUserInfoInIdtoken = Optional.empty();
    public Jwks jwks = new Jwks();
    public Optional<Provider> provider = Optional.empty();

    public OidcTenantConfig() {
    }

    public OidcTenantConfig(io.quarkus.oidc.runtime.OidcTenantConfig mapping, String fallbackTenantId) {
        super((io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig)mapping);
        this.tenantId = mapping.tenantId().isPresent() ? mapping.tenantId() : Optional.ofNullable(fallbackTenantId);
        this.tenantEnabled = mapping.tenantEnabled();
        this.applicationType = mapping.applicationType().map(Enum::toString).map(ApplicationType::valueOf);
        this.authorizationPath = mapping.authorizationPath();
        this.userInfoPath = mapping.userInfoPath();
        this.introspectionPath = mapping.introspectionPath();
        this.jwksPath = mapping.jwksPath();
        this.endSessionPath = mapping.endSessionPath();
        this.tenantPaths = mapping.tenantPaths();
        this.publicKey = mapping.publicKey();
        this.introspectionCredentials.addConfigMappingValues(mapping.introspectionCredentials());
        this.roles.addConfigMappingValues(mapping.roles());
        this.token.addConfigMappingValues(mapping.token());
        this.logout.addConfigMappingValues(mapping.logout());
        this.certificateChain.addConfigMappingValues(mapping.certificateChain());
        this.authentication.addConfigMappingValues(mapping.authentication());
        this.codeGrant.addConfigMappingValues(mapping.codeGrant());
        this.tokenStateManager.addConfigMappingValues(mapping.tokenStateManager());
        this.allowTokenIntrospectionCache = mapping.allowTokenIntrospectionCache();
        this.allowUserInfoCache = mapping.allowUserInfoCache();
        this.cacheUserInfoInIdtoken = mapping.cacheUserInfoInIdtoken();
        this.jwks.addConfigMappingValues(mapping.jwks());
        this.provider = mapping.provider().map(Enum::toString).map(Provider::valueOf);
    }

    public Optional<String> getAuthorizationPath() {
        return this.authorizationPath;
    }

    public void setAuthorizationPath(String authorizationPath) {
        this.authorizationPath = Optional.of(authorizationPath);
    }

    public Optional<String> getUserInfoPath() {
        return this.userInfoPath;
    }

    public void setUserInfoPath(String userInfoPath) {
        this.userInfoPath = Optional.of(userInfoPath);
    }

    public Optional<String> getIntrospectionPath() {
        return this.introspectionPath;
    }

    public void setIntrospectionPath(String introspectionPath) {
        this.introspectionPath = Optional.of(introspectionPath);
    }

    public Optional<String> getJwksPath() {
        return this.jwksPath;
    }

    public void setJwksPath(String jwksPath) {
        this.jwksPath = Optional.of(jwksPath);
    }

    public Optional<String> getEndSessionPath() {
        return this.endSessionPath;
    }

    public void setEndSessionPath(String endSessionPath) {
        this.endSessionPath = Optional.of(endSessionPath);
    }

    public Optional<String> getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = Optional.of(publicKey);
    }

    public Roles getRoles() {
        return this.roles;
    }

    public void setRoles(Roles roles) {
        this.roles = roles;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public Optional<String> getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = Optional.of(tenantId);
    }

    public boolean isTenantEnabled() {
        return this.tenantEnabled;
    }

    public void setTenantEnabled(boolean enabled) {
        this.tenantEnabled = enabled;
    }

    public void setLogout(Logout logout) {
        this.logout = logout;
    }

    public Logout getLogout() {
        return this.logout;
    }

    public Optional<Provider> getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = Optional.of(provider);
    }

    public Optional<ApplicationType> getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType type) {
        this.applicationType = Optional.of(type);
    }

    public boolean isAllowTokenIntrospectionCache() {
        return this.allowTokenIntrospectionCache;
    }

    public void setAllowTokenIntrospectionCache(boolean allowTokenIntrospectionCache) {
        this.allowTokenIntrospectionCache = allowTokenIntrospectionCache;
    }

    public boolean isAllowUserInfoCache() {
        return this.allowUserInfoCache;
    }

    public void setAllowUserInfoCache(boolean allowUserInfoCache) {
        this.allowUserInfoCache = allowUserInfoCache;
    }

    public Optional<Boolean> isCacheUserInfoInIdtoken() {
        return this.cacheUserInfoInIdtoken;
    }

    public void setCacheUserInfoInIdtoken(boolean cacheUserInfoInIdtoken) {
        this.cacheUserInfoInIdtoken = Optional.of(cacheUserInfoInIdtoken);
    }

    public IntrospectionCredentials getIntrospectionCredentials() {
        return this.introspectionCredentials;
    }

    public void setIntrospectionCredentials(IntrospectionCredentials introspectionCredentials) {
        this.introspectionCredentials = introspectionCredentials;
    }

    public CodeGrant getCodeGrant() {
        return this.codeGrant;
    }

    public void setCodeGrant(CodeGrant codeGrant) {
        this.codeGrant = codeGrant;
    }

    public CertificateChain getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(CertificateChain certificateChain) {
        this.certificateChain = certificateChain;
    }

    public static class IntrospectionCredentials {
        public Optional<String> name = Optional.empty();
        public Optional<String> secret = Optional.empty();
        public boolean includeClientId = true;

        public Optional<String> getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = Optional.of(name);
        }

        public Optional<String> getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = Optional.of(secret);
        }

        public boolean isIncludeClientId() {
            return this.includeClientId;
        }

        public void setIncludeClientId(boolean includeClientId) {
            this.includeClientId = includeClientId;
        }

        private void addConfigMappingValues(OidcTenantConfig.IntrospectionCredentials mapping) {
            this.name = mapping.name();
            this.secret = mapping.secret();
            this.includeClientId = mapping.includeClientId();
        }
    }

    public static class Roles {
        public Optional<List<String>> roleClaimPath = Optional.empty();
        public Optional<String> roleClaimSeparator = Optional.empty();
        public Optional<Source> source = Optional.empty();

        public static Roles fromClaimPath(List<String> path) {
            return Roles.fromClaimPathAndSeparator(path, null);
        }

        public static Roles fromClaimPathAndSeparator(List<String> path, String sep) {
            Roles roles = new Roles();
            roles.roleClaimPath = Optional.ofNullable(path);
            roles.roleClaimSeparator = Optional.ofNullable(sep);
            return roles;
        }

        public Optional<List<String>> getRoleClaimPath() {
            return this.roleClaimPath;
        }

        public void setRoleClaimPath(List<String> roleClaimPath) {
            this.roleClaimPath = Optional.of(roleClaimPath);
        }

        public Optional<String> getRoleClaimSeparator() {
            return this.roleClaimSeparator;
        }

        public void setRoleClaimSeparator(String roleClaimSeparator) {
            this.roleClaimSeparator = Optional.of(roleClaimSeparator);
        }

        public Optional<Source> getSource() {
            return this.source;
        }

        public void setSource(Source source) {
            this.source = Optional.of(source);
        }

        private void addConfigMappingValues(OidcTenantConfig.Roles mapping) {
            this.roleClaimPath = mapping.roleClaimPath();
            this.roleClaimSeparator = mapping.roleClaimSeparator();
            this.source = mapping.source().map(Enum::toString).map(Source::valueOf);
        }

        public static enum Source {
            idtoken,
            accesstoken,
            userinfo;

        }
    }

    public static class Token {
        public Optional<String> issuer = Optional.empty();
        public Optional<List<String>> audience = Optional.empty();
        public boolean subjectRequired = false;
        public Map<String, String> requiredClaims = new HashMap<String, String>();
        public Optional<String> tokenType = Optional.empty();
        public OptionalInt lifespanGrace = OptionalInt.empty();
        public Optional<Duration> age = Optional.empty();
        public boolean issuedAtRequired = true;
        public Optional<String> principalClaim = Optional.empty();
        public boolean refreshExpired;
        public Optional<Duration> refreshTokenTimeSkew = Optional.empty();
        public Duration forcedJwkRefreshInterval = Duration.ofMinutes(10L);
        public Optional<String> header = Optional.empty();
        public String authorizationScheme = "Bearer";
        public Optional<SignatureAlgorithm> signatureAlgorithm = Optional.empty();
        public Optional<String> decryptionKeyLocation = Optional.empty();
        public boolean allowJwtIntrospection = true;
        public boolean requireJwtIntrospectionOnly = false;
        public boolean allowOpaqueTokenIntrospection = true;
        public Optional<String> customizerName = Optional.empty();
        public Optional<Boolean> verifyAccessTokenWithUserInfo = Optional.empty();

        public static Token fromIssuer(String issuer) {
            Token tokenClaims = new Token();
            tokenClaims.issuer = Optional.of(issuer);
            tokenClaims.audience = Optional.ofNullable(null);
            return tokenClaims;
        }

        public static Token fromAudience(String ... audience) {
            Token tokenClaims = new Token();
            tokenClaims.issuer = Optional.ofNullable(null);
            tokenClaims.audience = Optional.of(Arrays.asList(audience));
            return tokenClaims;
        }

        public Optional<Boolean> isVerifyAccessTokenWithUserInfo() {
            return this.verifyAccessTokenWithUserInfo;
        }

        public void setVerifyAccessTokenWithUserInfo(boolean verify) {
            this.verifyAccessTokenWithUserInfo = Optional.of(verify);
        }

        public Optional<String> getIssuer() {
            return this.issuer;
        }

        public void setIssuer(String issuer) {
            this.issuer = Optional.of(issuer);
        }

        public Optional<String> getHeader() {
            return this.header;
        }

        public void setHeader(String header) {
            this.header = Optional.of(header);
        }

        public Optional<List<String>> getAudience() {
            return this.audience;
        }

        public void setAudience(List<String> audience) {
            this.audience = Optional.of(audience);
        }

        public OptionalInt getLifespanGrace() {
            return this.lifespanGrace;
        }

        public void setLifespanGrace(int lifespanGrace) {
            this.lifespanGrace = OptionalInt.of(lifespanGrace);
        }

        public Optional<String> getPrincipalClaim() {
            return this.principalClaim;
        }

        public void setPrincipalClaim(String principalClaim) {
            this.principalClaim = Optional.of(principalClaim);
        }

        public boolean isRefreshExpired() {
            return this.refreshExpired;
        }

        public void setRefreshExpired(boolean refreshExpired) {
            this.refreshExpired = refreshExpired;
        }

        public Duration getForcedJwkRefreshInterval() {
            return this.forcedJwkRefreshInterval;
        }

        public void setForcedJwkRefreshInterval(Duration forcedJwkRefreshInterval) {
            this.forcedJwkRefreshInterval = forcedJwkRefreshInterval;
        }

        public Optional<String> getTokenType() {
            return this.tokenType;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = Optional.of(tokenType);
        }

        public Optional<Duration> getRefreshTokenTimeSkew() {
            return this.refreshTokenTimeSkew;
        }

        public void setRefreshTokenTimeSkew(Duration refreshTokenTimeSkew) {
            this.refreshTokenTimeSkew = Optional.of(refreshTokenTimeSkew);
        }

        public boolean isAllowJwtIntrospection() {
            return this.allowJwtIntrospection;
        }

        public void setAllowJwtIntrospection(boolean allowJwtIntrospection) {
            this.allowJwtIntrospection = allowJwtIntrospection;
        }

        public boolean isAllowOpaqueTokenIntrospection() {
            return this.allowOpaqueTokenIntrospection;
        }

        public void setAllowOpaqueTokenIntrospection(boolean allowOpaqueTokenIntrospection) {
            this.allowOpaqueTokenIntrospection = allowOpaqueTokenIntrospection;
        }

        public Optional<Duration> getAge() {
            return this.age;
        }

        public void setAge(Duration age) {
            this.age = Optional.of(age);
        }

        public boolean isIssuedAtRequired() {
            return this.issuedAtRequired;
        }

        public void setIssuedAtRequired(boolean issuedAtRequired) {
            this.issuedAtRequired = issuedAtRequired;
        }

        public Optional<String> getDecryptionKeyLocation() {
            return this.decryptionKeyLocation;
        }

        public void setDecryptionKeyLocation(String decryptionKeyLocation) {
            this.decryptionKeyLocation = Optional.of(decryptionKeyLocation);
        }

        public Map<String, String> getRequiredClaims() {
            return this.requiredClaims;
        }

        public void setRequiredClaims(Map<String, String> requiredClaims) {
            this.requiredClaims = requiredClaims;
        }

        public boolean isRequireJwtIntrospectionOnly() {
            return this.requireJwtIntrospectionOnly;
        }

        public void setRequireJwtIntrospectionOnly(boolean requireJwtIntrospectionOnly) {
            this.requireJwtIntrospectionOnly = requireJwtIntrospectionOnly;
        }

        public Optional<SignatureAlgorithm> getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            this.signatureAlgorithm = Optional.of(signatureAlgorithm);
        }

        public Optional<String> getCustomizerName() {
            return this.customizerName;
        }

        public void setCustomizerName(String customizerName) {
            this.customizerName = Optional.of(customizerName);
        }

        public boolean isSubjectRequired() {
            return this.subjectRequired;
        }

        public void setSubjectRequired(boolean subjectRequired) {
            this.subjectRequired = subjectRequired;
        }

        public String getAuthorizationScheme() {
            return this.authorizationScheme;
        }

        public void setAuthorizationScheme(String authorizationScheme) {
            this.authorizationScheme = authorizationScheme;
        }

        private void addConfigMappingValues(OidcTenantConfig.Token mapping) {
            this.issuer = mapping.issuer();
            this.audience = mapping.audience();
            this.subjectRequired = mapping.subjectRequired();
            this.requiredClaims = mapping.requiredClaims();
            this.tokenType = mapping.tokenType();
            this.lifespanGrace = mapping.lifespanGrace();
            this.age = mapping.age();
            this.issuedAtRequired = mapping.issuedAtRequired();
            this.principalClaim = mapping.principalClaim();
            this.refreshExpired = mapping.refreshExpired();
            this.refreshTokenTimeSkew = mapping.refreshTokenTimeSkew();
            this.forcedJwkRefreshInterval = mapping.forcedJwkRefreshInterval();
            this.header = mapping.header();
            this.authorizationScheme = mapping.authorizationScheme();
            this.signatureAlgorithm = mapping.signatureAlgorithm().map(Enum::toString).map(SignatureAlgorithm::valueOf);
            this.decryptionKeyLocation = mapping.decryptionKeyLocation();
            this.allowJwtIntrospection = mapping.allowJwtIntrospection();
            this.requireJwtIntrospectionOnly = mapping.requireJwtIntrospectionOnly();
            this.allowOpaqueTokenIntrospection = mapping.allowOpaqueTokenIntrospection();
            this.customizerName = mapping.customizerName();
            this.verifyAccessTokenWithUserInfo = mapping.verifyAccessTokenWithUserInfo();
        }
    }

    public static class Logout {
        public Optional<String> path = Optional.empty();
        public Optional<String> postLogoutPath = Optional.empty();
        public String postLogoutUriParam;
        public Map<String, String> extraParams;
        public Backchannel backchannel = new Backchannel();
        public Frontchannel frontchannel = new Frontchannel();

        public void setPath(Optional<String> path) {
            this.path = path;
        }

        public Optional<String> getPath() {
            return this.path;
        }

        public void setPostLogoutPath(Optional<String> postLogoutPath) {
            this.postLogoutPath = postLogoutPath;
        }

        public Optional<String> getPostLogoutPath() {
            return this.postLogoutPath;
        }

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public String getPostLogoutUriParam() {
            return this.postLogoutUriParam;
        }

        public void setPostLogoutUriParam(String postLogoutUriParam) {
            this.postLogoutUriParam = postLogoutUriParam;
        }

        public Backchannel getBackchannel() {
            return this.backchannel;
        }

        public void setBackchannel(Backchannel backchannel) {
            this.backchannel = backchannel;
        }

        public Frontchannel getFrontchannel() {
            return this.frontchannel;
        }

        public void setFrontchannel(Frontchannel frontchannel) {
            this.frontchannel = frontchannel;
        }

        private void addConfigMappingValues(OidcTenantConfig.Logout mapping) {
            this.path = mapping.path();
            this.postLogoutPath = mapping.postLogoutPath();
            this.postLogoutUriParam = mapping.postLogoutUriParam();
            this.extraParams = mapping.extraParams();
            this.backchannel.addConfigMappingValues(mapping.backchannel());
            this.frontchannel.addConfigMappingValues(mapping.frontchannel());
        }
    }

    public static class CertificateChain {
        public Optional<String> leafCertificateName = Optional.empty();
        public Optional<Path> trustStoreFile = Optional.empty();
        public Optional<String> trustStorePassword = Optional.empty();
        public Optional<String> trustStoreCertAlias = Optional.empty();
        public Optional<String> trustStoreFileType = Optional.empty();

        public Optional<Path> getTrustStoreFile() {
            return this.trustStoreFile;
        }

        public void setTrustStoreFile(Path trustStoreFile) {
            this.trustStoreFile = Optional.of(trustStoreFile);
        }

        public Optional<String> getTrustStoreCertAlias() {
            return this.trustStoreCertAlias;
        }

        public void setTrustStoreCertAlias(String trustStoreCertAlias) {
            this.trustStoreCertAlias = Optional.of(trustStoreCertAlias);
        }

        public Optional<String> getTrustStoreFileType() {
            return this.trustStoreFileType;
        }

        public void setTrustStoreFileType(Optional<String> trustStoreFileType) {
            this.trustStoreFileType = trustStoreFileType;
        }

        public Optional<String> getLeafCertificateName() {
            return this.leafCertificateName;
        }

        public void setLeafCertificateName(String leafCertificateName) {
            this.leafCertificateName = Optional.of(leafCertificateName);
        }

        public Optional<String> getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = Optional.ofNullable(trustStorePassword);
        }

        private void addConfigMappingValues(OidcTenantConfig.CertificateChain mapping) {
            this.leafCertificateName = mapping.leafCertificateName();
            this.trustStoreFile = mapping.trustStoreFile();
            this.trustStorePassword = mapping.trustStorePassword();
            this.trustStoreCertAlias = mapping.trustStoreCertAlias();
            this.trustStoreFileType = mapping.trustStoreFileType();
        }
    }

    public static class Authentication {
        public Optional<ResponseMode> responseMode = Optional.empty();
        public Optional<String> redirectPath = Optional.empty();
        public boolean restorePathAfterRedirect;
        public boolean removeRedirectParameters = true;
        public Optional<String> errorPath = Optional.empty();
        public Optional<String> sessionExpiredPath = Optional.empty();
        public boolean verifyAccessToken;
        public Optional<Boolean> forceRedirectHttpsScheme = Optional.empty();
        public Optional<List<String>> scopes = Optional.empty();
        public Optional<String> scopeSeparator = Optional.empty();
        public boolean nonceRequired = false;
        public Optional<Boolean> addOpenidScope = Optional.empty();
        public Map<String, String> extraParams = new HashMap<String, String>();
        public Optional<List<String>> forwardParams = Optional.empty();
        public boolean cookieForceSecure;
        public Optional<String> cookieSuffix = Optional.empty();
        public String cookiePath = "/";
        public Optional<String> cookiePathHeader = Optional.empty();
        public Optional<String> cookieDomain = Optional.empty();
        public CookieSameSite cookieSameSite = CookieSameSite.LAX;
        public boolean allowMultipleCodeFlows = true;
        public boolean failOnMissingStateParam = false;
        public Optional<Boolean> userInfoRequired = Optional.empty();
        public Duration sessionAgeExtension = Duration.ofMinutes(5L);
        public Duration stateCookieAge = Duration.ofMinutes(5L);
        public boolean javaScriptAutoRedirect = true;
        public Optional<Boolean> idTokenRequired = Optional.empty();
        public Optional<Duration> internalIdTokenLifespan = Optional.empty();
        public Optional<Boolean> pkceRequired = Optional.empty();
        public Optional<String> pkceSecret = Optional.empty();
        public Optional<String> stateSecret = Optional.empty();

        public Optional<Duration> getInternalIdTokenLifespan() {
            return this.internalIdTokenLifespan;
        }

        public void setInternalIdTokenLifespan(Duration internalIdTokenLifespan) {
            this.internalIdTokenLifespan = Optional.of(internalIdTokenLifespan);
        }

        public Optional<Boolean> isPkceRequired() {
            return this.pkceRequired;
        }

        public void setPkceRequired(boolean pkceRequired) {
            this.pkceRequired = Optional.of(pkceRequired);
        }

        @Deprecated(forRemoval=true)
        public Optional<String> getPkceSecret() {
            return this.pkceSecret;
        }

        @Deprecated(forRemoval=true)
        public void setPkceSecret(String pkceSecret) {
            this.pkceSecret = Optional.of(pkceSecret);
        }

        public Optional<String> getErrorPath() {
            return this.errorPath;
        }

        public void setErrorPath(String errorPath) {
            this.errorPath = Optional.of(errorPath);
        }

        public boolean isJavaScriptAutoRedirect() {
            return this.javaScriptAutoRedirect;
        }

        public void setJavaScriptAutoredirect(boolean autoRedirect) {
            this.javaScriptAutoRedirect = autoRedirect;
        }

        public Optional<String> getRedirectPath() {
            return this.redirectPath;
        }

        public void setRedirectPath(String redirectPath) {
            this.redirectPath = Optional.of(redirectPath);
        }

        public Optional<List<String>> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = Optional.of(scopes);
        }

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public void setAddOpenidScope(boolean addOpenidScope) {
            this.addOpenidScope = Optional.of(addOpenidScope);
        }

        public Optional<Boolean> isAddOpenidScope() {
            return this.addOpenidScope;
        }

        public Optional<Boolean> isForceRedirectHttpsScheme() {
            return this.forceRedirectHttpsScheme;
        }

        public void setForceRedirectHttpsScheme(boolean forceRedirectHttpsScheme) {
            this.forceRedirectHttpsScheme = Optional.of(forceRedirectHttpsScheme);
        }

        public boolean isRestorePathAfterRedirect() {
            return this.restorePathAfterRedirect;
        }

        public void setRestorePathAfterRedirect(boolean restorePathAfterRedirect) {
            this.restorePathAfterRedirect = restorePathAfterRedirect;
        }

        public boolean isCookieForceSecure() {
            return this.cookieForceSecure;
        }

        public void setCookieForceSecure(boolean cookieForceSecure) {
            this.cookieForceSecure = cookieForceSecure;
        }

        public String getCookiePath() {
            return this.cookiePath;
        }

        public void setCookiePath(String cookiePath) {
            this.cookiePath = cookiePath;
        }

        public Optional<String> getCookieDomain() {
            return this.cookieDomain;
        }

        public void setCookieDomain(String cookieDomain) {
            this.cookieDomain = Optional.of(cookieDomain);
        }

        public Optional<Boolean> isUserInfoRequired() {
            return this.userInfoRequired;
        }

        public void setUserInfoRequired(boolean userInfoRequired) {
            this.userInfoRequired = Optional.of(userInfoRequired);
        }

        public boolean isRemoveRedirectParameters() {
            return this.removeRedirectParameters;
        }

        public void setRemoveRedirectParameters(boolean removeRedirectParameters) {
            this.removeRedirectParameters = removeRedirectParameters;
        }

        public boolean isVerifyAccessToken() {
            return this.verifyAccessToken;
        }

        public void setVerifyAccessToken(boolean verifyAccessToken) {
            this.verifyAccessToken = verifyAccessToken;
        }

        public Duration getSessionAgeExtension() {
            return this.sessionAgeExtension;
        }

        public void setSessionAgeExtension(Duration sessionAgeExtension) {
            this.sessionAgeExtension = sessionAgeExtension;
        }

        public Optional<String> getCookiePathHeader() {
            return this.cookiePathHeader;
        }

        public void setCookiePathHeader(String cookiePathHeader) {
            this.cookiePathHeader = Optional.of(cookiePathHeader);
        }

        public Optional<Boolean> isIdTokenRequired() {
            return this.idTokenRequired;
        }

        public void setIdTokenRequired(boolean idTokenRequired) {
            this.idTokenRequired = Optional.of(idTokenRequired);
        }

        public Optional<String> getCookieSuffix() {
            return this.cookieSuffix;
        }

        public void setCookieSuffix(String cookieSuffix) {
            this.cookieSuffix = Optional.of(cookieSuffix);
        }

        public Optional<ResponseMode> getResponseMode() {
            return this.responseMode;
        }

        public void setResponseMode(ResponseMode responseMode) {
            this.responseMode = Optional.of(responseMode);
        }

        public Optional<List<String>> getForwardParams() {
            return this.forwardParams;
        }

        public void setForwardParams(List<String> forwardParams) {
            this.forwardParams = Optional.of(forwardParams);
        }

        public CookieSameSite getCookieSameSite() {
            return this.cookieSameSite;
        }

        public void setCookieSameSite(CookieSameSite cookieSameSite) {
            this.cookieSameSite = cookieSameSite;
        }

        public boolean isAllowMultipleCodeFlows() {
            return this.allowMultipleCodeFlows;
        }

        public void setAllowMultipleCodeFlows(boolean allowMultipleCodeFlows) {
            this.allowMultipleCodeFlows = allowMultipleCodeFlows;
        }

        public boolean isNonceRequired() {
            return this.nonceRequired;
        }

        public void setNonceRequired(boolean nonceRequired) {
            this.nonceRequired = nonceRequired;
        }

        public Optional<String> getStateSecret() {
            return this.stateSecret;
        }

        public void setStateSecret(Optional<String> stateSecret) {
            this.stateSecret = stateSecret;
        }

        public Optional<String> getScopeSeparator() {
            return this.scopeSeparator;
        }

        public void setScopeSeparator(String scopeSeparator) {
            this.scopeSeparator = Optional.of(scopeSeparator);
        }

        public Duration getStateCookieAge() {
            return this.stateCookieAge;
        }

        public void setStateCookieAge(Duration stateCookieAge) {
            this.stateCookieAge = stateCookieAge;
        }

        public Optional<String> getSessionExpiredPath() {
            return this.sessionExpiredPath;
        }

        public void setSessionExpiredPath(String sessionExpiredPath) {
            this.sessionExpiredPath = Optional.of(sessionExpiredPath);
        }

        private void addConfigMappingValues(OidcTenantConfig.Authentication mapping) {
            this.responseMode = mapping.responseMode().map(Enum::toString).map(ResponseMode::valueOf);
            this.redirectPath = mapping.redirectPath();
            this.restorePathAfterRedirect = mapping.restorePathAfterRedirect();
            this.removeRedirectParameters = mapping.removeRedirectParameters();
            this.errorPath = mapping.errorPath();
            this.sessionExpiredPath = mapping.sessionExpiredPath();
            this.verifyAccessToken = mapping.verifyAccessToken();
            this.forceRedirectHttpsScheme = mapping.forceRedirectHttpsScheme();
            this.scopes = mapping.scopes();
            this.scopeSeparator = mapping.scopeSeparator();
            this.nonceRequired = mapping.nonceRequired();
            this.addOpenidScope = mapping.addOpenidScope();
            this.extraParams = mapping.extraParams();
            this.forwardParams = mapping.forwardParams();
            this.cookieForceSecure = mapping.cookieForceSecure();
            this.cookieSuffix = mapping.cookieSuffix();
            this.cookiePath = mapping.cookiePath();
            this.cookiePathHeader = mapping.cookiePathHeader();
            this.cookieDomain = mapping.cookieDomain();
            this.cookieSameSite = CookieSameSite.valueOf(mapping.cookieSameSite().toString());
            this.allowMultipleCodeFlows = mapping.allowMultipleCodeFlows();
            this.failOnMissingStateParam = mapping.failOnMissingStateParam();
            this.userInfoRequired = mapping.userInfoRequired();
            this.sessionAgeExtension = mapping.sessionAgeExtension();
            this.stateCookieAge = mapping.stateCookieAge();
            this.javaScriptAutoRedirect = mapping.javaScriptAutoRedirect();
            this.idTokenRequired = mapping.idTokenRequired();
            this.internalIdTokenLifespan = mapping.internalIdTokenLifespan();
            this.pkceRequired = mapping.pkceRequired();
            this.pkceSecret = mapping.pkceSecret();
            this.stateSecret = mapping.stateSecret();
        }

        public static enum CookieSameSite {
            STRICT,
            LAX,
            NONE;

        }

        public static enum ResponseMode {
            QUERY,
            FORM_POST;

        }
    }

    public static class CodeGrant {
        public Map<String, String> extraParams = new HashMap<String, String>();
        public Map<String, String> headers = new HashMap<String, String>();

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        private void addConfigMappingValues(OidcTenantConfig.CodeGrant mapping) {
            this.extraParams = mapping.extraParams();
            this.headers = mapping.headers();
        }
    }

    public static class TokenStateManager {
        public Strategy strategy = Strategy.KEEP_ALL_TOKENS;
        public boolean splitTokens;
        public boolean encryptionRequired = true;
        public Optional<String> encryptionSecret = Optional.empty();
        public EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.A256GCMKW;

        public boolean isEncryptionRequired() {
            return this.encryptionRequired;
        }

        public void setEncryptionRequired(boolean encryptionRequired) {
            this.encryptionRequired = encryptionRequired;
        }

        public Optional<String> getEncryptionSecret() {
            return this.encryptionSecret;
        }

        public void setEncryptionSecret(String encryptionSecret) {
            this.encryptionSecret = Optional.of(encryptionSecret);
        }

        public boolean isSplitTokens() {
            return this.splitTokens;
        }

        public void setSplitTokens(boolean splitTokens) {
            this.splitTokens = splitTokens;
        }

        public Strategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(Strategy strategy) {
            this.strategy = strategy;
        }

        public EncryptionAlgorithm getEncryptionAlgorithm() {
            return this.encryptionAlgorithm;
        }

        public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
        }

        private void addConfigMappingValues(OidcTenantConfig.TokenStateManager mapping) {
            this.strategy = Strategy.valueOf(mapping.strategy().toString());
            this.splitTokens = mapping.splitTokens();
            this.encryptionRequired = mapping.encryptionRequired();
            this.encryptionSecret = mapping.encryptionSecret();
            this.encryptionAlgorithm = EncryptionAlgorithm.valueOf(mapping.encryptionAlgorithm().toString());
        }

        public static enum Strategy {
            KEEP_ALL_TOKENS,
            ID_TOKEN,
            ID_REFRESH_TOKENS;

        }

        public static enum EncryptionAlgorithm {
            A256GCMKW,
            DIR;

        }
    }

    public static class Jwks {
        public boolean resolveEarly = true;
        public int cacheSize = 10;
        public Duration cacheTimeToLive = Duration.ofMinutes(10L);
        public Optional<Duration> cleanUpTimerInterval = Optional.empty();
        public boolean tryAll = false;

        public int getCacheSize() {
            return this.cacheSize;
        }

        public void setCacheSize(int cacheSize) {
            this.cacheSize = cacheSize;
        }

        public Duration getCacheTimeToLive() {
            return this.cacheTimeToLive;
        }

        public void setCacheTimeToLive(Duration cacheTimeToLive) {
            this.cacheTimeToLive = cacheTimeToLive;
        }

        public Optional<Duration> getCleanUpTimerInterval() {
            return this.cleanUpTimerInterval;
        }

        public void setCleanUpTimerInterval(Duration cleanUpTimerInterval) {
            this.cleanUpTimerInterval = Optional.of(cleanUpTimerInterval);
        }

        public boolean isResolveEarly() {
            return this.resolveEarly;
        }

        public void setResolveEarly(boolean resolveEarly) {
            this.resolveEarly = resolveEarly;
        }

        public boolean isTryAll() {
            return this.tryAll;
        }

        public void setTryAll(boolean fallbackToTryAll) {
            this.tryAll = fallbackToTryAll;
        }

        private void addConfigMappingValues(OidcTenantConfig.Jwks mapping) {
            this.resolveEarly = mapping.resolveEarly();
            this.cacheSize = mapping.cacheSize();
            this.cacheTimeToLive = mapping.cacheTimeToLive();
            this.cleanUpTimerInterval = mapping.cleanUpTimerInterval();
            this.tryAll = mapping.tryAll();
        }
    }

    public static enum Provider {
        APPLE,
        DISCORD,
        FACEBOOK,
        GITHUB,
        GOOGLE,
        LINKEDIN,
        MASTODON,
        MICROSOFT,
        SLACK,
        SPOTIFY,
        STRAVA,
        TWITCH,
        TWITTER,
        X;

    }

    public static enum ApplicationType {
        WEB_APP,
        SERVICE,
        HYBRID;

    }

    public static enum SignatureAlgorithm {
        RS256,
        RS384,
        RS512,
        PS256,
        PS384,
        PS512,
        ES256,
        ES384,
        ES512,
        EDDSA;

        private static String EDDSA_ALG;
        private static String REQUIRED_EDDSA_ALG;

        public String getAlgorithm() {
            String name = this.name();
            return EDDSA_ALG.equals(name) ? REQUIRED_EDDSA_ALG : name;
        }

        static {
            EDDSA_ALG = "EDDSA";
            REQUIRED_EDDSA_ALG = "EdDSA";
        }
    }

    public static class Frontchannel {
        public Optional<String> path = Optional.empty();

        public void setPath(Optional<String> path) {
            this.path = path;
        }

        public Optional<String> getPath() {
            return this.path;
        }

        private void addConfigMappingValues(OidcTenantConfig.Frontchannel mapping) {
            this.path = mapping.path();
        }
    }

    public static class Backchannel {
        public Optional<String> path = Optional.empty();
        public int tokenCacheSize = 10;
        public Duration tokenCacheTimeToLive = Duration.ofMinutes(10L);
        public Optional<Duration> cleanUpTimerInterval = Optional.empty();
        public String logoutTokenKey = "sub";

        public void setPath(Optional<String> path) {
            this.path = path;
        }

        public Optional<String> getPath() {
            return this.path;
        }

        public String getLogoutTokenKey() {
            return this.logoutTokenKey;
        }

        public void setLogoutTokenKey(String logoutTokenKey) {
            this.logoutTokenKey = logoutTokenKey;
        }

        public int getTokenCacheSize() {
            return this.tokenCacheSize;
        }

        public void setTokenCacheSize(int tokenCacheSize) {
            this.tokenCacheSize = tokenCacheSize;
        }

        public Duration getTokenCacheTimeToLive() {
            return this.tokenCacheTimeToLive;
        }

        public void setTokenCacheTimeToLive(Duration tokenCacheTimeToLive) {
            this.tokenCacheTimeToLive = tokenCacheTimeToLive;
        }

        public Optional<Duration> getCleanUpTimerInterval() {
            return this.cleanUpTimerInterval;
        }

        public void setCleanUpTimerInterval(Duration cleanUpTimerInterval) {
            this.cleanUpTimerInterval = Optional.of(cleanUpTimerInterval);
        }

        private void addConfigMappingValues(OidcTenantConfig.Backchannel mapping) {
            this.path = mapping.path();
            this.tokenCacheSize = mapping.tokenCacheSize();
            this.tokenCacheTimeToLive = mapping.tokenCacheTimeToLive();
            this.cleanUpTimerInterval = mapping.cleanUpTimerInterval();
            this.logoutTokenKey = mapping.logoutTokenKey();
        }
    }
}

