/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.BearerAuthenticationMechanism;
import io.quarkus.oidc.runtime.CodeAuthenticationMechanism;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;

@ApplicationScoped
public class OidcAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static HttpCredentialTransport OIDC_SERVICE_TRANSPORT = new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, "Bearer");
    private static HttpCredentialTransport OIDC_WEB_APP_TRANSPORT = new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION_CODE, "code");
    private final BearerAuthenticationMechanism bearerAuth = new BearerAuthenticationMechanism();
    private final CodeAuthenticationMechanism codeAuth = new CodeAuthenticationMechanism();
    private final DefaultTenantConfigResolver resolver;

    public OidcAuthenticationMechanism(DefaultTenantConfigResolver resolver) {
        this.resolver = resolver;
        this.bearerAuth.init(this, resolver);
        this.codeAuth.init(this, resolver);
    }

    public Uni<SecurityIdentity> authenticate(final RoutingContext context, final IdentityProviderManager identityProviderManager) {
        OidcAuthenticationMechanism.setTenantIdAttribute(context);
        return this.resolve(context).chain((Function)new Function<OidcTenantConfig, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<? extends SecurityIdentity> apply(OidcTenantConfig oidcConfig) {
                if (!oidcConfig.tenantEnabled) {
                    return Uni.createFrom().nullItem();
                }
                return OidcAuthenticationMechanism.this.isWebApp(context, oidcConfig) ? OidcAuthenticationMechanism.this.codeAuth.authenticate(context, identityProviderManager, oidcConfig) : OidcAuthenticationMechanism.this.bearerAuth.authenticate(context, identityProviderManager, oidcConfig);
            }
        });
    }

    public Uni<ChallengeData> getChallenge(final RoutingContext context) {
        OidcAuthenticationMechanism.setTenantIdAttribute(context);
        return this.resolve(context).chain((Function)new Function<OidcTenantConfig, Uni<? extends ChallengeData>>(){

            @Override
            public Uni<? extends ChallengeData> apply(OidcTenantConfig oidcTenantConfig) {
                if (!oidcTenantConfig.tenantEnabled) {
                    return Uni.createFrom().nullItem();
                }
                return OidcAuthenticationMechanism.this.isWebApp(context, oidcTenantConfig) ? OidcAuthenticationMechanism.this.codeAuth.getChallenge(context) : OidcAuthenticationMechanism.this.bearerAuth.getChallenge(context);
            }
        });
    }

    private Uni<OidcTenantConfig> resolve(RoutingContext context) {
        return this.resolver.resolveConfig(context).map((Function)new Function<OidcTenantConfig, OidcTenantConfig>(){

            @Override
            public OidcTenantConfig apply(OidcTenantConfig oidcTenantConfig) {
                if (oidcTenantConfig == null) {
                    throw new OIDCException("Tenant configuration has not been resolved");
                }
                return oidcTenantConfig;
            }
        });
    }

    private boolean isWebApp(RoutingContext context, OidcTenantConfig oidcConfig) {
        OidcTenantConfig.ApplicationType applicationType = oidcConfig.applicationType.orElse(OidcTenantConfig.ApplicationType.SERVICE);
        if (OidcTenantConfig.ApplicationType.HYBRID == applicationType) {
            return context.request().getHeader("Authorization") == null;
        }
        return OidcTenantConfig.ApplicationType.WEB_APP == applicationType;
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    public Uni<HttpCredentialTransport> getCredentialTransport(final RoutingContext context) {
        OidcAuthenticationMechanism.setTenantIdAttribute(context);
        return this.resolve(context).onItem().transform((Function)new Function<OidcTenantConfig, HttpCredentialTransport>(){

            @Override
            public HttpCredentialTransport apply(OidcTenantConfig oidcTenantConfig) {
                if (!oidcTenantConfig.tenantEnabled) {
                    return null;
                }
                return OidcAuthenticationMechanism.this.isWebApp(context, oidcTenantConfig) ? OIDC_WEB_APP_TRANSPORT : OIDC_SERVICE_TRANSPORT;
            }
        });
    }

    private static void setTenantIdAttribute(RoutingContext context) {
        for (String cookieName : context.cookieMap().keySet()) {
            if (cookieName.startsWith("q_session")) {
                OidcAuthenticationMechanism.setTenantIdAttribute(context, "q_session", cookieName);
                continue;
            }
            if (!cookieName.startsWith("q_auth")) continue;
            OidcAuthenticationMechanism.setTenantIdAttribute(context, "q_auth", cookieName);
        }
    }

    private static void setTenantIdAttribute(RoutingContext context, String cookiePrefix, String cookieName) {
        if (cookieName.length() == cookiePrefix.length()) {
            context.put("tenant-id", (Object)"Default");
        } else {
            String suffix = cookieName.substring(cookiePrefix.length() + 1);
            int index = suffix.indexOf("_");
            String tenantId = index == -1 ? suffix : suffix.substring(0, index);
            context.put("tenant-id", (Object)tenantId);
        }
    }

    public int getPriority() {
        return 1001;
    }
}

