/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.InvalidAlgorithmException;
import org.jose4j.lang.JoseException;

public class JsonWebKeySet {
    private static final Logger LOG = Logger.getLogger(JsonWebKeySet.class);
    private static final String RSA_KEY_TYPE = "RSA";
    private static final String ELLIPTIC_CURVE_KEY_TYPE = "EC";
    private static final String OCTET_KEY_PAIR_TYPE = "OKP";
    private static final Set<String> KEY_TYPES = Set.of("RSA", "EC", "OKP");
    private static final String SIGNATURE_USE = "sig";
    private Map<String, Key> keysWithKeyId = new HashMap<String, Key>();
    private Map<String, Key> keysWithThumbprints = new HashMap<String, Key>();
    private Map<String, Key> keysWithS256Thumbprints = new HashMap<String, Key>();
    private Map<String, List<Key>> keysWithoutKeyIdAndThumbprint = new HashMap<String, List<Key>>();
    private Map<String, List<Key>> allKeys = new HashMap<String, List<Key>>();

    public JsonWebKeySet(String json) {
        this.initKeys(json);
    }

    private void initKeys(String json) {
        try {
            org.jose4j.jwk.JsonWebKeySet jwkSet = new org.jose4j.jwk.JsonWebKeySet(json);
            for (JsonWebKey jwkKey : jwkSet.getJsonWebKeys()) {
                String x5tS256;
                boolean calculateThumbprintIfMissing;
                String x5t;
                if (!JsonWebKeySet.isSupportedJwkKey(jwkKey)) continue;
                this.addKeyToListInMap(jwkKey, this.allKeys);
                if (jwkKey.getKeyId() != null) {
                    this.keysWithKeyId.put(jwkKey.getKeyId(), jwkKey.getKey());
                }
                if ((x5t = ((PublicJsonWebKey)jwkKey).getX509CertificateSha1Thumbprint(calculateThumbprintIfMissing = true)) != null && jwkKey.getKey() != null) {
                    this.keysWithThumbprints.put(x5t, jwkKey.getKey());
                }
                if ((x5tS256 = ((PublicJsonWebKey)jwkKey).getX509CertificateSha256Thumbprint(calculateThumbprintIfMissing)) != null && jwkKey.getKey() != null) {
                    this.keysWithS256Thumbprints.put(x5tS256, jwkKey.getKey());
                }
                if (jwkKey.getKeyId() != null || x5t != null || x5tS256 != null || jwkKey.getKeyType() == null) continue;
                this.addKeyToListInMap(jwkKey, this.keysWithoutKeyIdAndThumbprint);
            }
        }
        catch (JoseException ex) {
            throw new OIDCException(ex);
        }
    }

    private static boolean isSupportedJwkKey(JsonWebKey jwkKey) {
        return !(jwkKey.getKeyType() != null && !KEY_TYPES.contains(jwkKey.getKeyType()) || !SIGNATURE_USE.equals(jwkKey.getUse()) && jwkKey.getUse() != null);
    }

    private void addKeyToListInMap(JsonWebKey key, Map<String, List<Key>> map) {
        List<Key> keys = map.get(key.getKeyType());
        if (keys == null) {
            keys = new ArrayList<Key>();
            map.put(key.getKeyType(), keys);
        }
        keys.add(key.getKey());
    }

    public Key findKeyInAllKeys(JsonWebSignature jws) {
        String keyType;
        LOG.debug((Object)"Evaluating all keys to find a matching one");
        Key initialKey = jws.getKey();
        try {
            keyType = jws.getKeyType();
        }
        catch (InvalidAlgorithmException e) {
            LOG.debug((Object)"No key type available, cannot determine keys to check", (Throwable)e);
            return null;
        }
        for (Key key : this.allKeys.getOrDefault(keyType, List.of())) {
            jws.setKey(key);
            try {
                if (!jws.verifySignature()) continue;
                jws.setKey(initialKey);
                LOG.debugf("Found matching key %s", (Object)key.toString());
                return key;
            }
            catch (JoseException e) {
                LOG.debugf((Throwable)e, "Verifying signature with key %s failed.", (Object)key.toString());
            }
        }
        jws.setKey(initialKey);
        LOG.debug((Object)"No matching key found");
        return null;
    }

    public Key getKeyWithId(String kid) {
        return this.keysWithKeyId.get(kid);
    }

    public Key getKeyWithThumbprint(String x5t) {
        return this.keysWithThumbprints.get(x5t);
    }

    public Key getKeyWithS256Thumbprint(String x5tS256) {
        return this.keysWithS256Thumbprints.get(x5tS256);
    }

    public Key getKeyWithoutKeyIdAndThumbprint(String keyType) {
        List<Key> keys = this.keysWithoutKeyIdAndThumbprint.get(keyType);
        return keys == null || keys.size() != 1 ? null : keys.get(0);
    }
}

