/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConvertWith;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigGroup
public class OidcTenantConfig
extends OidcCommonConfig {
    @ConfigItem
    public Optional<String> tenantId = Optional.empty();
    @ConfigItem(defaultValue="true")
    public boolean tenantEnabled = true;
    @ConfigItem(defaultValueDocumentation="service")
    public Optional<ApplicationType> applicationType = Optional.empty();
    @ConfigItem
    public Optional<String> authorizationPath = Optional.empty();
    @ConfigItem
    public Optional<String> userInfoPath = Optional.empty();
    @ConfigItem
    public Optional<String> introspectionPath = Optional.empty();
    @ConfigItem
    public Optional<String> jwksPath = Optional.empty();
    @ConfigItem
    public Optional<String> endSessionPath = Optional.empty();
    @ConfigItem
    public Optional<List<String>> tenantPaths = Optional.empty();
    @ConfigItem
    public Optional<String> publicKey = Optional.empty();
    @ConfigItem
    public IntrospectionCredentials introspectionCredentials = new IntrospectionCredentials();
    @ConfigItem
    public Roles roles = new Roles();
    @ConfigItem
    public Token token = new Token();
    @ConfigItem
    public Logout logout = new Logout();
    @ConfigItem
    public CertificateChain certificateChain = new CertificateChain();
    public Authentication authentication = new Authentication();
    public CodeGrant codeGrant = new CodeGrant();
    @ConfigItem
    public TokenStateManager tokenStateManager = new TokenStateManager();
    @ConfigItem(defaultValue="true")
    public boolean allowTokenIntrospectionCache = true;
    @ConfigItem(defaultValue="true")
    public boolean allowUserInfoCache = true;
    @ConfigItem(defaultValue="false")
    public boolean cacheUserInfoInIdtoken = false;
    @ConfigItem
    public Jwks jwks = new Jwks();
    @ConfigItem
    public Optional<Provider> provider = Optional.empty();

    public Optional<String> getAuthorizationPath() {
        return this.authorizationPath;
    }

    public void setAuthorizationPath(String authorizationPath) {
        this.authorizationPath = Optional.of(authorizationPath);
    }

    public Optional<String> getUserInfoPath() {
        return this.userInfoPath;
    }

    public void setUserInfoPath(String userInfoPath) {
        this.userInfoPath = Optional.of(userInfoPath);
    }

    public Optional<String> getIntrospectionPath() {
        return this.introspectionPath;
    }

    public void setIntrospectionPath(String introspectionPath) {
        this.introspectionPath = Optional.of(introspectionPath);
    }

    public Optional<String> getJwksPath() {
        return this.jwksPath;
    }

    public void setJwksPath(String jwksPath) {
        this.jwksPath = Optional.of(jwksPath);
    }

    public Optional<String> getEndSessionPath() {
        return this.endSessionPath;
    }

    public void setEndSessionPath(String endSessionPath) {
        this.endSessionPath = Optional.of(endSessionPath);
    }

    public Optional<String> getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = Optional.of(publicKey);
    }

    public Roles getRoles() {
        return this.roles;
    }

    public void setRoles(Roles roles) {
        this.roles = roles;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public Optional<String> getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = Optional.of(tenantId);
    }

    public boolean isTenantEnabled() {
        return this.tenantEnabled;
    }

    public void setTenantEnabled(boolean enabled) {
        this.tenantEnabled = enabled;
    }

    public void setLogout(Logout logout) {
        this.logout = logout;
    }

    public Logout getLogout() {
        return this.logout;
    }

    public Optional<Provider> getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = Optional.of(provider);
    }

    public Optional<ApplicationType> getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType type) {
        this.applicationType = Optional.of(type);
    }

    public boolean isAllowTokenIntrospectionCache() {
        return this.allowTokenIntrospectionCache;
    }

    public void setAllowTokenIntrospectionCache(boolean allowTokenIntrospectionCache) {
        this.allowTokenIntrospectionCache = allowTokenIntrospectionCache;
    }

    public boolean isAllowUserInfoCache() {
        return this.allowUserInfoCache;
    }

    public void setAllowUserInfoCache(boolean allowUserInfoCache) {
        this.allowUserInfoCache = allowUserInfoCache;
    }

    public boolean isCacheUserInfoInIdtoken() {
        return this.cacheUserInfoInIdtoken;
    }

    public void setCacheUserInfoInIdtoken(boolean cacheUserInfoInIdtoken) {
        this.cacheUserInfoInIdtoken = cacheUserInfoInIdtoken;
    }

    public IntrospectionCredentials getIntrospectionCredentials() {
        return this.introspectionCredentials;
    }

    public void setIntrospectionCredentials(IntrospectionCredentials introspectionCredentials) {
        this.introspectionCredentials = introspectionCredentials;
    }

    public CodeGrant getCodeGrant() {
        return this.codeGrant;
    }

    public void setCodeGrant(CodeGrant codeGrant) {
        this.codeGrant = codeGrant;
    }

    public CertificateChain getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(CertificateChain certificateChain) {
        this.certificateChain = certificateChain;
    }

    @ConfigGroup
    public static class IntrospectionCredentials {
        @ConfigItem
        public Optional<String> name = Optional.empty();
        @ConfigItem
        public Optional<String> secret = Optional.empty();
        @ConfigItem(defaultValue="true")
        public boolean includeClientId = true;

        public Optional<String> getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = Optional.of(name);
        }

        public Optional<String> getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = Optional.of(secret);
        }

        public boolean isIncludeClientId() {
            return this.includeClientId;
        }

        public void setIncludeClientId(boolean includeClientId) {
            this.includeClientId = includeClientId;
        }
    }

    @ConfigGroup
    public static class Roles {
        @ConfigItem
        public Optional<List<String>> roleClaimPath = Optional.empty();
        @ConfigItem
        public Optional<String> roleClaimSeparator = Optional.empty();
        @ConfigItem
        public Optional<Source> source = Optional.empty();

        public static Roles fromClaimPath(List<String> path) {
            return Roles.fromClaimPathAndSeparator(path, null);
        }

        public static Roles fromClaimPathAndSeparator(List<String> path, String sep) {
            Roles roles = new Roles();
            roles.roleClaimPath = Optional.ofNullable(path);
            roles.roleClaimSeparator = Optional.ofNullable(sep);
            return roles;
        }

        public Optional<List<String>> getRoleClaimPath() {
            return this.roleClaimPath;
        }

        public void setRoleClaimPath(List<String> roleClaimPath) {
            this.roleClaimPath = Optional.of(roleClaimPath);
        }

        public Optional<String> getRoleClaimSeparator() {
            return this.roleClaimSeparator;
        }

        public void setRoleClaimSeparator(String roleClaimSeparator) {
            this.roleClaimSeparator = Optional.of(roleClaimSeparator);
        }

        public Optional<Source> getSource() {
            return this.source;
        }

        public void setSource(Source source) {
            this.source = Optional.of(source);
        }

        public static enum Source {
            idtoken,
            accesstoken,
            userinfo;

        }
    }

    @ConfigGroup
    public static class Token {
        @ConfigItem
        public Optional<String> issuer = Optional.empty();
        @ConfigItem
        public Optional<List<String>> audience = Optional.empty();
        @ConfigItem(defaultValue="false")
        public boolean subjectRequired = false;
        @ConfigItem
        public Map<String, String> requiredClaims = new HashMap<String, String>();
        @ConfigItem
        public Optional<String> tokenType = Optional.empty();
        @ConfigItem
        public OptionalInt lifespanGrace = OptionalInt.empty();
        @ConfigItem
        public Optional<Duration> age = Optional.empty();
        @ConfigItem(defaultValue="true")
        public boolean issuedAtRequired = true;
        @ConfigItem
        public Optional<String> principalClaim = Optional.empty();
        @ConfigItem
        public boolean refreshExpired;
        @ConfigItem
        public Optional<Duration> refreshTokenTimeSkew = Optional.empty();
        @ConfigItem(defaultValue="10M")
        public Duration forcedJwkRefreshInterval = Duration.ofMinutes(10L);
        @ConfigItem
        public Optional<String> header = Optional.empty();
        @ConfigItem(defaultValue="Bearer")
        public String authorizationScheme = "Bearer";
        @ConfigItem
        public Optional<SignatureAlgorithm> signatureAlgorithm = Optional.empty();
        @ConfigItem
        public Optional<String> decryptionKeyLocation = Optional.empty();
        @ConfigItem(defaultValue="true")
        public boolean allowJwtIntrospection = true;
        @ConfigItem(defaultValue="false")
        public boolean requireJwtIntrospectionOnly = false;
        @ConfigItem(defaultValue="true")
        public boolean allowOpaqueTokenIntrospection = true;
        @ConfigItem
        public Optional<String> customizerName = Optional.empty();
        @ConfigItem(defaultValueDocumentation="false")
        public Optional<Boolean> verifyAccessTokenWithUserInfo = Optional.empty();

        public static Token fromIssuer(String issuer) {
            Token tokenClaims = new Token();
            tokenClaims.issuer = Optional.of(issuer);
            tokenClaims.audience = Optional.ofNullable(null);
            return tokenClaims;
        }

        public static Token fromAudience(String ... audience) {
            Token tokenClaims = new Token();
            tokenClaims.issuer = Optional.ofNullable(null);
            tokenClaims.audience = Optional.of(Arrays.asList(audience));
            return tokenClaims;
        }

        public Optional<Boolean> isVerifyAccessTokenWithUserInfo() {
            return this.verifyAccessTokenWithUserInfo;
        }

        public void setVerifyAccessTokenWithUserInfo(boolean verify) {
            this.verifyAccessTokenWithUserInfo = Optional.of(verify);
        }

        public Optional<String> getIssuer() {
            return this.issuer;
        }

        public void setIssuer(String issuer) {
            this.issuer = Optional.of(issuer);
        }

        public Optional<String> getHeader() {
            return this.header;
        }

        public void setHeader(String header) {
            this.header = Optional.of(header);
        }

        public Optional<List<String>> getAudience() {
            return this.audience;
        }

        public void setAudience(List<String> audience) {
            this.audience = Optional.of(audience);
        }

        public OptionalInt getLifespanGrace() {
            return this.lifespanGrace;
        }

        public void setLifespanGrace(int lifespanGrace) {
            this.lifespanGrace = OptionalInt.of(lifespanGrace);
        }

        public Optional<String> getPrincipalClaim() {
            return this.principalClaim;
        }

        public void setPrincipalClaim(String principalClaim) {
            this.principalClaim = Optional.of(principalClaim);
        }

        public boolean isRefreshExpired() {
            return this.refreshExpired;
        }

        public void setRefreshExpired(boolean refreshExpired) {
            this.refreshExpired = refreshExpired;
        }

        public Duration getForcedJwkRefreshInterval() {
            return this.forcedJwkRefreshInterval;
        }

        public void setForcedJwkRefreshInterval(Duration forcedJwkRefreshInterval) {
            this.forcedJwkRefreshInterval = forcedJwkRefreshInterval;
        }

        public Optional<String> getTokenType() {
            return this.tokenType;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = Optional.of(tokenType);
        }

        public Optional<Duration> getRefreshTokenTimeSkew() {
            return this.refreshTokenTimeSkew;
        }

        public void setRefreshTokenTimeSkew(Duration refreshTokenTimeSkew) {
            this.refreshTokenTimeSkew = Optional.of(refreshTokenTimeSkew);
        }

        public boolean isAllowJwtIntrospection() {
            return this.allowJwtIntrospection;
        }

        public void setAllowJwtIntrospection(boolean allowJwtIntrospection) {
            this.allowJwtIntrospection = allowJwtIntrospection;
        }

        public boolean isAllowOpaqueTokenIntrospection() {
            return this.allowOpaqueTokenIntrospection;
        }

        public void setAllowOpaqueTokenIntrospection(boolean allowOpaqueTokenIntrospection) {
            this.allowOpaqueTokenIntrospection = allowOpaqueTokenIntrospection;
        }

        public Optional<Duration> getAge() {
            return this.age;
        }

        public void setAge(Duration age) {
            this.age = Optional.of(age);
        }

        public boolean isIssuedAtRequired() {
            return this.issuedAtRequired;
        }

        public void setIssuedAtRequired(boolean issuedAtRequired) {
            this.issuedAtRequired = issuedAtRequired;
        }

        public Optional<String> getDecryptionKeyLocation() {
            return this.decryptionKeyLocation;
        }

        public void setDecryptionKeyLocation(String decryptionKeyLocation) {
            this.decryptionKeyLocation = Optional.of(decryptionKeyLocation);
        }

        public Map<String, String> getRequiredClaims() {
            return this.requiredClaims;
        }

        public void setRequiredClaims(Map<String, String> requiredClaims) {
            this.requiredClaims = requiredClaims;
        }

        public boolean isRequireJwtIntrospectionOnly() {
            return this.requireJwtIntrospectionOnly;
        }

        public void setRequireJwtIntrospectionOnly(boolean requireJwtIntrospectionOnly) {
            this.requireJwtIntrospectionOnly = requireJwtIntrospectionOnly;
        }

        public Optional<SignatureAlgorithm> getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            this.signatureAlgorithm = Optional.of(signatureAlgorithm);
        }

        public Optional<String> getCustomizerName() {
            return this.customizerName;
        }

        public void setCustomizerName(String customizerName) {
            this.customizerName = Optional.of(customizerName);
        }

        public boolean isSubjectRequired() {
            return this.subjectRequired;
        }

        public void setSubjectRequired(boolean subjectRequired) {
            this.subjectRequired = subjectRequired;
        }

        public String getAuthorizationScheme() {
            return this.authorizationScheme;
        }

        public void setAuthorizationScheme(String authorizationScheme) {
            this.authorizationScheme = authorizationScheme;
        }
    }

    @ConfigGroup
    public static class Logout {
        @ConfigItem
        public Optional<String> path = Optional.empty();
        @ConfigItem
        public Optional<String> postLogoutPath = Optional.empty();
        @ConfigItem(defaultValue="post_logout_redirect_uri")
        public String postLogoutUriParam;
        @ConfigItem
        public Map<String, String> extraParams;
        @ConfigItem
        public Backchannel backchannel = new Backchannel();
        @ConfigItem
        public Frontchannel frontchannel = new Frontchannel();

        public void setPath(Optional<String> path) {
            this.path = path;
        }

        public Optional<String> getPath() {
            return this.path;
        }

        public void setPostLogoutPath(Optional<String> postLogoutPath) {
            this.postLogoutPath = postLogoutPath;
        }

        public Optional<String> getPostLogoutPath() {
            return this.postLogoutPath;
        }

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public String getPostLogoutUriParam() {
            return this.postLogoutUriParam;
        }

        public void setPostLogoutUriParam(String postLogoutUriParam) {
            this.postLogoutUriParam = postLogoutUriParam;
        }

        public Backchannel getBackchannel() {
            return this.backchannel;
        }

        public void setBackchannel(Backchannel backchannel) {
            this.backchannel = backchannel;
        }

        public Frontchannel getFrontchannel() {
            return this.frontchannel;
        }

        public void setFrontchannel(Frontchannel frontchannel) {
            this.frontchannel = frontchannel;
        }
    }

    @ConfigGroup
    public static class CertificateChain {
        @ConfigItem
        public Optional<String> leafCertificateName = Optional.empty();
        @ConfigItem
        public Optional<Path> trustStoreFile = Optional.empty();
        @ConfigItem
        public Optional<String> trustStorePassword = Optional.empty();
        @ConfigItem
        public Optional<String> trustStoreCertAlias = Optional.empty();
        @ConfigItem
        public Optional<String> trustStoreFileType = Optional.empty();

        public Optional<Path> getTrustStoreFile() {
            return this.trustStoreFile;
        }

        public void setTrustStoreFile(Path trustStoreFile) {
            this.trustStoreFile = Optional.of(trustStoreFile);
        }

        public Optional<String> getTrustStoreCertAlias() {
            return this.trustStoreCertAlias;
        }

        public void setTrustStoreCertAlias(String trustStoreCertAlias) {
            this.trustStoreCertAlias = Optional.of(trustStoreCertAlias);
        }

        public Optional<String> getTrustStoreFileType() {
            return this.trustStoreFileType;
        }

        public void setTrustStoreFileType(Optional<String> trustStoreFileType) {
            this.trustStoreFileType = trustStoreFileType;
        }

        public Optional<String> getLeafCertificateName() {
            return this.leafCertificateName;
        }

        public void setLeafCertificateName(String leafCertificateName) {
            this.leafCertificateName = Optional.of(leafCertificateName);
        }
    }

    @ConfigGroup
    public static class Authentication {
        @ConfigItem(defaultValueDocumentation="query")
        public Optional<ResponseMode> responseMode = Optional.empty();
        @ConfigItem
        public Optional<String> redirectPath = Optional.empty();
        @ConfigItem(defaultValue="false")
        public boolean restorePathAfterRedirect;
        @ConfigItem(defaultValue="true")
        public boolean removeRedirectParameters = true;
        @ConfigItem
        public Optional<String> errorPath = Optional.empty();
        @ConfigItem(defaultValueDocumentation="true when access token is injected as the JsonWebToken bean, false otherwise")
        public boolean verifyAccessToken;
        @ConfigItem(defaultValueDocumentation="false")
        public Optional<Boolean> forceRedirectHttpsScheme = Optional.empty();
        @ConfigItem
        public Optional<List<String>> scopes = Optional.empty();
        @ConfigItem
        public Optional<String> scopeSeparator = Optional.empty();
        @ConfigItem(defaultValue="false")
        public boolean nonceRequired = false;
        @ConfigItem(defaultValueDocumentation="true")
        public Optional<Boolean> addOpenidScope = Optional.empty();
        @ConfigItem
        public Map<String, String> extraParams = new HashMap<String, String>();
        @ConfigItem
        @ConvertWith(value=TrimmedStringConverter.class)
        public Optional<List<String>> forwardParams = Optional.empty();
        @ConfigItem(defaultValue="false")
        public boolean cookieForceSecure;
        @ConfigItem
        public Optional<String> cookieSuffix = Optional.empty();
        @ConfigItem(defaultValue="/")
        public String cookiePath = "/";
        @ConfigItem
        public Optional<String> cookiePathHeader = Optional.empty();
        @ConfigItem
        public Optional<String> cookieDomain = Optional.empty();
        @ConfigItem(defaultValue="lax")
        public CookieSameSite cookieSameSite = CookieSameSite.LAX;
        @ConfigItem(defaultValue="true")
        public boolean allowMultipleCodeFlows = true;
        @ConfigItem(defaultValue="false")
        public boolean failOnMissingStateParam = false;
        @ConfigItem(defaultValueDocumentation="true when UserInfo bean is injected, false otherwise")
        public Optional<Boolean> userInfoRequired = Optional.empty();
        @ConfigItem(defaultValue="5M")
        public Duration sessionAgeExtension = Duration.ofMinutes(5L);
        @ConfigItem(defaultValue="true")
        public boolean javaScriptAutoRedirect = true;
        @ConfigItem(defaultValueDocumentation="true")
        public Optional<Boolean> idTokenRequired = Optional.empty();
        @ConfigItem(defaultValueDocumentation="5M")
        public Optional<Duration> internalIdTokenLifespan = Optional.empty();
        @ConfigItem(defaultValueDocumentation="false")
        public Optional<Boolean> pkceRequired = Optional.empty();
        @ConfigItem
        @Deprecated(forRemoval=true)
        public Optional<String> pkceSecret = Optional.empty();
        @ConfigItem
        public Optional<String> stateSecret = Optional.empty();

        public Optional<Duration> getInternalIdTokenLifespan() {
            return this.internalIdTokenLifespan;
        }

        public void setInternalIdTokenLifespan(Duration internalIdTokenLifespan) {
            this.internalIdTokenLifespan = Optional.of(internalIdTokenLifespan);
        }

        public Optional<Boolean> isPkceRequired() {
            return this.pkceRequired;
        }

        public void setPkceRequired(boolean pkceRequired) {
            this.pkceRequired = Optional.of(pkceRequired);
        }

        @Deprecated(forRemoval=true)
        public Optional<String> getPkceSecret() {
            return this.pkceSecret;
        }

        @Deprecated(forRemoval=true)
        public void setPkceSecret(String pkceSecret) {
            this.pkceSecret = Optional.of(pkceSecret);
        }

        public Optional<String> getErrorPath() {
            return this.errorPath;
        }

        public void setErrorPath(String errorPath) {
            this.errorPath = Optional.of(errorPath);
        }

        public boolean isJavaScriptAutoRedirect() {
            return this.javaScriptAutoRedirect;
        }

        public void setJavaScriptAutoredirect(boolean autoRedirect) {
            this.javaScriptAutoRedirect = autoRedirect;
        }

        public Optional<String> getRedirectPath() {
            return this.redirectPath;
        }

        public void setRedirectPath(String redirectPath) {
            this.redirectPath = Optional.of(redirectPath);
        }

        public Optional<List<String>> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = Optional.of(scopes);
        }

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public void setAddOpenidScope(boolean addOpenidScope) {
            this.addOpenidScope = Optional.of(addOpenidScope);
        }

        public Optional<Boolean> isAddOpenidScope() {
            return this.addOpenidScope;
        }

        public Optional<Boolean> isForceRedirectHttpsScheme() {
            return this.forceRedirectHttpsScheme;
        }

        public void setForceRedirectHttpsScheme(boolean forceRedirectHttpsScheme) {
            this.forceRedirectHttpsScheme = Optional.of(forceRedirectHttpsScheme);
        }

        public boolean isRestorePathAfterRedirect() {
            return this.restorePathAfterRedirect;
        }

        public void setRestorePathAfterRedirect(boolean restorePathAfterRedirect) {
            this.restorePathAfterRedirect = restorePathAfterRedirect;
        }

        public boolean isCookieForceSecure() {
            return this.cookieForceSecure;
        }

        public void setCookieForceSecure(boolean cookieForceSecure) {
            this.cookieForceSecure = cookieForceSecure;
        }

        public String getCookiePath() {
            return this.cookiePath;
        }

        public void setCookiePath(String cookiePath) {
            this.cookiePath = cookiePath;
        }

        public Optional<String> getCookieDomain() {
            return this.cookieDomain;
        }

        public void setCookieDomain(String cookieDomain) {
            this.cookieDomain = Optional.of(cookieDomain);
        }

        public Optional<Boolean> isUserInfoRequired() {
            return this.userInfoRequired;
        }

        public void setUserInfoRequired(boolean userInfoRequired) {
            this.userInfoRequired = Optional.of(userInfoRequired);
        }

        public boolean isRemoveRedirectParameters() {
            return this.removeRedirectParameters;
        }

        public void setRemoveRedirectParameters(boolean removeRedirectParameters) {
            this.removeRedirectParameters = removeRedirectParameters;
        }

        public boolean isVerifyAccessToken() {
            return this.verifyAccessToken;
        }

        public void setVerifyAccessToken(boolean verifyAccessToken) {
            this.verifyAccessToken = verifyAccessToken;
        }

        public Duration getSessionAgeExtension() {
            return this.sessionAgeExtension;
        }

        public void setSessionAgeExtension(Duration sessionAgeExtension) {
            this.sessionAgeExtension = sessionAgeExtension;
        }

        public Optional<String> getCookiePathHeader() {
            return this.cookiePathHeader;
        }

        public void setCookiePathHeader(String cookiePathHeader) {
            this.cookiePathHeader = Optional.of(cookiePathHeader);
        }

        public Optional<Boolean> isIdTokenRequired() {
            return this.idTokenRequired;
        }

        public void setIdTokenRequired(boolean idTokenRequired) {
            this.idTokenRequired = Optional.of(idTokenRequired);
        }

        public Optional<String> getCookieSuffix() {
            return this.cookieSuffix;
        }

        public void setCookieSuffix(String cookieSuffix) {
            this.cookieSuffix = Optional.of(cookieSuffix);
        }

        public Optional<ResponseMode> getResponseMode() {
            return this.responseMode;
        }

        public void setResponseMode(ResponseMode responseMode) {
            this.responseMode = Optional.of(responseMode);
        }

        public Optional<List<String>> getForwardParams() {
            return this.forwardParams;
        }

        public void setForwardParams(List<String> forwardParams) {
            this.forwardParams = Optional.of(forwardParams);
        }

        public CookieSameSite getCookieSameSite() {
            return this.cookieSameSite;
        }

        public void setCookieSameSite(CookieSameSite cookieSameSite) {
            this.cookieSameSite = cookieSameSite;
        }

        public boolean isAllowMultipleCodeFlows() {
            return this.allowMultipleCodeFlows;
        }

        public void setAllowMultipleCodeFlows(boolean allowMultipleCodeFlows) {
            this.allowMultipleCodeFlows = allowMultipleCodeFlows;
        }

        public boolean isNonceRequired() {
            return this.nonceRequired;
        }

        public void setNonceRequired(boolean nonceRequired) {
            this.nonceRequired = nonceRequired;
        }

        public Optional<String> getStateSecret() {
            return this.stateSecret;
        }

        public void setStateSecret(Optional<String> stateSecret) {
            this.stateSecret = stateSecret;
        }

        public Optional<String> getScopeSeparator() {
            return this.scopeSeparator;
        }

        public void setScopeSeparator(String scopeSeparator) {
            this.scopeSeparator = Optional.of(scopeSeparator);
        }

        public static enum CookieSameSite {
            STRICT,
            LAX,
            NONE;

        }

        public static enum ResponseMode {
            QUERY,
            FORM_POST;

        }
    }

    @ConfigGroup
    public static class CodeGrant {
        @ConfigItem
        public Map<String, String> extraParams = new HashMap<String, String>();
        @ConfigItem
        public Map<String, String> headers = new HashMap<String, String>();

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }
    }

    @ConfigGroup
    public static class TokenStateManager {
        @ConfigItem(defaultValue="keep_all_tokens")
        public Strategy strategy = Strategy.KEEP_ALL_TOKENS;
        @ConfigItem(defaultValue="false")
        public boolean splitTokens;
        @ConfigItem(defaultValue="true")
        public boolean encryptionRequired = true;
        @ConfigItem
        public Optional<String> encryptionSecret = Optional.empty();

        public boolean isEncryptionRequired() {
            return this.encryptionRequired;
        }

        public void setEncryptionRequired(boolean encryptionRequired) {
            this.encryptionRequired = encryptionRequired;
        }

        public Optional<String> getEncryptionSecret() {
            return this.encryptionSecret;
        }

        public void setEncryptionSecret(String encryptionSecret) {
            this.encryptionSecret = Optional.of(encryptionSecret);
        }

        public boolean isSplitTokens() {
            return this.splitTokens;
        }

        public void setSplitTokens(boolean splitTokens) {
            this.splitTokens = splitTokens;
        }

        public Strategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(Strategy strategy) {
            this.strategy = strategy;
        }

        public static enum Strategy {
            KEEP_ALL_TOKENS,
            ID_TOKEN,
            ID_REFRESH_TOKENS;

        }
    }

    @ConfigGroup
    public static class Jwks {
        @ConfigItem(defaultValue="true")
        public boolean resolveEarly = true;
        @ConfigItem(defaultValue="10")
        public int cacheSize = 10;
        @ConfigItem(defaultValue="10M")
        public Duration cacheTimeToLive = Duration.ofMinutes(10L);
        @ConfigItem
        public Optional<Duration> cleanUpTimerInterval = Optional.empty();

        public int getCacheSize() {
            return this.cacheSize;
        }

        public void setCacheSize(int cacheSize) {
            this.cacheSize = cacheSize;
        }

        public Duration getCacheTimeToLive() {
            return this.cacheTimeToLive;
        }

        public void setCacheTimeToLive(Duration cacheTimeToLive) {
            this.cacheTimeToLive = cacheTimeToLive;
        }

        public Optional<Duration> getCleanUpTimerInterval() {
            return this.cleanUpTimerInterval;
        }

        public void setCleanUpTimerInterval(Duration cleanUpTimerInterval) {
            this.cleanUpTimerInterval = Optional.of(cleanUpTimerInterval);
        }

        public boolean isResolveEarly() {
            return this.resolveEarly;
        }

        public void setResolveEarly(boolean resolveEarly) {
            this.resolveEarly = resolveEarly;
        }
    }

    public static enum Provider {
        APPLE,
        DISCORD,
        FACEBOOK,
        GITHUB,
        GOOGLE,
        LINKEDIN,
        MASTODON,
        MICROSOFT,
        SPOTIFY,
        STRAVA,
        TWITCH,
        TWITTER,
        X;

    }

    public static enum ApplicationType {
        WEB_APP,
        SERVICE,
        HYBRID;

    }

    public static enum SignatureAlgorithm {
        RS256,
        RS384,
        RS512,
        PS256,
        PS384,
        PS512,
        ES256,
        ES384,
        ES512,
        EDDSA;

        private static String EDDSA_ALG;
        private static String REQUIRED_EDDSA_ALG;

        public String getAlgorithm() {
            String name = this.name();
            return EDDSA_ALG.equals(name) ? REQUIRED_EDDSA_ALG : name;
        }

        static {
            EDDSA_ALG = "EDDSA";
            REQUIRED_EDDSA_ALG = "EdDSA";
        }
    }

    @ConfigGroup
    public static class Frontchannel {
        @ConfigItem
        public Optional<String> path = Optional.empty();

        public void setPath(Optional<String> path) {
            this.path = path;
        }

        public Optional<String> getPath() {
            return this.path;
        }
    }

    @ConfigGroup
    public static class Backchannel {
        @ConfigItem
        public Optional<String> path = Optional.empty();
        @ConfigItem(defaultValue="10")
        public int tokenCacheSize = 10;
        @ConfigItem(defaultValue="10M")
        public Duration tokenCacheTimeToLive = Duration.ofMinutes(10L);
        @ConfigItem
        public Optional<Duration> cleanUpTimerInterval = Optional.empty();
        @ConfigItem(defaultValue="sub")
        public String logoutTokenKey = "sub";

        public void setPath(Optional<String> path) {
            this.path = path;
        }

        public Optional<String> getPath() {
            return this.path;
        }

        public String getLogoutTokenKey() {
            return this.logoutTokenKey;
        }

        public void setLogoutTokenKey(String logoutTokenKey) {
            this.logoutTokenKey = logoutTokenKey;
        }

        public int getTokenCacheSize() {
            return this.tokenCacheSize;
        }

        public void setTokenCacheSize(int tokenCacheSize) {
            this.tokenCacheSize = tokenCacheSize;
        }

        public Duration getTokenCacheTimeToLive() {
            return this.tokenCacheTimeToLive;
        }

        public void setTokenCacheTimeToLive(Duration tokenCacheTimeToLive) {
            this.tokenCacheTimeToLive = tokenCacheTimeToLive;
        }

        public Optional<Duration> getCleanUpTimerInterval() {
            return this.cleanUpTimerInterval;
        }

        public void setCleanUpTimerInterval(Duration cleanUpTimerInterval) {
            this.cleanUpTimerInterval = Optional.of(cleanUpTimerInterval);
        }
    }
}

