/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.config;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import jakarta.annotation.Priority;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

@Priority(value=3305)
public class HierarchicalOTelConnectionConfigInterceptor
extends FallbackConfigSourceInterceptor {
    private static final List<String> PROPERTY_NAMES = List.of("endpoint", "headers", "compression", "timeout", "protocol", "key-cert.keys", "key-cert.certs", "trust-cert.certs", "tls-configuration-name", "proxy-options.enabled", "proxy-options.username", "proxy-options.password", "proxy-options.port", "proxy-options.host");
    static final String BASE = "quarkus.otel.exporter.otlp.";
    static final String TRACES = "quarkus.otel.exporter.otlp.traces.";
    static final String METRICS = "quarkus.otel.exporter.otlp.metrics.";
    private static final MappingFunction mappingFunction = new MappingFunction();

    public HierarchicalOTelConnectionConfigInterceptor() {
        super((Function)mappingFunction);
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            String name = (String)namesIterator.next();
            String fallback = mappingFunction.apply(name);
            if (fallback != null) {
                ConfigValue nameValue = context.proceed(name);
                ConfigValue fallbackValue = context.proceed(fallback);
                if (nameValue == null) {
                    names.add(fallback);
                    continue;
                }
                if (fallbackValue == null) {
                    names.add(name);
                    continue;
                }
                if (nameValue.getConfigSourceOrdinal() >= fallbackValue.getConfigSourceOrdinal()) {
                    names.add(name);
                    continue;
                }
                names.add(fallback);
                continue;
            }
            names.add(name);
        }
        return names.iterator();
    }

    static class MappingFunction
    implements Function<String, String> {
        MappingFunction() {
        }

        @Override
        public String apply(String name) {
            String property;
            if (name.startsWith(HierarchicalOTelConnectionConfigInterceptor.TRACES) && PROPERTY_NAMES.contains(property = name.substring(HierarchicalOTelConnectionConfigInterceptor.TRACES.length()))) {
                return HierarchicalOTelConnectionConfigInterceptor.BASE + property;
            }
            if (name.startsWith(HierarchicalOTelConnectionConfigInterceptor.METRICS) && PROPERTY_NAMES.contains(property = name.substring(HierarchicalOTelConnectionConfigInterceptor.METRICS.length()))) {
                return HierarchicalOTelConnectionConfigInterceptor.BASE + property;
            }
            return name;
        }
    }
}

