/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.quarkus.grpc.GlobalInterceptor;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.grpc.GrpcAttributesGetter;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.grpc.GrpcRequest;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.grpc.GrpcSpanNameExtractor;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.grpc.GrpcSpanStatusExtractor;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.grpc.GrpcStatusCodeExtractor;
import jakarta.inject.Singleton;

@Singleton
@GlobalInterceptor
public class GrpcTracingClientInterceptor
implements ClientInterceptor {
    private final OpenTelemetry openTelemetry;
    private final Instrumenter<GrpcRequest, Status> instrumenter;

    public GrpcTracingClientInterceptor(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)new GrpcSpanNameExtractor());
        builder.addAttributesExtractor(RpcClientAttributesExtractor.create((RpcAttributesGetter)GrpcAttributesGetter.INSTANCE)).addAttributesExtractor((AttributesExtractor)new GrpcStatusCodeExtractor()).setSpanStatusExtractor((SpanStatusExtractor)new GrpcSpanStatusExtractor());
        this.instrumenter = builder.buildClientInstrumenter((TextMapSetter)GrpcTextMapSetter.INSTANCE);
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        GrpcRequest grpcRequest = GrpcRequest.client(method, callOptions.getAuthority());
        Context parentContext = Context.current();
        boolean shouldStart = this.instrumenter.shouldStart(parentContext, (Object)grpcRequest);
        if (shouldStart) {
            Context spanContext = this.instrumenter.start(parentContext, (Object)grpcRequest);
            try (Scope ignored = spanContext.makeCurrent();){
                ClientCall clientCall = next.newCall(method, callOptions);
                TracingClientCall tracingClientCall = new TracingClientCall(clientCall, spanContext, grpcRequest);
                return tracingClientCall;
            }
        }
        return next.newCall(method, callOptions);
    }

    private static enum GrpcTextMapSetter implements TextMapSetter<GrpcRequest>
    {
        INSTANCE;


        public void set(GrpcRequest carrier, String key, String value) {
            if (carrier != null && carrier.getMetadata() != null) {
                carrier.getMetadata().put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
            }
        }
    }

    private class TracingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final Context spanContext;
        private final GrpcRequest grpcRequest;

        protected TracingClientCall(ClientCall<ReqT, RespT> delegate, Context spanContext, GrpcRequest grpcRequest) {
            super(delegate);
            this.spanContext = spanContext;
            this.grpcRequest = grpcRequest;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            GrpcRequest clientRequest = GrpcRequest.client(this.grpcRequest.getMethodDescriptor(), headers);
            GrpcTracingClientInterceptor.this.openTelemetry.getPropagators().getTextMapPropagator().inject(this.spanContext, (Object)clientRequest, (TextMapSetter)GrpcTextMapSetter.INSTANCE);
            super.start(new TracingClientCallListener<RespT>(responseListener, this.spanContext, clientRequest), headers);
        }
    }

    private class TracingClientCallListener<ReqT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<ReqT> {
        private final Context spanContext;
        private final GrpcRequest grpcRequest;

        public TracingClientCallListener(ClientCall.Listener<ReqT> delegate, Context spanContext, GrpcRequest grpcRequest) {
            super(delegate);
            this.spanContext = spanContext;
            this.grpcRequest = grpcRequest;
        }

        public void onClose(Status status, Metadata trailers) {
            GrpcTracingClientInterceptor.this.instrumenter.end(this.spanContext, (Object)this.grpcRequest, (Object)status, status.getCause());
            super.onClose(status, trailers);
        }
    }
}

