/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.exporter.otlp.sender;

import io.opentelemetry.exporter.internal.http.HttpSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.quarkus.opentelemetry.runtime.exporter.otlp.OTelExporterUtil;
import io.quarkus.vertx.core.runtime.BufferOutputStream;
import io.smallrye.mutiny.Uni;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.tracing.TracingPolicy;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public final class VertxHttpSender
implements HttpSender {
    public static final String TRACES_PATH = "/v1/traces";
    public static final String METRICS_PATH = "/v1/metrics";
    public static final String LOGS_PATH = "/v1/logs";
    private static final Logger internalLogger = Logger.getLogger(VertxHttpSender.class.getName());
    private static final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private static final int MAX_ATTEMPTS = 3;
    private final String basePath;
    private final boolean compressionEnabled;
    private final Map<String, String> headers;
    private final String contentType;
    private final HttpClient client;
    private final String signalPath;
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final CompletableResultCode shutdownResult = new CompletableResultCode();

    public VertxHttpSender(URI baseUri, String signalPath, boolean compressionEnabled, Duration timeout, Map<String, String> headersMap, String contentType, Consumer<HttpClientOptions> clientOptionsCustomizer, Vertx vertx) {
        this.basePath = VertxHttpSender.determineBasePath(baseUri);
        this.signalPath = signalPath;
        this.compressionEnabled = compressionEnabled;
        this.headers = headersMap;
        this.contentType = contentType;
        HttpClientOptions httpClientOptions = new HttpClientOptions().setReadIdleTimeout((int)timeout.getSeconds()).setDefaultHost(baseUri.getHost()).setDefaultPort(OTelExporterUtil.getPort(baseUri)).setTracingPolicy(TracingPolicy.IGNORE);
        clientOptionsCustomizer.accept(httpClientOptions);
        this.client = vertx.createHttpClient(httpClientOptions);
    }

    private static String determineBasePath(URI baseUri) {
        Object path = baseUri.getPath();
        if (((String)path).isEmpty() || ((String)path).equals("/")) {
            return "";
        }
        if (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }

    public void send(Marshaler marshaler, int contentLength, Consumer<HttpSender.Response> onHttpResponseRead, Consumer<Throwable> onError) {
        if (this.isShutdown.get()) {
            return;
        }
        String requestURI = this.basePath + this.signalPath;
        ClientRequestSuccessHandler clientRequestSuccessHandler = new ClientRequestSuccessHandler(this.client, requestURI, this.headers, this.compressionEnabled, this.contentType, contentLength, onHttpResponseRead, onError, marshaler, 1, this.isShutdown::get);
        VertxHttpSender.initiateSend(this.client, requestURI, 3, clientRequestSuccessHandler, onError, this.isShutdown::get);
    }

    private static void initiateSend(final HttpClient client, final String requestURI, int numberOfAttempts, final Handler<HttpClientRequest> clientRequestSuccessHandler, Consumer<Throwable> onError, Supplier<Boolean> isShutdown) {
        Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<HttpClientRequest>>(){

            @Override
            public CompletionStage<HttpClientRequest> get() {
                return client.request(HttpMethod.POST, requestURI).toCompletionStage();
            }
        }).onFailure((Predicate)new Predicate<Throwable>(){

            @Override
            public boolean test(Throwable t) {
                return t instanceof IllegalStateException || t instanceof RejectedExecutionException;
            }
        }).recoverWithUni((Supplier)new Supplier<Uni<? extends HttpClientRequest>>(){

            @Override
            public Uni<? extends HttpClientRequest> get() {
                return Uni.createFrom().nothing();
            }
        }).onFailure().retry().withBackOff(Duration.ofMillis(100L)).atMost((long)numberOfAttempts).subscribe().with((Consumer)new Consumer<HttpClientRequest>(){

            @Override
            public void accept(HttpClientRequest request) {
                clientRequestSuccessHandler.handle((Object)request);
            }
        }, onError);
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            logger.log(Level.FINE, "Calling shutdown() multiple times.");
            return this.shutdownResult;
        }
        this.client.close().onSuccess((Handler)new Handler<Void>(){

            public void handle(Void event) {
                VertxHttpSender.this.shutdownResult.succeed();
            }
        }).onFailure((Handler)new Handler<Throwable>(){

            public void handle(Throwable event) {
                VertxHttpSender.this.shutdownResult.fail();
            }
        });
        return this.shutdownResult;
    }

    private static class ClientRequestSuccessHandler
    implements Handler<HttpClientRequest> {
        private final HttpClient client;
        private final String requestURI;
        private final Map<String, String> headers;
        private final boolean compressionEnabled;
        private final String contentType;
        private final int contentLength;
        private final Consumer<HttpSender.Response> onHttpResponseRead;
        private final Consumer<Throwable> onError;
        private final Marshaler marshaler;
        private final int attemptNumber;
        private final Supplier<Boolean> isShutdown;

        public ClientRequestSuccessHandler(HttpClient client, String requestURI, Map<String, String> headers, boolean compressionEnabled, String contentType, int contentLength, Consumer<HttpSender.Response> onHttpResponseRead, Consumer<Throwable> onError, Marshaler marshaler, int attemptNumber, Supplier<Boolean> isShutdown) {
            this.client = client;
            this.requestURI = requestURI;
            this.headers = headers;
            this.compressionEnabled = compressionEnabled;
            this.contentType = contentType;
            this.contentLength = contentLength;
            this.onHttpResponseRead = onHttpResponseRead;
            this.onError = onError;
            this.marshaler = marshaler;
            this.attemptNumber = attemptNumber;
            this.isShutdown = isShutdown;
        }

        public void handle(HttpClientRequest request) {
            Buffer buffer;
            HttpClientRequest clientRequest;
            block12: {
                clientRequest = request.response((Handler)new Handler<AsyncResult<HttpClientResponse>>(){

                    public void handle(AsyncResult<HttpClientResponse> callResult) {
                        if (callResult.succeeded()) {
                            final HttpClientResponse clientResponse = (HttpClientResponse)callResult.result();
                            Throwable cause = callResult.cause();
                            clientResponse.body((Handler)new Handler<AsyncResult<Buffer>>(){

                                public void handle(final AsyncResult<Buffer> bodyResult) {
                                    if (bodyResult.succeeded()) {
                                        if (clientResponse.statusCode() >= 500 && attemptNumber <= 3 && !isShutdown.get().booleanValue()) {
                                            VertxHttpSender.initiateSend(client, requestURI, 3 - attemptNumber, this.newAttempt(), onError, isShutdown);
                                            return;
                                        }
                                        onHttpResponseRead.accept(new HttpSender.Response(){

                                            public int statusCode() {
                                                return clientResponse.statusCode();
                                            }

                                            public String statusMessage() {
                                                return clientResponse.statusMessage();
                                            }

                                            public byte[] responseBody() {
                                                return ((Buffer)bodyResult.result()).getBytes();
                                            }
                                        });
                                    } else if (attemptNumber <= 3 && !isShutdown.get().booleanValue()) {
                                        VertxHttpSender.initiateSend(client, requestURI, 3 - attemptNumber, this.newAttempt(), onError, isShutdown);
                                    } else {
                                        onError.accept(bodyResult.cause());
                                    }
                                }
                            });
                        } else if (attemptNumber <= 3 && !isShutdown.get().booleanValue()) {
                            VertxHttpSender.initiateSend(client, requestURI, 3 - attemptNumber, this.newAttempt(), onError, isShutdown);
                        } else {
                            onError.accept(callResult.cause());
                        }
                    }
                }).putHeader("Content-Type", this.contentType);
                buffer = Buffer.buffer((int)this.contentLength);
                BufferOutputStream os = new BufferOutputStream(buffer);
                if (this.compressionEnabled) {
                    clientRequest.putHeader("Content-Encoding", "gzip");
                    try (GZIPOutputStream gzos = new GZIPOutputStream((OutputStream)os);){
                        this.marshaler.writeBinaryTo((OutputStream)gzos);
                        break block12;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                try {
                    this.marshaler.writeBinaryTo((OutputStream)os);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (!this.headers.isEmpty()) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    clientRequest.putHeader(entry.getKey(), entry.getValue());
                }
            }
            clientRequest.send(buffer);
        }

        public ClientRequestSuccessHandler newAttempt() {
            return new ClientRequestSuccessHandler(this.client, this.requestURI, this.headers, this.compressionEnabled, this.contentType, this.contentLength, this.onHttpResponseRead, this.onError, this.marshaler, this.attemptNumber + 1, this.isShutdown);
        }
    }
}

