/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.quarkus.arc.BeanDestroyer;
import io.smallrye.config.SmallRyeConfig;
import jakarta.enterprise.context.spi.CreationalContext;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.ConfigProvider;

public class OpenTelemetryDestroyer
implements BeanDestroyer<OpenTelemetry> {
    public void destroy(OpenTelemetry openTelemetry, CreationalContext<OpenTelemetry> creationalContext, Map<String, Object> params) {
        if (openTelemetry instanceof OpenTelemetrySdk) {
            Duration waitTime = OpenTelemetryDestroyer.getShutdownWaitTime().dividedBy(2L);
            OpenTelemetrySdk openTelemetrySdk = (OpenTelemetrySdk)openTelemetry;
            openTelemetrySdk.getSdkTracerProvider().forceFlush().join(waitTime.toMillis(), TimeUnit.MILLISECONDS);
            openTelemetrySdk.getSdkTracerProvider().shutdown().join(waitTime.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    public static Duration getShutdownWaitTime() {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        Duration waitTime = config.getOptionalValue("quarkus.otel.experimental.shutdown-wait-time", Duration.class).orElse(Duration.ofSeconds(1L));
        return waitTime;
    }
}

