/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.exporter.otlp;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import io.opentelemetry.exporter.internal.http.HttpExporter;
import io.opentelemetry.exporter.internal.http.HttpSender;
import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.CompressionType;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.OtlpExporterRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.OtlpExporterTracesConfig;
import io.quarkus.opentelemetry.runtime.exporter.otlp.LateBoundBatchSpanProcessor;
import io.quarkus.opentelemetry.runtime.exporter.otlp.OTelExporterUtil;
import io.quarkus.opentelemetry.runtime.exporter.otlp.RemoveableLateBoundBatchSpanProcessor;
import io.quarkus.opentelemetry.runtime.exporter.otlp.VertxGrpcExporter;
import io.quarkus.opentelemetry.runtime.exporter.otlp.VertxHttpExporter;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Recorder
public class OTelExporterRecorder {
    public Function<SyntheticCreationalContext<LateBoundBatchSpanProcessor>, LateBoundBatchSpanProcessor> batchSpanProcessorForOtlp(final OTelRuntimeConfig otelRuntimeConfig, final OtlpExporterRuntimeConfig exporterRuntimeConfig, final TlsConfig tlsConfig, final Supplier<Vertx> vertx) {
        final URI baseUri = this.getBaseUri(exporterRuntimeConfig);
        return new Function<SyntheticCreationalContext<LateBoundBatchSpanProcessor>, LateBoundBatchSpanProcessor>(){

            @Override
            public LateBoundBatchSpanProcessor apply(SyntheticCreationalContext<LateBoundBatchSpanProcessor> context) {
                if (otelRuntimeConfig.sdkDisabled() || baseUri == null) {
                    return RemoveableLateBoundBatchSpanProcessor.INSTANCE;
                }
                Instance spanExporters = (Instance)context.getInjectedReference((TypeLiteral)new TypeLiteral<Instance<SpanExporter>>(){}, new Annotation[0]);
                if (!spanExporters.isUnsatisfied()) {
                    return RemoveableLateBoundBatchSpanProcessor.INSTANCE;
                }
                try {
                    SpanExporter spanExporter = this.createSpanExporter(exporterRuntimeConfig, (Vertx)vertx.get(), baseUri);
                    BatchSpanProcessorBuilder processorBuilder = BatchSpanProcessor.builder((SpanExporter)spanExporter);
                    processorBuilder.setScheduleDelay(otelRuntimeConfig.bsp().scheduleDelay());
                    processorBuilder.setMaxQueueSize(otelRuntimeConfig.bsp().maxQueueSize().intValue());
                    processorBuilder.setMaxExportBatchSize(otelRuntimeConfig.bsp().maxExportBatchSize().intValue());
                    processorBuilder.setExporterTimeout(otelRuntimeConfig.bsp().exportTimeout());
                    return new LateBoundBatchSpanProcessor(processorBuilder.build());
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalStateException("Unable to install OTLP Exporter", iae);
                }
            }

            private SpanExporter createSpanExporter(OtlpExporterRuntimeConfig exporterRuntimeConfig2, Vertx vertx2, URI baseUri2) {
                OtlpExporterTracesConfig tracesConfig = exporterRuntimeConfig2.traces();
                if (tracesConfig.protocol().isEmpty()) {
                    throw new IllegalStateException("No OTLP protocol specified. Please check `quarkus.otel.exporter.otlp.traces.protocol` property");
                }
                String protocol = tracesConfig.protocol().get();
                if ("grpc".equals(protocol)) {
                    return this.createOtlpGrpcSpanExporter(exporterRuntimeConfig2, vertx2, baseUri2);
                }
                if ("http/protobuf".equals(protocol)) {
                    return this.createHttpSpanExporter(exporterRuntimeConfig2, vertx2, baseUri2, protocol);
                }
                throw new IllegalArgumentException(String.format("Unsupported OTLP protocol %s specified. Please check `quarkus.otel.exporter.otlp.traces.protocol` property", protocol));
            }

            private SpanExporter createOtlpGrpcSpanExporter(OtlpExporterRuntimeConfig exporterRuntimeConfig2, Vertx vertx2, URI baseUri2) {
                OtlpExporterTracesConfig tracesConfig = exporterRuntimeConfig2.traces();
                return new VertxGrpcExporter("otlp", "span", MeterProvider::noop, baseUri2, OTelExporterRecorder.determineCompression(tracesConfig), tracesConfig.timeout(), OTelExporterRecorder.populateTracingExportHttpHeaders(tracesConfig), new HttpClientOptionsConsumer(tracesConfig, baseUri2, tlsConfig), vertx2);
            }

            private SpanExporter createHttpSpanExporter(OtlpExporterRuntimeConfig exporterRuntimeConfig2, Vertx vertx2, URI baseUri2, String protocol) {
                OtlpExporterTracesConfig tracesConfig = exporterRuntimeConfig2.traces();
                boolean exportAsJson = false;
                return new VertxHttpExporter((HttpExporter<TraceRequestMarshaler>)new HttpExporter("otlp", "span", (HttpSender)new VertxHttpExporter.VertxHttpSender(baseUri2, OTelExporterRecorder.determineCompression(tracesConfig), tracesConfig.timeout(), OTelExporterRecorder.populateTracingExportHttpHeaders(tracesConfig), exportAsJson ? "application/json" : "application/x-protobuf", new HttpClientOptionsConsumer(tracesConfig, baseUri2, tlsConfig), vertx2), MeterProvider::noop, exportAsJson));
            }
        };
    }

    private static boolean determineCompression(OtlpExporterTracesConfig tracesConfig) {
        if (tracesConfig.compression().isPresent()) {
            return tracesConfig.compression().get() == CompressionType.GZIP;
        }
        return false;
    }

    private static Map<String, String> populateTracingExportHttpHeaders(OtlpExporterTracesConfig tracesConfig) {
        List<String> headers;
        HashMap<String, String> headersMap = new HashMap<String, String>();
        OtlpUserAgent.addUserAgentHeader(headersMap::put);
        if (tracesConfig.headers().isPresent() && !(headers = tracesConfig.headers().get()).isEmpty()) {
            for (String header : headers) {
                if (header.isEmpty()) continue;
                String[] parts = header.split("=", 2);
                String key = parts[0].trim();
                String value = parts[1].trim();
                headersMap.put(key, value);
            }
        }
        return headersMap;
    }

    private URI getBaseUri(OtlpExporterRuntimeConfig exporterRuntimeConfig) {
        String endpoint = OTelExporterRecorder.resolveEndpoint(exporterRuntimeConfig).trim();
        if (endpoint.isEmpty()) {
            return null;
        }
        return ExporterBuilderUtil.validateEndpoint((String)endpoint);
    }

    static String resolveEndpoint(OtlpExporterRuntimeConfig runtimeConfig) {
        String endpoint = runtimeConfig.traces().legacyEndpoint().filter(OTelExporterRecorder::excludeDefaultEndpoint).orElse(runtimeConfig.traces().endpoint().filter(OTelExporterRecorder::excludeDefaultEndpoint).orElse(runtimeConfig.endpoint().filter(OTelExporterRecorder::excludeDefaultEndpoint).orElse("http://localhost:4317/")));
        return endpoint.trim();
    }

    private static boolean excludeDefaultEndpoint(String endpoint) {
        return !"http://localhost:4317/".equals(endpoint);
    }

    private static class HttpClientOptionsConsumer
    implements Consumer<HttpClientOptions> {
        private final OtlpExporterTracesConfig tracesConfig;
        private final URI baseUri;
        private final TlsConfig tlsConfig;

        public HttpClientOptionsConsumer(OtlpExporterTracesConfig tracesConfig, URI baseUri, TlsConfig tlsConfig) {
            this.tracesConfig = tracesConfig;
            this.baseUri = baseUri;
            this.tlsConfig = tlsConfig;
        }

        @Override
        public void accept(HttpClientOptions options) {
            this.configureTLS(options);
        }

        private void configureTLS(HttpClientOptions options) {
            options.setKeyCertOptions(this.toPemKeyCertOptions());
            options.setPemTrustOptions(this.toPemTrustOptions());
            if (OTelExporterUtil.isHttps(this.baseUri)) {
                options.setSsl(true);
                options.setUseAlpn(true);
            }
            if (this.tlsConfig.trustAll) {
                options.setTrustAll(true);
                options.setVerifyHost(false);
            }
        }

        private KeyCertOptions toPemKeyCertOptions() {
            OtlpExporterTracesConfig.KeyCert keyCert = this.tracesConfig.keyCert();
            if (keyCert.certs().isEmpty() && keyCert.keys().isEmpty()) {
                return null;
            }
            PemKeyCertOptions pemKeyCertOptions = new PemKeyCertOptions();
            if (keyCert.certs().isPresent()) {
                for (String cert : keyCert.certs().get()) {
                    pemKeyCertOptions.addCertPath(cert);
                }
            }
            if (keyCert.keys().isPresent()) {
                for (String cert : keyCert.keys().get()) {
                    pemKeyCertOptions.addKeyPath(cert);
                }
            }
            return pemKeyCertOptions;
        }

        private PemTrustOptions toPemTrustOptions() {
            List<String> certs;
            OtlpExporterTracesConfig.TrustCert trustCert = this.tracesConfig.trustCert();
            if (trustCert.certs().isPresent() && !(certs = trustCert.certs().get()).isEmpty()) {
                PemTrustOptions pemTrustOptions = new PemTrustOptions();
                for (String cert : trustCert.certs().get()) {
                    pemTrustOptions.addCertPath(cert);
                }
                return pemTrustOptions;
            }
            return null;
        }
    }
}

