/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.cdi;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.api.annotation.support.ParameterAttributeNamesExtractor;
import io.quarkus.arc.ArcInvocationContext;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

@Interceptor
@Priority(value=0)
public class AddingSpanAttributesInterceptor {
    private final WithSpanParameterAttributeNamesExtractor extractor = new WithSpanParameterAttributeNamesExtractor();

    @AroundInvoke
    public Object span(ArcInvocationContext invocationContext) throws Exception {
        String[] extractedParameterNames = this.extractor.extract(invocationContext.getMethod(), invocationContext.getMethod().getParameters());
        Object[] parameterValues = invocationContext.getParameters();
        Span span = Span.current();
        if (span.isRecording()) {
            try (Scope scope = span.makeCurrent();){
                for (int i = 0; i < extractedParameterNames.length; ++i) {
                    if (extractedParameterNames[i] == null || parameterValues[i] == null) continue;
                    span.setAttribute(extractedParameterNames[i], parameterValues[i].toString());
                }
            }
        }
        return invocationContext.proceed();
    }

    private static final class WithSpanParameterAttributeNamesExtractor
    implements ParameterAttributeNamesExtractor {
        private WithSpanParameterAttributeNamesExtractor() {
        }

        public String[] extract(Method method, Parameter[] parameters) {
            String[] attributeNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                attributeNames[i] = WithSpanParameterAttributeNamesExtractor.attributeName(parameters[i]);
            }
            return attributeNames;
        }

        private static String attributeName(Parameter parameter) {
            String value;
            SpanAttribute spanAttribute = parameter.getDeclaredAnnotation(SpanAttribute.class);
            if (spanAttribute == null) {
                io.opentelemetry.extension.annotations.SpanAttribute legacySpanAttribute = parameter.getDeclaredAnnotation(io.opentelemetry.extension.annotations.SpanAttribute.class);
                if (legacySpanAttribute == null) {
                    return null;
                }
                value = legacySpanAttribute.value();
            } else {
                value = spanAttribute.value();
            }
            if (!value.isEmpty()) {
                return value;
            }
            if (parameter.isNamePresent()) {
                return parameter.getName();
            }
            return null;
        }
    }
}

