/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.security;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.quarkus.arc.Arc;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthenticationFailureEvent;
import io.quarkus.security.spi.runtime.AuthenticationSuccessEvent;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.SecurityEvent;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.function.BiConsumer;

public final class SecurityEventUtil {
    public static final String QUARKUS_SECURITY_NAMESPACE = "quarkus.security.";
    public static final String AUTHN_SUCCESS_EVENT_NAME = "quarkus.security.authentication.success";
    public static final String AUTHN_FAILURE_EVENT_NAME = "quarkus.security.authentication.failure";
    public static final String AUTHZ_SUCCESS_EVENT_NAME = "quarkus.security.authorization.success";
    public static final String AUTHZ_FAILURE_EVENT_NAME = "quarkus.security.authorization.failure";
    public static final String OTHER_EVENT_NAME = "quarkus.security.other";
    public static final String SECURITY_IDENTITY_PRINCIPAL = "quarkus.security.identity.principal";
    public static final String SECURITY_IDENTITY_IS_ANONYMOUS = "quarkus.security.identity.anonymous";
    public static final String QUARKUS_SECURITY_OTHER_EVENTS_NAMESPACE = "quarkus.security.other.";
    public static final String FAILURE_NAME = "quarkus.security.failure.name";
    public static final String AUTHORIZATION_CONTEXT = "quarkus.security.authorization.context";

    private SecurityEventUtil() {
    }

    public static void addAllEvents(SecurityEvent event) {
        if (event instanceof AuthenticationSuccessEvent) {
            AuthenticationSuccessEvent e = (AuthenticationSuccessEvent)event;
            SecurityEventUtil.addEvent(e);
        } else if (event instanceof AuthenticationFailureEvent) {
            AuthenticationFailureEvent e = (AuthenticationFailureEvent)event;
            SecurityEventUtil.addEvent(e);
        } else if (event instanceof AuthorizationSuccessEvent) {
            AuthorizationSuccessEvent e = (AuthorizationSuccessEvent)event;
            SecurityEventUtil.addEvent(e);
        } else if (event instanceof AuthorizationFailureEvent) {
            AuthorizationFailureEvent e = (AuthorizationFailureEvent)event;
            SecurityEventUtil.addEvent(e);
        } else {
            SecurityEventUtil.addOtherEventInternal(event);
        }
    }

    public static void addEvent(AuthenticationSuccessEvent event) {
        SecurityEventUtil.addEvent(AUTHN_SUCCESS_EVENT_NAME, SecurityEventUtil.attributesBuilder((SecurityEvent)event).build());
    }

    public static void addEvent(AuthenticationFailureEvent event) {
        SecurityEventUtil.addEvent(AUTHN_FAILURE_EVENT_NAME, SecurityEventUtil.attributesBuilder((SecurityEvent)event, AuthenticationFailureEvent.AUTHENTICATION_FAILURE_KEY).build());
    }

    public static void addEvent(AuthorizationSuccessEvent event) {
        SecurityEventUtil.addEvent(AUTHZ_SUCCESS_EVENT_NAME, SecurityEventUtil.withAuthorizationContext((SecurityEvent)event, SecurityEventUtil.attributesBuilder((SecurityEvent)event), AuthorizationSuccessEvent.AUTHORIZATION_CONTEXT));
    }

    public static void addEvent(AuthorizationFailureEvent event) {
        SecurityEventUtil.addEvent(AUTHZ_FAILURE_EVENT_NAME, SecurityEventUtil.withAuthorizationContext((SecurityEvent)event, SecurityEventUtil.attributesBuilder((SecurityEvent)event, AuthorizationFailureEvent.AUTHORIZATION_FAILURE_KEY), AuthorizationFailureEvent.AUTHORIZATION_CONTEXT_KEY));
    }

    public static void addEvent(SecurityEvent event) {
        if (!(event instanceof AuthenticationSuccessEvent || event instanceof AuthenticationFailureEvent || event instanceof AuthorizationSuccessEvent || event instanceof AuthorizationFailureEvent)) {
            SecurityEventUtil.addOtherEventInternal(event);
        }
    }

    private static void addOtherEventInternal(SecurityEvent event) {
        final AttributesBuilder builder = SecurityEventUtil.attributesBuilder(event);
        event.getEventProperties().forEach(new BiConsumer<String, Object>(){

            @Override
            public void accept(String key, Object value) {
                if (value instanceof String) {
                    String str = (String)value;
                    builder.put(SecurityEventUtil.QUARKUS_SECURITY_OTHER_EVENTS_NAMESPACE + key, str);
                }
            }
        });
        SecurityEventUtil.addEvent(OTHER_EVENT_NAME, builder.build());
    }

    private static void addEvent(String eventName, Attributes attributes) {
        Span span = (Span)Arc.container().select(Span.class, new Annotation[0]).get();
        if (span.getSpanContext().isValid()) {
            span.addEvent(eventName, attributes, Instant.now());
        }
    }

    private static AttributesBuilder attributesBuilder(SecurityEvent event, String failureKey) {
        Throwable failure = (Throwable)event.getEventProperties().get(failureKey);
        if (failure != null) {
            return SecurityEventUtil.attributesBuilder(event).put(FAILURE_NAME, failure.getClass().getName());
        }
        return SecurityEventUtil.attributesBuilder(event);
    }

    private static AttributesBuilder attributesBuilder(SecurityEvent event) {
        AttributesBuilder builder = Attributes.builder();
        SecurityIdentity identity = event.getSecurityIdentity();
        if (identity != null) {
            builder.put(SECURITY_IDENTITY_IS_ANONYMOUS, identity.isAnonymous());
            if (identity.getPrincipal() != null) {
                builder.put(SECURITY_IDENTITY_PRINCIPAL, identity.getPrincipal().getName());
            }
        }
        return builder;
    }

    private static Attributes withAuthorizationContext(SecurityEvent event, AttributesBuilder builder, String contextKey) {
        if (event.getEventProperties().containsKey(contextKey)) {
            builder.put(AUTHORIZATION_CONTEXT, (String)event.getEventProperties().get(contextKey));
        }
        return builder.build();
    }
}

