/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.qute.deployment.TemplateRootBuildItem;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;

public final class TemplateRootsBuildItem
extends SimpleBuildItem
implements Iterable<String> {
    private Set<String> rootPaths;

    public TemplateRootsBuildItem(Set<String> paths) {
        this.rootPaths = paths;
    }

    public Set<String> getPaths() {
        return this.rootPaths;
    }

    @Override
    public Iterator<String> iterator() {
        return this.rootPaths.iterator();
    }

    public boolean isRoot(Path path) {
        String pathStr = TemplateRootsBuildItem.normalize(path);
        for (String rootPath : this.rootPaths) {
            if (!pathStr.equals(rootPath)) continue;
            return true;
        }
        return false;
    }

    public boolean maybeRoot(Path path) {
        String pathStr = TemplateRootsBuildItem.normalize(path);
        for (String rootPath : this.rootPaths) {
            if ((!rootPath.contains("/") || !rootPath.startsWith(pathStr)) && !rootPath.equals(pathStr)) continue;
            return true;
        }
        return false;
    }

    private static String normalize(Path path) {
        String pathStr = path.toString();
        if (File.separatorChar != '/') {
            pathStr = pathStr.replace(File.separatorChar, '/');
        }
        return TemplateRootBuildItem.normalize(pathStr);
    }
}

