/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Objects;
import java.util.function.Predicate;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class TypeCheckExcludeBuildItem
extends MultiBuildItem {
    private final Predicate<TypeCheck> predicate;
    private final boolean extensionMethodPredicate;

    public TypeCheckExcludeBuildItem(Predicate<TypeCheck> predicate) {
        this.predicate = Objects.requireNonNull(predicate);
        this.extensionMethodPredicate = false;
    }

    public TypeCheckExcludeBuildItem(Predicate<TypeCheck> predicate, boolean extensionMethodPredicate) {
        this.predicate = predicate;
        this.extensionMethodPredicate = extensionMethodPredicate;
    }

    public Predicate<TypeCheck> getPredicate() {
        return this.predicate;
    }

    public boolean isExtensionMethodPredicate() {
        return this.extensionMethodPredicate;
    }

    public static class TypeCheck {
        public final String name;
        public final ClassInfo clazz;
        public final int numberOfParameters;
        public final Type type;

        public TypeCheck(String name, ClassInfo clazz, Type type, int parameters) {
            this.name = Objects.requireNonNull(name, "Name must not be null");
            this.clazz = clazz;
            this.numberOfParameters = parameters;
            this.type = type;
        }

        public boolean nameIn(String ... values) {
            for (String value : values) {
                if (!this.name.equals(value)) continue;
                return true;
            }
            return false;
        }

        public boolean isProperty() {
            return this.numberOfParameters == -1;
        }

        public boolean classNameEquals(DotName name) {
            return this.clazz != null ? this.clazz.name().equals((Object)name) : false;
        }
    }
}

