/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment.devui;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.qute.ParameterDeclaration;
import io.quarkus.qute.deployment.CheckedTemplateBuildItem;
import io.quarkus.qute.deployment.EffectiveTemplatePathsBuildItem;
import io.quarkus.qute.deployment.ImplicitValueResolverBuildItem;
import io.quarkus.qute.deployment.TemplateDataBuildItem;
import io.quarkus.qute.deployment.TemplateExtensionMethodBuildItem;
import io.quarkus.qute.deployment.TemplateGlobalBuildItem;
import io.quarkus.qute.deployment.TemplatePathBuildItem;
import io.quarkus.qute.deployment.TemplateVariantsBuildItem;
import io.quarkus.qute.deployment.TemplatesAnalysisBuildItem;
import io.smallrye.common.annotation.SuppressForbidden;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.jandex.DotName;

public class QuteDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    public void pages(EffectiveTemplatePathsBuildItem effectiveTemplatePaths, List<CheckedTemplateBuildItem> checkedTemplates, TemplateVariantsBuildItem variants, TemplatesAnalysisBuildItem templatesAnalysis, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<TemplateDataBuildItem> templateDatas, List<ImplicitValueResolverBuildItem> implicitTemplateDatas, List<TemplateGlobalBuildItem> templateGlobals, BuildProducer<CardPageBuildItem> cardPages) {
        List<TemplateGlobalBuildItem> sortedTemplateGlobals;
        CardPageBuildItem pageBuildItem = new CardPageBuildItem();
        List<TemplatePathBuildItem> sortedTemplatePaths = effectiveTemplatePaths.getTemplatePaths().stream().sorted(Comparator.comparing(tp -> tp.getPath().toLowerCase())).collect(Collectors.toList());
        pageBuildItem.addBuildTimeData("templates", this.createTemplatesJson(sortedTemplatePaths, checkedTemplates, templatesAnalysis, variants));
        List<TemplateExtensionMethodBuildItem> sortedExtensionMethods = templateExtensionMethods.stream().sorted(new Comparator<TemplateExtensionMethodBuildItem>(){

            @Override
            public int compare(TemplateExtensionMethodBuildItem m1, TemplateExtensionMethodBuildItem m2) {
                DotName m2Class;
                DotName m1Class = m1.getMethod().declaringClass().name();
                int ret = m1Class.compareTo(m2Class = m2.getMethod().declaringClass().name());
                return ret == 0 ? m1.getMethod().name().compareTo(m2.getMethod().name()) : ret;
            }
        }).collect(Collectors.toList());
        pageBuildItem.addBuildTimeData("extensionMethods", this.createExtensionMethodsJson(sortedExtensionMethods));
        List<TemplateDataBuildItem> sortedTemplateData = new ArrayList<TemplateDataBuildItem>(templateDatas);
        HashSet<DotName> explicitTargets = new HashSet<DotName>();
        for (TemplateDataBuildItem td2 : templateDatas) {
            explicitTargets.add(td2.getTargetClass().name());
        }
        for (ImplicitValueResolverBuildItem itd : implicitTemplateDatas) {
            if (explicitTargets.contains(itd.getClazz().name())) continue;
            sortedTemplateData.add(new TemplateDataBuildItem(itd.getTemplateData(), itd.getClazz()));
        }
        if (!(sortedTemplateData = sortedTemplateData.stream().sorted(Comparator.comparing(td -> td.getTargetClass().name())).collect(Collectors.toList())).isEmpty()) {
            pageBuildItem.addBuildTimeData("templateData", this.createTemplateDataJson(sortedTemplateData));
        }
        if (!(sortedTemplateGlobals = templateGlobals.stream().sorted(Comparator.comparing(tg -> tg.getName().toLowerCase())).collect(Collectors.toList())).isEmpty()) {
            pageBuildItem.addBuildTimeData("templateGlobals", this.createTemplateGlobalsJson(sortedTemplateGlobals));
        }
        pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Templates")).icon("font-awesome-solid:file-code")).componentLink("qwc-qute-templates.js").staticLabel(String.valueOf(sortedTemplatePaths.size())));
        pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Extension Methods")).icon("font-awesome-solid:puzzle-piece")).componentLink("qwc-qute-extension-methods.js").staticLabel(String.valueOf(sortedExtensionMethods.size())));
        if (!sortedTemplateData.isEmpty()) {
            pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Template Data")).icon("font-awesome-solid:database")).componentLink("qwc-qute-template-data.js").staticLabel(String.valueOf(sortedTemplateData.size())));
        }
        if (!sortedTemplateGlobals.isEmpty()) {
            pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Global Variables")).icon("font-awesome-solid:globe")).componentLink("qwc-qute-template-globals.js").staticLabel(String.valueOf(sortedTemplateGlobals.size())));
        }
        cardPages.produce((BuildItem)pageBuildItem);
    }

    private List<Map<String, String>> createTemplateGlobalsJson(List<TemplateGlobalBuildItem> sortedTemplateGlobals) {
        ArrayList<Map<String, String>> globals = new ArrayList<Map<String, String>>();
        for (TemplateGlobalBuildItem global : sortedTemplateGlobals) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", global.getName());
            map.put("target", String.valueOf(global.getDeclaringClass()) + "#" + (String)(global.isField() ? global.getTarget().asField().name() : global.getTarget().asMethod().name() + "()"));
            globals.add(map);
        }
        return globals;
    }

    private List<Map<String, Object>> createTemplateDataJson(List<TemplateDataBuildItem> sortedTemplateData) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (TemplateDataBuildItem templateData : sortedTemplateData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("target", templateData.getTargetClass().name().toString());
            if (templateData.hasNamespace()) {
                map.put("namespace", templateData.getNamespace());
            }
            if (templateData.getIgnore() != null && templateData.getIgnore().length > 0) {
                map.put("ignores", Arrays.toString(templateData.getIgnore()));
            }
            if (templateData.isProperties()) {
                map.put("properties", true);
            }
            data.add(map);
        }
        return data;
    }

    @SuppressForbidden(reason="Type#toString() is what we want to use here")
    private List<Map<String, String>> createExtensionMethodsJson(List<TemplateExtensionMethodBuildItem> sortedExtensionMethods) {
        ArrayList<Map<String, String>> extensionMethods = new ArrayList<Map<String, String>>();
        for (TemplateExtensionMethodBuildItem templateExtensionMethod : sortedExtensionMethods) {
            HashMap<String, Object> extensionMethod = new HashMap<String, Object>();
            extensionMethod.put("name", String.valueOf(templateExtensionMethod.getMethod().declaringClass().name()) + "#" + templateExtensionMethod.getMethod().name() + "()");
            if (templateExtensionMethod.getMatchRegex() != null && !templateExtensionMethod.getMatchRegex().isEmpty()) {
                extensionMethod.put("matchRegex", templateExtensionMethod.getMatchRegex());
            } else if (!templateExtensionMethod.getMatchNames().isEmpty()) {
                extensionMethod.put("matchNames", templateExtensionMethod.getMatchNames().toString());
            } else {
                extensionMethod.put("matchName", templateExtensionMethod.getMatchName());
            }
            if (templateExtensionMethod.hasNamespace()) {
                extensionMethod.put("namespace", templateExtensionMethod.getNamespace());
            } else {
                extensionMethod.put("matchType", templateExtensionMethod.getMatchType().toString());
            }
            extensionMethods.add(extensionMethod);
        }
        return extensionMethods;
    }

    private List<Map<String, Object>> createTemplatesJson(List<TemplatePathBuildItem> sortedTemplatePaths, List<CheckedTemplateBuildItem> checkedTemplates, TemplatesAnalysisBuildItem templatesAnalysis, TemplateVariantsBuildItem variants) {
        ArrayList<Map<String, Object>> templates = new ArrayList<Map<String, Object>>();
        for (TemplatePathBuildItem templatePath : sortedTemplatePaths) {
            TemplatesAnalysisBuildItem.TemplateAnalysis analysis;
            HashMap<String, Object> template = new HashMap<String, Object>();
            template.put("path", templatePath.getPath());
            CheckedTemplateBuildItem checkedTemplate = this.findCheckedTemplate(this.getBasePath(templatePath.getPath(), variants), checkedTemplates);
            if (checkedTemplate != null) {
                template.put("checkedTemplate", checkedTemplate.getDescription());
            }
            if ((analysis = (TemplatesAnalysisBuildItem.TemplateAnalysis)templatesAnalysis.getAnalysis().stream().filter(ta -> ta.path.equals(templatePath.getPath())).findFirst().orElse(null)) != null) {
                if (!analysis.fragmentIds.isEmpty()) {
                    ArrayList fragmentIds = new ArrayList();
                    analysis.fragmentIds.forEach(fragmentIds::add);
                    template.put("fragmentIds", fragmentIds);
                }
                if (!analysis.parameterDeclarations.isEmpty()) {
                    ArrayList<String> paramDeclarations = new ArrayList<String>();
                    for (ParameterDeclaration pd : analysis.parameterDeclarations) {
                        paramDeclarations.add(String.format("{@%s %s%s}", pd.getTypeInfo().substring(1, pd.getTypeInfo().length() - 1), pd.getKey(), pd.getDefaultValue() != null ? "=" + pd.getDefaultValue().toOriginalString() : ""));
                    }
                    template.put("paramDeclarations", paramDeclarations);
                }
            }
            templates.add(template);
        }
        return templates;
    }

    private String getBasePath(String path, TemplateVariantsBuildItem variants) {
        for (Map.Entry<String, List<String>> e : variants.getVariants().entrySet()) {
            if (!e.getValue().contains(path)) continue;
            return e.getKey();
        }
        return null;
    }

    private CheckedTemplateBuildItem findCheckedTemplate(String basePath, List<CheckedTemplateBuildItem> checkedTemplates) {
        if (basePath != null) {
            for (CheckedTemplateBuildItem checkedTemplate : checkedTemplates) {
                if (checkedTemplate.isFragment() || !checkedTemplate.templateId.equals(basePath)) continue;
                return checkedTemplate;
            }
        }
        return null;
    }
}

