/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime.extensions;

import io.quarkus.qute.TemplateExtension;
import jakarta.enterprise.inject.Vetoed;
import java.util.Locale;
import java.util.Objects;

@Vetoed
public class StringTemplateExtensions {
    static final String STR = "str";

    @TemplateExtension(matchNames={"fmt", "format"}, priority=2)
    static String fmtInstance(String format, String ignoredPropertyName, Object ... args) {
        return String.format(format, args);
    }

    @TemplateExtension(matchNames={"fmt", "format"}, priority=3)
    static String fmtInstance(String format, String ignoredPropertyName, Locale locale, Object ... args) {
        return String.format(locale, format, args);
    }

    @TemplateExtension(namespace="str", matchNames={"fmt", "format"}, priority=2)
    static String fmt(String ignoredPropertyName, String format, Object ... args) {
        return String.format(format, args);
    }

    @TemplateExtension(namespace="str", matchNames={"fmt", "format"}, priority=3)
    static String fmt(String ignoredPropertyName, Locale locale, String format, Object ... args) {
        return String.format(locale, format, args);
    }

    @TemplateExtension(matchName="+")
    static String plus(String str, Object val) {
        return str + String.valueOf(val);
    }

    @TemplateExtension(namespace="str", priority=1)
    static String concat(Object ... args) {
        StringBuilder b = new StringBuilder(args.length * 10);
        for (Object obj : args) {
            b.append(obj.toString());
        }
        return b.toString();
    }

    @TemplateExtension(namespace="str", priority=0)
    static String join(String delimiter, Object ... args) {
        CharSequence[] elements = new CharSequence[args.length];
        for (int i = 0; i < args.length; ++i) {
            elements[i] = args[i].toString();
        }
        return String.join((CharSequence)delimiter, elements);
    }

    @TemplateExtension(namespace="str", priority=-1)
    static StringBuilder builder() {
        return new StringBuilder();
    }

    @TemplateExtension(namespace="str", priority=-2)
    static StringBuilder builder(Object val) {
        return new StringBuilder(Objects.toString(val));
    }

    @TemplateExtension(namespace="str", priority=-10, matchName="*")
    static String self(String name) {
        return name;
    }

    @TemplateExtension(matchName="+")
    static StringBuilder plus(StringBuilder builder, Object val) {
        return builder.append(val);
    }
}

